/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.options;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import org.gradle.api.NonNullApi;
import org.gradle.api.internal.tasks.options.AbstractOptionElement;
import org.gradle.api.internal.tasks.options.MultipleValueOptionElement;
import org.gradle.api.internal.tasks.options.OptionElement;
import org.gradle.api.internal.tasks.options.OptionValidationException;
import org.gradle.api.internal.tasks.options.OptionValueNotationParserFactory;
import org.gradle.api.internal.tasks.options.PropertySetter;
import org.gradle.api.provider.HasMultipleValues;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.options.Option;
import org.gradle.internal.Cast;
import org.gradle.internal.impldep.org.apache.commons.lang.StringUtils;
import org.gradle.internal.reflect.JavaMethod;
import org.gradle.model.internal.type.ModelType;

public class FieldOptionElement {
    public static OptionElement create(Option option, Field field, OptionValueNotationParserFactory optionValueNotationParserFactory) {
        String optionName = FieldOptionElement.calOptionName(option, field);
        Class<?> fieldType = field.getType();
        if (Property.class.isAssignableFrom(fieldType)) {
            PropertySetter setter = FieldOptionElement.mutateUsingGetter(field);
            return AbstractOptionElement.of(optionName, option, setter, optionValueNotationParserFactory);
        }
        if (HasMultipleValues.class.isAssignableFrom(fieldType)) {
            PropertySetter setter = FieldOptionElement.mutateUsingGetter(field);
            Class<?> elementType = setter.getRawType();
            return new MultipleValueOptionElement(optionName, option, elementType, setter, optionValueNotationParserFactory);
        }
        PropertySetter setter = FieldOptionElement.mutateUsingSetter(field);
        return AbstractOptionElement.of(optionName, option, setter, optionValueNotationParserFactory);
    }

    private static PropertySetter mutateUsingSetter(Field field) {
        return new FieldSetter(FieldOptionElement.getSetter(field), field);
    }

    private static PropertySetter mutateUsingGetter(Field field) {
        if (HasMultipleValues.class.isAssignableFrom(field.getType())) {
            return new MultipleValuePropertyFieldSetter(FieldOptionElement.getGetter(field), field);
        }
        return new PropertyFieldSetter(FieldOptionElement.getGetter(field), field);
    }

    private static String calOptionName(Option option, Field field) {
        if (option.option().length() == 0) {
            return field.getName();
        }
        return option.option();
    }

    private static Method getSetter(Field field) {
        try {
            String setterName = "set" + StringUtils.capitalize((String)field.getName());
            return field.getDeclaringClass().getMethod(setterName, field.getType());
        }
        catch (NoSuchMethodException e) {
            throw new OptionValidationException(String.format("No setter for Option annotated field '%s' in class '%s'.", field.getName(), field.getDeclaringClass()));
        }
    }

    private static Method getGetter(Field field) {
        try {
            String getterName = "get" + StringUtils.capitalize((String)field.getName());
            return field.getDeclaringClass().getMethod(getterName, new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new OptionValidationException(String.format("No getter for Option annotated field '%s' in class '%s'.", field.getName(), field.getDeclaringClass()));
        }
    }

    @NonNullApi
    private static class MultipleValuePropertyFieldSetter
    extends PropertyFieldSetter {
        public MultipleValuePropertyFieldSetter(Method getter, Field field) {
            super(getter, field);
        }

        @Override
        public void setValue(Object target, Object value) {
            HasMultipleValues property2 = (HasMultipleValues)Cast.uncheckedNonnullCast(JavaMethod.of(Object.class, this.getGetter()).invoke(target, new Object[0]));
            property2.set((Iterable)value);
        }
    }

    private static class PropertyFieldSetter
    implements PropertySetter {
        private final Method getter;
        private final Field field;
        private final Class<?> elementType;

        public PropertyFieldSetter(Method getter, Field field) {
            this.getter = getter;
            this.field = field;
            this.elementType = ModelType.of(getter.getGenericReturnType()).getTypeVariables().get(0).getRawClass();
        }

        @Override
        public Class<?> getDeclaringClass() {
            return this.field.getDeclaringClass();
        }

        @Override
        public Class<?> getRawType() {
            return this.elementType;
        }

        @Override
        public Type getGenericType() {
            return this.elementType;
        }

        @Override
        public void setValue(Object target, Object value) {
            Property property2 = (Property)Cast.uncheckedNonnullCast(JavaMethod.of(Object.class, this.getter).invoke(target, new Object[0]));
            property2.set(value);
        }

        protected Method getGetter() {
            return this.getter;
        }
    }

    private static class FieldSetter
    implements PropertySetter {
        private final Method setter;
        private final Field field;

        public FieldSetter(Method setter, Field field) {
            this.setter = setter;
            this.field = field;
        }

        @Override
        public Class<?> getDeclaringClass() {
            return this.field.getDeclaringClass();
        }

        @Override
        public Class<?> getRawType() {
            return this.setter.getParameterTypes()[0];
        }

        @Override
        public Type getGenericType() {
            return this.setter.getGenericParameterTypes()[0];
        }

        @Override
        public void setValue(Object target, Object value) {
            JavaMethod.of(Object.class, this.setter).invoke(target, value);
        }
    }
}

