/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.caching.configuration.internal;

import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.caching.BuildCacheServiceFactory;
import org.gradle.caching.configuration.BuildCache;
import org.gradle.caching.configuration.internal.BuildCacheConfigurationInternal;
import org.gradle.caching.configuration.internal.BuildCacheServiceRegistration;
import org.gradle.caching.configuration.internal.DefaultBuildCacheServiceRegistration;
import org.gradle.caching.local.DirectoryBuildCache;
import org.gradle.internal.Actions;
import org.gradle.internal.Cast;
import org.gradle.internal.impldep.com.google.common.base.Preconditions;
import org.gradle.internal.impldep.com.google.common.collect.Sets;
import org.gradle.internal.reflect.Instantiator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultBuildCacheConfiguration
implements BuildCacheConfigurationInternal {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultBuildCacheConfiguration.class);
    private final Instantiator instantiator;
    private DirectoryBuildCache local;
    private BuildCache remote;
    private Set<BuildCacheServiceRegistration> registrations;

    public DefaultBuildCacheConfiguration(Instantiator instantiator2, List<BuildCacheServiceRegistration> allBuiltInBuildCacheServices) {
        this.instantiator = instantiator2;
        this.registrations = Sets.newHashSet(allBuiltInBuildCacheServices);
        this.local = DefaultBuildCacheConfiguration.createLocalCacheConfiguration(instantiator2, this.registrations);
    }

    @Override
    public DirectoryBuildCache getLocal() {
        return this.local;
    }

    @Override
    public void setLocal(DirectoryBuildCache local) {
        this.local = local;
    }

    private <T extends DirectoryBuildCache> T localInternal(Class<T> type, Action<? super T> configuration) {
        if (!type.equals(DirectoryBuildCache.class)) {
            throw new IllegalArgumentException("Using a local build cache type other than " + DirectoryBuildCache.class.getSimpleName() + " is not allowed");
        }
        DirectoryBuildCache configurationObject = (DirectoryBuildCache)Cast.uncheckedNonnullCast(this.local);
        configuration.execute(configurationObject);
        return (T)configurationObject;
    }

    @Override
    public void local(Action<? super DirectoryBuildCache> configuration) {
        configuration.execute(this.local);
    }

    @Override
    @Nullable
    public BuildCache getRemote() {
        return this.remote;
    }

    @Override
    public void setRemote(@Nullable BuildCache remote) {
        this.remote = remote;
    }

    @Override
    public <T extends BuildCache> T remote(Class<T> type) {
        return this.remote(type, Actions.doNothing());
    }

    @Override
    public <T extends BuildCache> T remote(Class<T> type, Action<? super T> configuration) {
        if (!type.isInstance(this.remote)) {
            if (this.remote != null) {
                LOGGER.info("Replacing remote build cache type {} with {}", (Object)this.remote.getClass().getCanonicalName(), (Object)type.getCanonicalName());
            }
            this.remote = DefaultBuildCacheConfiguration.createRemoteCacheConfiguration(this.instantiator, type, this.registrations);
        }
        BuildCache configurationObject = (BuildCache)Cast.uncheckedNonnullCast(this.remote);
        configuration.execute(configurationObject);
        return (T)configurationObject;
    }

    @Override
    public void remote(Action<? super BuildCache> configuration) {
        if (this.remote == null) {
            throw new IllegalStateException("A type for the remote build cache must be configured first.");
        }
        configuration.execute(this.remote);
    }

    @Override
    public Set<BuildCacheServiceRegistration> getRegistrations() {
        return this.registrations;
    }

    @Override
    public void setRegistrations(Set<BuildCacheServiceRegistration> registrations) {
        this.registrations = registrations;
    }

    private static DirectoryBuildCache createLocalCacheConfiguration(Instantiator instantiator2, Set<BuildCacheServiceRegistration> registrations) {
        DirectoryBuildCache local = DefaultBuildCacheConfiguration.createBuildCacheConfiguration(instantiator2, DirectoryBuildCache.class, registrations);
        local.setPush(true);
        return local;
    }

    private static <T extends BuildCache> T createRemoteCacheConfiguration(Instantiator instantiator2, Class<T> type, Set<BuildCacheServiceRegistration> registrations) {
        T remote = DefaultBuildCacheConfiguration.createBuildCacheConfiguration(instantiator2, type, registrations);
        remote.setPush(false);
        return remote;
    }

    private static <T extends BuildCache> T createBuildCacheConfiguration(Instantiator instantiator2, Class<T> type, Set<BuildCacheServiceRegistration> registrations) {
        DefaultBuildCacheConfiguration.getBuildCacheServiceFactoryType(type, registrations);
        return (T)((BuildCache)instantiator2.newInstance(type, new Object[0]));
    }

    @Override
    public <T extends BuildCache> void registerBuildCacheService(Class<T> configurationType, Class<? extends BuildCacheServiceFactory<? super T>> buildCacheServiceFactoryType) {
        Preconditions.checkNotNull(configurationType, (Object)"configurationType cannot be null.");
        Preconditions.checkNotNull(buildCacheServiceFactoryType, (Object)"buildCacheServiceFactoryType cannot be null.");
        this.registrations.add(new DefaultBuildCacheServiceRegistration(configurationType, buildCacheServiceFactoryType));
    }

    @Override
    public <T extends BuildCache> Class<? extends BuildCacheServiceFactory<T>> getBuildCacheServiceFactoryType(Class<T> configurationType) {
        return DefaultBuildCacheConfiguration.getBuildCacheServiceFactoryType(configurationType, this.registrations);
    }

    private static <T extends BuildCache> Class<? extends BuildCacheServiceFactory<T>> getBuildCacheServiceFactoryType(Class<T> configurationType, Set<BuildCacheServiceRegistration> registrations) {
        for (BuildCacheServiceRegistration registration : registrations) {
            Class<? extends BuildCache> registeredConfigurationType = registration.getConfigurationType();
            if (!registeredConfigurationType.isAssignableFrom(configurationType)) continue;
            Class<? extends BuildCacheServiceFactory<?>> buildCacheServiceFactoryType = registration.getFactoryType();
            LOGGER.debug("Found {} registered for {}", buildCacheServiceFactoryType, registeredConfigurationType);
            return (Class)Cast.uncheckedNonnullCast(buildCacheServiceFactoryType);
        }
        throw new GradleException("Build cache type '" + configurationType.getName() + "' has not been registered.");
    }
}

