/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.external.descriptor;

import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.internal.component.model.Exclude;
import org.gradle.internal.component.model.IvyArtifactName;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSet;

public class DefaultExclude
implements Exclude {
    private final ModuleIdentifier moduleId;
    private final IvyArtifactName artifact;
    private final Set<String> configurations;
    private final String patternMatcher;

    public DefaultExclude(ModuleIdentifier id, IvyArtifactName artifact, String[] configurations, @Nullable String patternMatcher) {
        this.moduleId = id;
        this.artifact = artifact;
        this.patternMatcher = patternMatcher;
        this.configurations = ImmutableSet.copyOf((Object[])configurations);
    }

    public DefaultExclude(ModuleIdentifier id, String[] configurations, @Nullable String patternMatcher) {
        this.moduleId = id;
        this.artifact = null;
        this.patternMatcher = patternMatcher;
        this.configurations = ImmutableSet.copyOf((Object[])configurations);
    }

    public DefaultExclude(ModuleIdentifier id) {
        this.moduleId = id;
        this.artifact = null;
        this.patternMatcher = null;
        this.configurations = ImmutableSet.of();
    }

    public String toString() {
        return "{exclude moduleId: " + this.moduleId + ", artifact: " + this.artifact + "}";
    }

    @Override
    public ModuleIdentifier getModuleId() {
        return this.moduleId;
    }

    @Override
    public IvyArtifactName getArtifact() {
        return this.artifact;
    }

    @Override
    public Set<String> getConfigurations() {
        return this.configurations;
    }

    @Override
    public String getMatcher() {
        return this.patternMatcher;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultExclude that = (DefaultExclude)o;
        if (!this.moduleId.equals(that.moduleId)) {
            return false;
        }
        if (!Objects.equals(this.artifact, that.artifact)) {
            return false;
        }
        if (!this.configurations.equals(that.configurations)) {
            return false;
        }
        return Objects.equals(this.patternMatcher, that.patternMatcher);
    }

    public int hashCode() {
        int result2 = this.moduleId.hashCode();
        result2 = 31 * result2 + (this.artifact != null ? this.artifact.hashCode() : 0);
        result2 = 31 * result2 + this.configurations.hashCode();
        result2 = 31 * result2 + (this.patternMatcher != null ? this.patternMatcher.hashCode() : 0);
        return result2;
    }
}

