/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.properties.bean;

import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.gradle.api.Buildable;
import org.gradle.api.NonNullApi;
import org.gradle.api.internal.provider.HasConfigurableValueInternal;
import org.gradle.api.internal.tasks.TaskDependencyContainer;
import org.gradle.api.provider.HasConfigurableValue;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.deprecation.DeprecationLogger;
import org.gradle.internal.impldep.com.google.common.base.Suppliers;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableMap;
import org.gradle.internal.properties.PropertyValue;
import org.gradle.internal.properties.PropertyVisitor;
import org.gradle.internal.properties.annotations.NestedValidationUtil;
import org.gradle.internal.properties.annotations.PropertyAnnotationHandler;
import org.gradle.internal.properties.annotations.PropertyMetadata;
import org.gradle.internal.properties.annotations.TypeMetadata;
import org.gradle.internal.properties.annotations.TypeMetadataStore;
import org.gradle.internal.properties.annotations.TypeMetadataWalker;
import org.gradle.internal.properties.bean.ImplementationResolver;
import org.gradle.internal.properties.bean.PropertyWalker;
import org.gradle.internal.reflect.validation.TypeValidationContext;
import org.gradle.internal.snapshot.impl.ImplementationValue;

@NonNullApi
public class DefaultPropertyWalker
implements PropertyWalker {
    private final TypeMetadataWalker.InstanceMetadataWalker walker;
    private final ImplementationResolver implementationResolver;
    private final Map<Class<? extends Annotation>, PropertyAnnotationHandler> handlers;

    public DefaultPropertyWalker(TypeMetadataStore typeMetadataStore, ImplementationResolver implementationResolver, Collection<PropertyAnnotationHandler> propertyHandlers) {
        this.walker = TypeMetadataWalker.instanceWalker(typeMetadataStore, Nested.class);
        this.implementationResolver = implementationResolver;
        this.handlers = (Map)propertyHandlers.stream().collect(ImmutableMap.toImmutableMap(PropertyAnnotationHandler::getAnnotationType, Function.identity()));
    }

    @Override
    public void visitProperties(Object bean, final TypeValidationContext validationContext, final PropertyVisitor visitor) {
        this.walker.walk(bean, new TypeMetadataWalker.InstanceMetadataVisitor(){

            @Override
            public void visitRoot(TypeMetadata typeMetadata, Object value) {
                typeMetadata.visitValidationFailures(null, validationContext);
            }

            @Override
            public void visitNested(TypeMetadata typeMetadata, String qualifiedName, PropertyMetadata propertyMetadata, @Nullable Object value) {
                typeMetadata.visitValidationFailures(qualifiedName, validationContext);
                if (value != null) {
                    NestedValidationUtil.validateBeanType(validationContext, propertyMetadata.getPropertyName(), typeMetadata.getType());
                    ImplementationValue implementation = DefaultPropertyWalker.this.implementationResolver.resolveImplementation(value);
                    visitor.visitInputProperty(qualifiedName, new ImplementationPropertyValue(implementation), false);
                } else if (!propertyMetadata.isAnnotationPresent(Optional.class)) {
                    visitor.visitInputProperty(qualifiedName, PropertyValue.ABSENT, false);
                }
            }

            @Override
            public void visitNestedUnpackingError(String qualifiedName, Exception e) {
                visitor.visitInputProperty(qualifiedName, new InvalidValue(e), false);
            }

            @Override
            public void visitLeaf(Object parent, String qualifiedName, PropertyMetadata propertyMetadata) {
                CachedPropertyValue cachedValue = new CachedPropertyValue(() -> propertyMetadata.getPropertyValue(parent), propertyMetadata.getDeclaredType().getRawType());
                PropertyAnnotationHandler handler = (PropertyAnnotationHandler)DefaultPropertyWalker.this.handlers.get(propertyMetadata.getPropertyType());
                if (handler == null) {
                    throw new IllegalStateException("Property handler should not be null for: " + propertyMetadata.getPropertyType());
                }
                handler.visitPropertyValue(qualifiedName, cachedValue, propertyMetadata, visitor);
            }
        });
    }

    private static class InvalidValue
    implements PropertyValue {
        private final Exception exception;

        public InvalidValue(Exception exception) {
            this.exception = exception;
        }

        @Override
        @Nullable
        public Object call() {
            throw UncheckedException.throwAsUncheckedException(this.exception);
        }

        @Override
        public TaskDependencyContainer getTaskDependencies() {
            return TaskDependencyContainer.EMPTY;
        }

        @Override
        public void maybeFinalizeValue() {
        }

        public String toString() {
            return "INVALID: " + this.exception.getMessage();
        }
    }

    private static class ImplementationPropertyValue
    implements PropertyValue {
        private final ImplementationValue implementationValue;

        public ImplementationPropertyValue(ImplementationValue implementationValue) {
            this.implementationValue = implementationValue;
        }

        @Override
        public Object call() {
            return this.implementationValue;
        }

        @Override
        public TaskDependencyContainer getTaskDependencies() {
            return TaskDependencyContainer.EMPTY;
        }

        @Override
        public void maybeFinalizeValue() {
        }

        public String toString() {
            return "Implementation: " + this.implementationValue;
        }
    }

    private static class CachedPropertyValue
    implements PropertyValue {
        private final Supplier<Object> cachedInvoker;
        private final Class<?> declaredType;

        public CachedPropertyValue(Supplier<Object> supplier, Class<?> declaredType) {
            this.declaredType = declaredType;
            this.cachedInvoker = Suppliers.memoize(() -> DeprecationLogger.whileDisabled(((Supplier)supplier)::get));
        }

        @Override
        public TaskDependencyContainer getTaskDependencies() {
            if (this.isProvider()) {
                return (TaskDependencyContainer)this.cachedInvoker.get();
            }
            if (this.isBuildable()) {
                return context -> {
                    Object dependency = this.cachedInvoker.get();
                    if (dependency != null) {
                        context.add(dependency);
                    }
                };
            }
            return TaskDependencyContainer.EMPTY;
        }

        @Override
        public void maybeFinalizeValue() {
            if (this.isConfigurable()) {
                Object value = this.cachedInvoker.get();
                ((HasConfigurableValueInternal)value).implicitFinalizeValue();
            }
        }

        private boolean isProvider() {
            return Provider.class.isAssignableFrom(this.declaredType);
        }

        private boolean isConfigurable() {
            return HasConfigurableValue.class.isAssignableFrom(this.declaredType);
        }

        private boolean isBuildable() {
            return Buildable.class.isAssignableFrom(this.declaredType);
        }

        @Override
        @Nullable
        public Object call() {
            return this.cachedInvoker.get();
        }
    }
}

