/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resolve.resolver;

import java.util.List;
import javax.annotation.Nullable;
import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.artifacts.component.ComponentArtifactIdentifier;
import org.gradle.api.capabilities.CapabilitiesMetadata;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ArtifactBackedResolvedVariant;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvedVariant;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvedVariantCache;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.specs.ExcludeSpec;
import org.gradle.api.internal.artifacts.type.ArtifactTypeRegistry;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.internal.Describables;
import org.gradle.internal.DisplayName;
import org.gradle.internal.component.external.model.DefaultImmutableCapability;
import org.gradle.internal.component.external.model.ImmutableCapabilities;
import org.gradle.internal.component.model.ComponentArtifactMetadata;
import org.gradle.internal.component.model.ComponentArtifactResolveMetadata;
import org.gradle.internal.component.model.DefaultVariantMetadata;
import org.gradle.internal.component.model.VariantResolveMetadata;
import org.gradle.internal.component.model.VariantWithOverloadAttributes;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;
import org.gradle.internal.resolve.resolver.ArtifactResolver;
import org.gradle.internal.resolve.resolver.DefaultComponentArtifactResolver;
import org.gradle.internal.resolve.resolver.VariantArtifactResolver;

public class DefaultVariantArtifactResolver
implements VariantArtifactResolver {
    private final ArtifactTypeRegistry artifactTypeRegistry;
    private final ArtifactResolver artifactResolver;
    private final ResolvedVariantCache resolvedVariantCache;

    public DefaultVariantArtifactResolver(ArtifactResolver artifactResolver, ArtifactTypeRegistry artifactTypeRegistry, ResolvedVariantCache resolvedVariantCache) {
        this.artifactTypeRegistry = artifactTypeRegistry;
        this.artifactResolver = artifactResolver;
        this.resolvedVariantCache = resolvedVariantCache;
    }

    @Override
    public ResolvedVariant resolveAdhocVariant(ComponentArtifactResolveMetadata component, ImmutableList<? extends ComponentArtifactMetadata> artifacts2) {
        SingleArtifactVariantIdentifier identifier = artifacts2.size() == 1 ? new SingleArtifactVariantIdentifier(((ComponentArtifactMetadata)artifacts2.iterator().next()).getId()) : null;
        DefaultVariantMetadata adhoc = new DefaultVariantMetadata("adhoc", identifier, Describables.of("adhoc variant for", component.getId()), component.getAttributes(), artifacts2, ImmutableCapabilities.EMPTY);
        return this.toResolvedVariant(component, adhoc, identifier, artifacts2);
    }

    @Override
    public ResolvedVariant resolveVariant(ComponentArtifactResolveMetadata component, VariantResolveMetadata variant) {
        return this.toResolvedVariant(component, variant, variant.getIdentifier(), variant.getArtifacts());
    }

    @Override
    public ResolvedVariant resolveVariant(ComponentArtifactResolveMetadata component, VariantResolveMetadata variant, ExcludeSpec exclusions) {
        ImmutableList<? extends ComponentArtifactMetadata> sourceArtifacts = variant.getArtifacts();
        ImmutableList<ComponentArtifactMetadata> overrideArtifacts = DefaultVariantArtifactResolver.maybeExcludeArtifacts(component, sourceArtifacts, exclusions);
        if (overrideArtifacts != null) {
            return this.toResolvedVariant(component, variant, null, overrideArtifacts);
        }
        return this.toResolvedVariant(component, variant, variant.getIdentifier(), sourceArtifacts);
    }

    @Nullable
    private static ImmutableList<ComponentArtifactMetadata> maybeExcludeArtifacts(ComponentArtifactResolveMetadata component, ImmutableList<? extends ComponentArtifactMetadata> artifacts2, ExcludeSpec exclusions) {
        ModuleIdentifier module = component.getModuleVersionId().getModule();
        boolean hasExcludedArtifact = false;
        ImmutableList.Builder artifactsToResolveBuilder = ImmutableList.builderWithExpectedSize((int)artifacts2.size());
        for (ComponentArtifactMetadata artifact : artifacts2) {
            if (!exclusions.excludesArtifact(module, artifact.getName())) {
                artifactsToResolveBuilder.add((Object)artifact);
                continue;
            }
            hasExcludedArtifact = true;
        }
        if (hasExcludedArtifact) {
            return artifactsToResolveBuilder.build();
        }
        return null;
    }

    private ResolvedVariant toResolvedVariant(ComponentArtifactResolveMetadata component, VariantResolveMetadata variant, @Nullable VariantResolveMetadata.Identifier identifier, ImmutableList<? extends ComponentArtifactMetadata> artifacts2) {
        ImmutableAttributes attributes = this.artifactTypeRegistry.mapAttributesFor(variant.getAttributes(), (Iterable<? extends ComponentArtifactMetadata>)artifacts2);
        if (identifier == null || !variant.isEligibleForCaching()) {
            DisplayName displayName = variant.asDescribable();
            ImmutableCapabilities capabilities = DefaultVariantArtifactResolver.withImplicitCapability(variant.getCapabilities(), component);
            return new ArtifactBackedResolvedVariant(identifier, displayName, attributes, capabilities, (List<? extends ComponentArtifactMetadata>)artifacts2, new DefaultComponentArtifactResolver(component, this.artifactResolver));
        }
        return this.resolvedVariantCache.computeIfAbsent(new VariantWithOverloadAttributes(identifier, attributes), id -> {
            DisplayName displayName = variant.asDescribable();
            ImmutableCapabilities capabilities = DefaultVariantArtifactResolver.withImplicitCapability(variant.getCapabilities(), component);
            return new ArtifactBackedResolvedVariant(identifier, displayName, attributes, capabilities, (List<? extends ComponentArtifactMetadata>)artifacts2, new DefaultComponentArtifactResolver(component, this.artifactResolver));
        });
    }

    private static ImmutableCapabilities withImplicitCapability(CapabilitiesMetadata capabilitiesMetadata, ComponentArtifactResolveMetadata component) {
        if (capabilitiesMetadata.getCapabilities().isEmpty()) {
            return ImmutableCapabilities.of(DefaultImmutableCapability.defaultCapabilityForComponent(component.getModuleVersionId()));
        }
        return ImmutableCapabilities.of(capabilitiesMetadata);
    }

    private static class SingleArtifactVariantIdentifier
    implements VariantResolveMetadata.Identifier {
        private final ComponentArtifactIdentifier artifactIdentifier;

        public SingleArtifactVariantIdentifier(ComponentArtifactIdentifier artifactIdentifier) {
            this.artifactIdentifier = artifactIdentifier;
        }

        public int hashCode() {
            return this.artifactIdentifier.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            SingleArtifactVariantIdentifier other = (SingleArtifactVariantIdentifier)obj;
            return this.artifactIdentifier.equals(other.artifactIdentifier);
        }
    }
}

