/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resources;

import java.util.Map;
import org.gradle.internal.impldep.com.google.common.collect.Maps;
import org.gradle.internal.resources.AbstractResourceLockRegistry;
import org.gradle.internal.resources.DefaultLease;
import org.gradle.internal.resources.LeaseHolder;
import org.gradle.internal.resources.ResourceLock;
import org.gradle.internal.resources.ResourceLockCoordinationService;

public class SharedResourceLeaseRegistry
extends AbstractResourceLockRegistry<String, ResourceLock> {
    private final Map<String, LeaseHolder> sharedResources = Maps.newConcurrentMap();
    private final ResourceLockCoordinationService coordinationService;

    public SharedResourceLeaseRegistry(ResourceLockCoordinationService coordinationService) {
        super(coordinationService);
        this.coordinationService = coordinationService;
    }

    public void registerSharedResource(String name, int leases) {
        this.sharedResources.put(name, new LeaseHolder(leases));
    }

    public ResourceLock getResourceLock(String sharedResource) {
        String displayName = "lease for " + sharedResource;
        return new DefaultLease(displayName, this.coordinationService, this, this.sharedResources.get(sharedResource));
    }
}

