/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.rules;

import groovy.lang.Closure;
import org.gradle.api.Action;
import org.gradle.api.InvalidUserCodeException;
import org.gradle.internal.rules.ClosureBackedRuleAction;
import org.gradle.internal.rules.NoInputsRuleAction;
import org.gradle.internal.rules.RuleAction;
import org.gradle.internal.rules.RuleActionAdapter;
import org.gradle.internal.rules.RuleActionValidationException;
import org.gradle.internal.rules.RuleActionValidator;
import org.gradle.internal.rules.RuleSourceBackedRuleAction;
import org.gradle.model.internal.type.ModelType;

public class DefaultRuleActionAdapter
implements RuleActionAdapter {
    private static final String INVALID_CLOSURE_ERROR = "The closure provided is not valid as a rule for '%s'.";
    private static final String INVALID_ACTION_ERROR = "The action provided is not valid as a rule for '%s'.";
    private static final String INVALID_RULE_SOURCE_ERROR = "The rule source provided does not provide a valid rule for '%s'.";
    private final RuleActionValidator ruleActionValidator;
    private final String context;

    public DefaultRuleActionAdapter(RuleActionValidator ruleActionValidator, String context) {
        this.ruleActionValidator = ruleActionValidator;
        this.context = context;
    }

    @Override
    public <T> RuleAction<? super T> createFromClosure(Class<T> subjectType, Closure<?> closure) {
        try {
            return this.ruleActionValidator.validate(new ClosureBackedRuleAction<T>(subjectType, closure));
        }
        catch (RuleActionValidationException e) {
            throw new InvalidUserCodeException(String.format(INVALID_CLOSURE_ERROR, this.context), e);
        }
    }

    @Override
    public <T> RuleAction<? super T> createFromAction(Action<? super T> action) {
        try {
            return this.ruleActionValidator.validate(new NoInputsRuleAction<T>(action));
        }
        catch (RuleActionValidationException e) {
            throw new InvalidUserCodeException(String.format(INVALID_ACTION_ERROR, this.context), e);
        }
    }

    @Override
    public <T> RuleAction<? super T> createFromRuleSource(Class<T> subjectType, Object ruleSource) {
        try {
            return this.ruleActionValidator.validate(RuleSourceBackedRuleAction.create(ModelType.of(subjectType), ruleSource));
        }
        catch (RuleActionValidationException e) {
            throw new InvalidUserCodeException(String.format(INVALID_RULE_SOURCE_ERROR, this.context), e);
        }
    }
}

