/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.snapshot.impl;

import java.lang.invoke.SerializedLambda;
import java.util.Objects;
import javax.annotation.Nullable;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.hash.Hasher;
import org.gradle.internal.snapshot.impl.ImplementationSnapshot;

public class LambdaImplementationSnapshot
extends ImplementationSnapshot {
    private final HashCode classLoaderHash;
    private final String functionalInterfaceClass;
    private final String implClass;
    private final String implMethodName;
    private final String implMethodSignature;
    private final int implMethodKind;

    public LambdaImplementationSnapshot(HashCode classLoaderHash, SerializedLambda lambda) {
        this(lambda.getCapturingClass(), classLoaderHash, lambda.getFunctionalInterfaceClass(), lambda.getImplClass(), lambda.getImplMethodName(), lambda.getImplMethodSignature(), lambda.getImplMethodKind());
    }

    public LambdaImplementationSnapshot(String capturingClass, HashCode classLoaderHash, String functionalInterfaceClass, String implClass, String implMethodName, String implMethodSignature, int implMethodKind) {
        super(capturingClass);
        this.classLoaderHash = classLoaderHash;
        this.functionalInterfaceClass = functionalInterfaceClass;
        this.implClass = implClass;
        this.implMethodName = implMethodName;
        this.implMethodSignature = implMethodSignature;
        this.implMethodKind = implMethodKind;
    }

    @Override
    public void appendToHasher(Hasher hasher) {
        hasher.putString(LambdaImplementationSnapshot.class.getName());
        hasher.putString(this.classIdentifier);
        hasher.putHash(this.classLoaderHash);
        hasher.putString(this.functionalInterfaceClass);
        hasher.putString(this.implClass);
        hasher.putString(this.implMethodName);
        hasher.putString(this.implMethodSignature);
        hasher.putInt(this.implMethodKind);
    }

    @Override
    @Nullable
    public HashCode getClassLoaderHash() {
        return this.classLoaderHash;
    }

    public String getFunctionalInterfaceClass() {
        return this.functionalInterfaceClass;
    }

    public String getImplClass() {
        return this.implClass;
    }

    public String getImplMethodName() {
        return this.implMethodName;
    }

    public String getImplMethodSignature() {
        return this.implMethodSignature;
    }

    public int getImplMethodKind() {
        return this.implMethodKind;
    }

    @Override
    protected boolean isSameSnapshot(@Nullable Object o) {
        return this.equals(o);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LambdaImplementationSnapshot that = (LambdaImplementationSnapshot)o;
        return this.classIdentifier.equals(that.classIdentifier) && this.classLoaderHash.equals(that.classLoaderHash) && this.functionalInterfaceClass.equals(that.functionalInterfaceClass) && this.implClass.equals(that.implClass) && this.implMethodName.equals(that.implMethodName) && this.implMethodSignature.equals(that.implMethodSignature) && this.implMethodKind == that.implMethodKind;
    }

    public int hashCode() {
        return Objects.hash(this.classIdentifier, this.classLoaderHash, this.functionalInterfaceClass, this.implClass, this.implMethodName, this.implMethodSignature, this.implMethodKind);
    }

    public String toString() {
        return this.classIdentifier + "::" + this.implMethodName + "@" + this.classLoaderHash;
    }
}

