/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.core.rule.describe;

import java.io.IOException;
import javax.annotation.concurrent.ThreadSafe;
import org.gradle.api.UncheckedIOException;
import org.gradle.internal.Factories;
import org.gradle.internal.Factory;
import org.gradle.internal.impldep.com.google.common.base.Objects;
import org.gradle.model.internal.core.rule.describe.AbstractModelRuleDescriptor;

@ThreadSafe
public class SimpleModelRuleDescriptor
extends AbstractModelRuleDescriptor {
    private final Factory<String> factory;

    public SimpleModelRuleDescriptor(final Factory<String> descriptor) {
        this.factory = new Factory<String>(){
            String cachedValue;

            @Override
            public String create() {
                if (this.cachedValue == null) {
                    this.cachedValue = AbstractModelRuleDescriptor.STRING_INTERNER.intern((String)descriptor.create());
                }
                return this.cachedValue;
            }
        };
    }

    public SimpleModelRuleDescriptor(String descriptor) {
        this(Factories.constant(STRING_INTERNER.intern(descriptor)));
    }

    public SimpleModelRuleDescriptor(final String descriptor, final Object ... args) {
        this(new Factory<String>(){

            @Override
            public String create() {
                return String.format(descriptor, args);
            }
        });
    }

    private String getDescriptor() {
        return this.factory.create();
    }

    @Override
    public void describeTo(Appendable appendable) {
        try {
            appendable.append(this.getDescriptor());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SimpleModelRuleDescriptor that = (SimpleModelRuleDescriptor)o;
        return Objects.equal((Object)this.getDescriptor(), (Object)that.getDescriptor());
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.getDescriptor()});
    }
}

