/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.manage.schema.extract;

import org.gradle.internal.BiAction;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSetMultimap;
import org.gradle.internal.impldep.com.google.common.collect.Multimap;
import org.gradle.model.ModelMap;
import org.gradle.model.internal.core.AddProjectionsAction;
import org.gradle.model.internal.core.ChildNodeInitializerStrategy;
import org.gradle.model.internal.core.ChildNodeInitializerStrategyAccessors;
import org.gradle.model.internal.core.DirectNodeInputUsingModelAction;
import org.gradle.model.internal.core.ModelAction;
import org.gradle.model.internal.core.ModelActionRole;
import org.gradle.model.internal.core.ModelMapModelProjection;
import org.gradle.model.internal.core.ModelReference;
import org.gradle.model.internal.core.MutableModelNode;
import org.gradle.model.internal.core.NodeBackedModelMap;
import org.gradle.model.internal.core.NodeInitializer;
import org.gradle.model.internal.core.NodeInitializerContext;
import org.gradle.model.internal.core.NodeInitializerRegistry;
import org.gradle.model.internal.core.rule.describe.ModelRuleDescriptor;
import org.gradle.model.internal.manage.schema.CollectionSchema;
import org.gradle.model.internal.manage.schema.extract.CollectionNodeInitializerExtractionSupport;
import org.gradle.model.internal.type.ModelType;

public class ModelMapNodeInitializerExtractionStrategy
extends CollectionNodeInitializerExtractionSupport {
    private static final ModelType<ModelMap<?>> MODEL_MAP_MODEL_TYPE = new ModelType<ModelMap<?>>(){};

    @Override
    protected <T, E> NodeInitializer extractNodeInitializer(CollectionSchema<T, E> schema, NodeInitializerContext<T> context) {
        if (MODEL_MAP_MODEL_TYPE.isAssignableFrom(schema.getType())) {
            return new ModelMapNodeInitializer<T, E>(schema);
        }
        return null;
    }

    @Override
    public Iterable<ModelType<?>> supportedTypes() {
        return ImmutableList.of(MODEL_MAP_MODEL_TYPE);
    }

    private static class ModelMapNodeInitializer<T, E>
    implements NodeInitializer {
        private final CollectionSchema<T, E> schema;

        public ModelMapNodeInitializer(CollectionSchema<T, E> schema) {
            this.schema = schema;
        }

        @Override
        public Multimap<ModelActionRole, ModelAction> getActions(ModelReference<?> subject, ModelRuleDescriptor descriptor) {
            return ImmutableSetMultimap.builder().put((Object)ModelActionRole.Discover, AddProjectionsAction.of(subject, descriptor, ModelMapModelProjection.managed(this.schema.getType(), this.schema.getElementType(), ChildNodeInitializerStrategyAccessors.fromPrivateData()))).put((Object)ModelActionRole.Create, (Object)DirectNodeInputUsingModelAction.of(subject, descriptor, ModelReference.of(NodeInitializerRegistry.class), new BiAction<MutableModelNode, NodeInitializerRegistry>(){

                @Override
                public void execute(MutableModelNode modelNode, NodeInitializerRegistry nodeInitializerRegistry) {
                    ChildNodeInitializerStrategy childStrategy = NodeBackedModelMap.createUsingRegistry(nodeInitializerRegistry);
                    modelNode.setPrivateData(ChildNodeInitializerStrategy.class, childStrategy);
                }
            })).build();
        }
    }
}

