/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativeplatform.toolchain.internal.msvcpp;

import java.io.File;
import java.util.ArrayList;
import java.util.Map;
import org.gradle.internal.impldep.com.google.common.collect.Lists;
import org.gradle.internal.impldep.com.google.common.collect.Maps;
import org.gradle.nativeplatform.platform.Architecture;
import org.gradle.nativeplatform.platform.internal.Architectures;
import org.gradle.nativeplatform.toolchain.internal.msvcpp.ArchitectureSpecificVisualCpp;
import org.gradle.util.internal.VersionNumber;

public enum ArchitectureDescriptorBuilder {
    LEGACY_AMD64_ON_AMD64("amd64", "bin/amd64", "lib/amd64", "ml64.exe"),
    AMD64_ON_AMD64("amd64", "bin/HostX64/x64", "lib/x64", "ml64.exe"),
    LEGACY_AMD64_ON_X86("amd64", "bin/x86_amd64", "lib/amd64", "ml64.exe"){

        @Override
        File getCrossCompilePath(File basePath) {
            return LEGACY_X86_ON_X86.getBinPath(basePath);
        }
    }
    ,
    AMD64_ON_X86("amd64", "bin/HostX86/x64", "lib/x64", "ml64.exe"){

        @Override
        File getCrossCompilePath(File basePath) {
            return X86_ON_X86.getBinPath(basePath);
        }
    }
    ,
    LEGACY_X86_ON_AMD64("x86", "bin/amd64_x86", "lib", "ml.exe"){

        @Override
        File getCrossCompilePath(File basePath) {
            return LEGACY_AMD64_ON_AMD64.getBinPath(basePath);
        }
    }
    ,
    X86_ON_AMD64("x86", "bin/HostX64/x86", "lib/x86", "ml.exe"){

        @Override
        File getCrossCompilePath(File basePath) {
            return AMD64_ON_AMD64.getBinPath(basePath);
        }
    }
    ,
    LEGACY_X86_ON_X86("x86", "bin", "lib", "ml.exe"),
    X86_ON_X86("x86", "bin/HostX86/x86", "lib/x86", "ml.exe"),
    LEGACY_ARM_ON_AMD64("arm", "bin/amd64_arm", "lib/arm", "armasm.exe"){

        @Override
        File getCrossCompilePath(File basePath) {
            return LEGACY_AMD64_ON_AMD64.getBinPath(basePath);
        }

        @Override
        Map<String, String> getDefinitions() {
            Map<String, String> definitions = super.getDefinitions();
            definitions.put(ArchitectureDescriptorBuilder.DEFINE_ARMPARTITIONAVAILABLE, "1");
            return definitions;
        }
    }
    ,
    ARM_ON_AMD64("arm", "bin/Hostx64/arm", "lib/arm", "armasm.exe"){

        @Override
        File getCrossCompilePath(File basePath) {
            return AMD64_ON_AMD64.getBinPath(basePath);
        }

        @Override
        Map<String, String> getDefinitions() {
            Map<String, String> definitions = super.getDefinitions();
            definitions.put(ArchitectureDescriptorBuilder.DEFINE_ARMPARTITIONAVAILABLE, "1");
            return definitions;
        }
    }
    ,
    ARM64_ON_X86("arm64", "bin/HostX86/arm64", "lib/arm64", "armasm64.exe"),
    ARM64_ON_AMD64("arm64", "bin/Hostx64/arm64", "lib/arm64", "armasm64.exe"),
    LEGACY_ARM_ON_X86("arm", "bin/x86_arm", "lib/arm", "armasm.exe"){

        @Override
        File getCrossCompilePath(File basePath) {
            return LEGACY_X86_ON_X86.getBinPath(basePath);
        }

        @Override
        Map<String, String> getDefinitions() {
            Map<String, String> definitions = super.getDefinitions();
            definitions.put(ArchitectureDescriptorBuilder.DEFINE_ARMPARTITIONAVAILABLE, "1");
            return definitions;
        }
    }
    ,
    ARM_ON_X86("arm", "bin/HostX86/arm", "lib/arm", "armasm.exe"){

        @Override
        File getCrossCompilePath(File basePath) {
            return X86_ON_X86.getBinPath(basePath);
        }

        @Override
        Map<String, String> getDefinitions() {
            Map<String, String> definitions = super.getDefinitions();
            definitions.put(ArchitectureDescriptorBuilder.DEFINE_ARMPARTITIONAVAILABLE, "1");
            return definitions;
        }
    }
    ,
    LEGACY_IA64_ON_X86("ia64", "bin/x86_ia64", "lib/ia64", "ias.exe"){

        @Override
        File getCrossCompilePath(File basePath) {
            return LEGACY_X86_ON_X86.getBinPath(basePath);
        }
    };

    private static final String PATH_COMMON = "Common7/";
    private static final String PATH_COMMONTOOLS = "Common7/Tools/";
    private static final String PATH_COMMONIDE = "Common7/IDE/";
    private static final String PATH_INCLUDE = "include/";
    private static final String DEFINE_ARMPARTITIONAVAILABLE = "_ARM_WINAPI_PARTITION_DESKTOP_SDK_AVAILABLE";
    private static final String COMPILER_FILENAME = "cl.exe";
    final Architecture architecture;
    final String binPath;
    final String libPath;
    final String asmFilename;

    private ArchitectureDescriptorBuilder(String architecture, String binPath, String libPath, String asmFilename) {
        this.binPath = binPath;
        this.libPath = libPath;
        this.asmFilename = asmFilename;
        this.architecture = Architectures.forInput(architecture);
    }

    File getBinPath(File basePath) {
        return new File(basePath, this.binPath);
    }

    File getLibPath(File basePath) {
        return new File(basePath, this.libPath);
    }

    File getCompilerPath(File basePath) {
        return new File(this.getBinPath(basePath), COMPILER_FILENAME);
    }

    File getCrossCompilePath(File basePath) {
        return null;
    }

    Map<String, String> getDefinitions() {
        return Maps.newHashMap();
    }

    ArchitectureSpecificVisualCpp buildDescriptor(VersionNumber compilerVersion, File basePath, File vsPath) {
        File commonTools = new File(vsPath, PATH_COMMONTOOLS);
        File commonIde = new File(vsPath, PATH_COMMONIDE);
        ArrayList paths = Lists.newArrayList((Object[])new File[]{commonTools, commonIde});
        File crossCompilePath = this.getCrossCompilePath(basePath);
        if (crossCompilePath != null) {
            paths.add(crossCompilePath);
        }
        File includePath = new File(basePath, PATH_INCLUDE);
        return new ArchitectureSpecificVisualCpp(compilerVersion, paths, this.getBinPath(basePath), this.getLibPath(basePath), this.getCompilerPath(basePath), includePath, this.asmFilename, this.getDefinitions());
    }
}

