/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugins.ide.eclipse.model.internal;

import groovy.lang.Closure;
import groovy.lang.DelegatesTo;
import org.gradle.api.Action;
import org.gradle.api.InvalidUserDataException;
import org.gradle.internal.impldep.com.google.common.base.Objects;
import org.gradle.plugins.ide.eclipse.model.ResourceFilter;
import org.gradle.plugins.ide.eclipse.model.ResourceFilterAppliesTo;
import org.gradle.plugins.ide.eclipse.model.ResourceFilterMatcher;
import org.gradle.plugins.ide.eclipse.model.ResourceFilterType;
import org.gradle.plugins.ide.eclipse.model.internal.DefaultResourceFilterMatcher;
import org.gradle.util.internal.ClosureBackedAction;

public final class DefaultResourceFilter
implements ResourceFilter {
    private ResourceFilterAppliesTo appliesTo = ResourceFilterAppliesTo.FILES_AND_FOLDERS;
    private ResourceFilterType type = ResourceFilterType.EXCLUDE_ALL;
    private boolean recursive = true;
    private ResourceFilterMatcher matcher;

    public DefaultResourceFilter() {
    }

    public DefaultResourceFilter(ResourceFilterAppliesTo appliesTo, ResourceFilterType type, boolean recursive, ResourceFilterMatcher matcher) {
        this();
        this.setAppliesTo(appliesTo);
        this.setType(type);
        this.setRecursive(recursive);
        this.setMatcher(matcher);
    }

    @Override
    public ResourceFilterAppliesTo getAppliesTo() {
        return this.appliesTo;
    }

    @Override
    public void setAppliesTo(ResourceFilterAppliesTo appliesTo) {
        if (appliesTo == null) {
            throw new InvalidUserDataException("appliesTo must not be null");
        }
        this.appliesTo = appliesTo;
    }

    @Override
    public ResourceFilterType getType() {
        return this.type;
    }

    @Override
    public void setType(ResourceFilterType type) {
        if (type == null) {
            throw new InvalidUserDataException("type must not be null");
        }
        this.type = type;
    }

    @Override
    public boolean isRecursive() {
        return this.recursive;
    }

    @Override
    public void setRecursive(boolean recursive) {
        this.recursive = recursive;
    }

    @Override
    public ResourceFilterMatcher getMatcher() {
        return this.matcher;
    }

    public void setMatcher(ResourceFilterMatcher matcher) {
        this.matcher = matcher;
    }

    public ResourceFilterMatcher matcher(@DelegatesTo(value=ResourceFilterMatcher.class, strategy=1) Closure configureClosure) {
        return this.matcher(new ClosureBackedAction(configureClosure));
    }

    @Override
    public ResourceFilterMatcher matcher(Action<? super ResourceFilterMatcher> configureAction) {
        if (this.matcher == null) {
            this.matcher = new DefaultResourceFilterMatcher();
        }
        configureAction.execute(this.matcher);
        return this.matcher;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (!this.getClass().equals(o.getClass())) {
            return false;
        }
        DefaultResourceFilter resourceFilter = (DefaultResourceFilter)o;
        return Objects.equal((Object)((Object)this.appliesTo), (Object)((Object)resourceFilter.appliesTo)) && Objects.equal((Object)((Object)this.type), (Object)((Object)resourceFilter.type)) && Objects.equal((Object)this.recursive, (Object)resourceFilter.recursive) && Objects.equal((Object)this.matcher, (Object)resourceFilter.matcher);
    }

    public int hashCode() {
        int result2 = this.appliesTo != null ? this.appliesTo.hashCode() : 0;
        result2 = 31 * result2 + (this.type != null ? this.type.hashCode() : 0);
        result2 = 31 * result2 + Boolean.valueOf(this.recursive).hashCode();
        result2 = 31 * result2 + (this.matcher != null ? this.matcher.hashCode() : 0);
        return result2;
    }

    public String toString() {
        return "ResourceFilter{appliesTo='" + (Object)((Object)this.appliesTo) + '\'' + ", type='" + (Object)((Object)this.type) + '\'' + ", recursive='" + this.recursive + '\'' + ", matcher='" + this.matcher + '\'' + '}';
    }
}

