/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.util.internal;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Arrays;
import javax.annotation.Nonnull;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import org.gradle.util.internal.EncryptionAlgorithm;

public final class SupportedEncryptionAlgorithm
extends Enum<SupportedEncryptionAlgorithm>
implements EncryptionAlgorithm {
    public static final /* enum */ SupportedEncryptionAlgorithm AES_CBC_PADDING = new SupportedEncryptionAlgorithm("AES/CBC/PKCS5PADDING", "AES", 16);
    public static final /* enum */ SupportedEncryptionAlgorithm AES_ECB_PADDING = new SupportedEncryptionAlgorithm("AES/ECB/PKCS5PADDING", "AES", 0);
    private final String transformation;
    private final int initVectorLength;
    private final String algorithm;
    private static final /* synthetic */ SupportedEncryptionAlgorithm[] $VALUES;

    public static SupportedEncryptionAlgorithm[] values() {
        return (SupportedEncryptionAlgorithm[])$VALUES.clone();
    }

    public static SupportedEncryptionAlgorithm valueOf(String name) {
        return Enum.valueOf(SupportedEncryptionAlgorithm.class, name);
    }

    private SupportedEncryptionAlgorithm(String transformation, String algorithm, int initVectorLength) {
        this.transformation = transformation;
        this.algorithm = algorithm;
        this.initVectorLength = initVectorLength;
    }

    private AlgorithmParameterSpec getDecryptionParameter(EncryptionAlgorithm.IVLoader ivLoader) throws IOException {
        assert (this.initVectorLength > 0);
        byte[] initVector = new byte[this.initVectorLength];
        ivLoader.load(initVector);
        return SupportedEncryptionAlgorithm.createParameter(initVector);
    }

    private AlgorithmParameterSpec getEncryptionParameter(byte[] initVector, EncryptionAlgorithm.IVCollector ivCollector) throws IOException {
        assert (initVector != null);
        assert (initVector.length == this.initVectorLength);
        ivCollector.collect(initVector);
        return SupportedEncryptionAlgorithm.createParameter(initVector);
    }

    @Override
    public String getTransformation() {
        return this.transformation;
    }

    @Nonnull
    private static AlgorithmParameterSpec createParameter(@Nonnull byte[] initVector) {
        return new IvParameterSpec(initVector);
    }

    private Cipher encryptingCipher(SecretKey key, EncryptionAlgorithm.IVCollector collector) throws EncryptionAlgorithm.EncryptionException {
        try {
            Cipher newCipher = Cipher.getInstance(this.transformation);
            newCipher.init(1, key);
            if (this.initVectorLength > 0) {
                assert (collector != null);
                byte[] iv = newCipher.getIV();
                assert (iv != null);
                collector.collect(iv);
            }
            return newCipher;
        }
        catch (IOException | GeneralSecurityException e) {
            throw new EncryptionAlgorithm.EncryptionException(e);
        }
    }

    private Cipher decryptingCipher(SecretKey key, EncryptionAlgorithm.IVLoader loader) throws EncryptionAlgorithm.EncryptionException {
        try {
            Cipher newCipher = Cipher.getInstance(this.transformation);
            if (this.initVectorLength > 0) {
                assert (loader != null);
                newCipher.init(2, (Key)key, this.getDecryptionParameter(loader));
            } else {
                newCipher.init(2, key);
            }
            return newCipher;
        }
        catch (IOException | GeneralSecurityException e) {
            throw new EncryptionAlgorithm.EncryptionException(e);
        }
    }

    @Override
    public String getAlgorithm() {
        return this.algorithm;
    }

    @Override
    public EncryptionAlgorithm.Session newSession(final SecretKey key) {
        return new EncryptionAlgorithm.Session(){

            @Override
            public Cipher decryptingCipher(EncryptionAlgorithm.IVLoader loader) {
                return SupportedEncryptionAlgorithm.this.decryptingCipher(key, loader);
            }

            @Override
            public Cipher encryptingCipher(EncryptionAlgorithm.IVCollector collector) {
                return SupportedEncryptionAlgorithm.this.encryptingCipher(key, collector);
            }

            @Override
            public EncryptionAlgorithm getAlgorithm() {
                return SupportedEncryptionAlgorithm.this;
            }

            @Override
            public SecretKey getKey() {
                return key;
            }
        };
    }

    @Nonnull
    public static EncryptionAlgorithm byTransformation(String transformation) {
        return Arrays.stream(SupportedEncryptionAlgorithm.values()).filter(it -> it.transformation.equals(transformation)).findFirst().map(it -> it).orElse(NONE);
    }

    static {
        $VALUES = new SupportedEncryptionAlgorithm[]{AES_CBC_PADDING, AES_ECB_PADDING};
    }
}

