/*
 * Decompiled with CFR 0.152.
 */
package org.cef;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FilenameFilter;
import java.nio.file.Paths;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.concurrent.CompletableFuture;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.cef.CefClient;
import org.cef.CefSettings;
import org.cef.OS;
import org.cef.SystemBootstrap;
import org.cef.callback.CefSchemeHandlerFactory;
import org.cef.handler.CefAppHandler;
import org.cef.handler.CefAppHandlerAdapter;
import org.cef.handler.CefAppStateHandler;
import org.cef.misc.CefLog;
import org.cef.misc.Utils;

public class CefApp
extends CefAppHandlerAdapter {
    private static CefApp self = null;
    private static CefAppHandler appHandler_ = null;
    private static CefAppState state_ = CefAppState.NONE;
    private Timer workTimer_ = null;
    private HashSet<CefClient> clients_ = new HashSet();
    private CefSettings settings_ = null;
    private volatile boolean isInitialized_ = false;
    private final LinkedList<CefAppStateHandler> initializationListeners_ = new LinkedList();
    private static CompletableFuture<Boolean> futureStartup_ = null;
    private static final boolean PREINIT_ON_ANY_THREAD = Utils.getBoolean("jcef_app_preinit_any");
    private static final int STARTUP_TEST_DELAY_MS = Utils.getInteger("jcef_app_startup_test_delay_ms", 0);
    private static final int PREINIT_TEST_DELAY_MS = Utils.getInteger("jcef_app_preinit_test_delay_ms", 0);
    private static final int INIT_TEST_DELAY_MS = Utils.getInteger("jcef_app_init_test_delay_ms", 0);

    private CefApp(String[] args, CefSettings settings) throws UnsatisfiedLinkError {
        super(args);
        if (settings != null) {
            this.settings_ = settings.clone();
        }
        CefLog.init(settings);
        if (OS.isWindows()) {
            try {
                SystemBootstrap.loadLibrary("jawt");
            }
            catch (UnsatisfiedLinkError e) {
                CefLog.Error("can't load jawt library: " + e.getMessage(), new Object[0]);
            }
            SystemBootstrap.loadLibrary("chrome_elf");
            SystemBootstrap.loadLibrary("libcef");
            SystemBootstrap.loadLibrary("jcef");
        } else if (OS.isLinux()) {
            SystemBootstrap.loadLibrary("cef");
        }
        CefApp.setState(CefAppState.NEW);
        CompletableFuture futurePreinit = new CompletableFuture();
        Runnable nativePreInitialize = () -> {
            CefApp.testSleep(PREINIT_TEST_DELAY_MS);
            boolean success = this.N_PreInitialize();
            if (!success) {
                CefLog.Error("Failed to pre-initialize native code", new Object[0]);
            }
            futurePreinit.complete(success);
        };
        if (futureStartup_ != null) {
            futureStartup_.thenAccept(startupRes -> {
                if (!startupRes.booleanValue()) {
                    futurePreinit.complete(false);
                    return;
                }
                if (PREINIT_ON_ANY_THREAD) {
                    new Thread(nativePreInitialize, "CefPreinit-thread").start();
                } else {
                    SwingUtilities.invokeLater(nativePreInitialize);
                }
            });
        } else if (PREINIT_ON_ANY_THREAD) {
            new Thread(nativePreInitialize, "CefPreinit-thread").start();
        } else {
            SwingUtilities.invokeLater(nativePreInitialize);
        }
        futurePreinit.thenAccept(preinitRes -> {
            if (!preinitRes.booleanValue()) {
                return;
            }
            new Thread(() -> this.initialize(), "CefInitialize-thread").start();
        });
    }

    public void onInitialization(CefAppStateHandler initListener) {
        this.onInitialization(initListener, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onInitialization(CefAppStateHandler initListener, boolean first) {
        LinkedList<CefAppStateHandler> linkedList = this.initializationListeners_;
        synchronized (linkedList) {
            if (this.isInitialized_) {
                initListener.stateHasChanged(CefAppState.INITIALIZED);
            } else if (first) {
                this.initializationListeners_.addFirst(initListener);
            } else {
                this.initializationListeners_.addLast(initListener);
            }
        }
    }

    public static void addAppHandler(CefAppHandler appHandler) throws IllegalStateException {
        if (CefApp.getState().compareTo(CefAppState.NEW) > 0) {
            throw new IllegalStateException("Must be called before CefApp is initialized");
        }
        appHandler_ = appHandler;
    }

    public static synchronized CefApp getInstance() throws UnsatisfiedLinkError {
        return CefApp.getInstance(null, null);
    }

    public static synchronized CefApp getInstance(String[] args) throws UnsatisfiedLinkError {
        return CefApp.getInstance(args, null);
    }

    public static synchronized CefApp getInstance(CefSettings settings) throws UnsatisfiedLinkError {
        return CefApp.getInstance(null, settings);
    }

    public static synchronized CefApp getInstance(String[] args, CefSettings settings) throws UnsatisfiedLinkError {
        if (settings != null && CefApp.getState().compareTo(CefAppState.NEW) > 0) {
            throw new IllegalStateException("Settings can only be passed to CEF before createClient is called the first time. Current state is " + CefApp.getState());
        }
        if (self == null) {
            if (CefApp.getState() == CefAppState.TERMINATED) {
                throw new IllegalStateException("CefApp was terminated");
            }
            assert (CefApp.getState() == CefAppState.NONE);
            self = new CefApp(args, settings);
        }
        return self;
    }

    public static synchronized CefApp getInstanceIfAny() throws UnsatisfiedLinkError {
        return self;
    }

    public final void setSettings(CefSettings settings) throws IllegalStateException {
        if (CefApp.getState().compareTo(CefAppState.NEW) > 0) {
            throw new IllegalStateException("Settings can only be passed to CEF before createClient is called the first time. Current state is " + CefApp.getState());
        }
        this.settings_ = settings.clone();
    }

    public final CefVersion getVersion() {
        try {
            return this.N_GetVersion();
        }
        catch (UnsatisfiedLinkError ule) {
            ule.printStackTrace();
            return null;
        }
    }

    public static final CefAppState getState() {
        return state_;
    }

    private static final void setState(final CefAppState state) {
        if (state.compareTo(state_) < 0) {
            String errMsg = "CefApp: state cannot go backward. Current state " + state_ + ". Proposed state " + state;
            CefLog.Error(errMsg, new Object[0]);
            throw new IllegalStateException(errMsg);
        }
        CefLog.Info("CefApp: set state %s", new Object[]{state});
        state_ = state;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                CefAppHandler handler;
                CefAppHandler cefAppHandler = handler = appHandler_ == null ? self : appHandler_;
                if (handler != null) {
                    handler.stateHasChanged(state);
                }
            }
        });
    }

    public final synchronized void dispose() {
        switch (CefApp.getState()) {
            case NEW: {
                CefApp.setState(CefAppState.TERMINATED);
                self = null;
                break;
            }
            case INITIALIZING: 
            case INITIALIZED: {
                CefApp.setState(CefAppState.SHUTTING_DOWN);
                if (this.clients_.isEmpty()) {
                    this.scheduleNativeShutdown();
                    break;
                }
                CefLog.Debug("CefApp: dispose clients before shutting down", new Object[0]);
                HashSet<CefClient> clients = new HashSet<CefClient>(this.clients_);
                for (CefClient c : clients) {
                    CefLog.Debug("CefApp: dispose %s", c);
                    c.dispose();
                }
                break;
            }
        }
    }

    public synchronized CefClient createClient() {
        if (state_.compareTo(CefAppState.SHUTTING_DOWN) >= 0) {
            String errMsg = "Can't create client in state " + state_;
            CefLog.Error(errMsg, new Object[0]);
            throw new IllegalStateException(errMsg);
        }
        CefClient client = new CefClient();
        this.onInitialization(client, true);
        this.clients_.add(client);
        return client;
    }

    public boolean registerSchemeHandlerFactory(String schemeName, String domainName, CefSchemeHandlerFactory factory) {
        try {
            return this.N_RegisterSchemeHandlerFactory(schemeName, domainName, factory);
        }
        catch (Exception err) {
            err.printStackTrace();
            return false;
        }
    }

    public boolean clearSchemeHandlerFactories() {
        try {
            return this.N_ClearSchemeHandlerFactories();
        }
        catch (Exception err) {
            err.printStackTrace();
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final synchronized void clientWasDisposed(CefClient client) {
        this.clients_.remove(client);
        LinkedList<CefAppStateHandler> linkedList = this.initializationListeners_;
        synchronized (linkedList) {
            this.initializationListeners_.remove(client);
        }
        CefLog.Debug("CefApp: client was disposed: %s [clients count %d]", client, this.clients_.size());
        if (this.clients_.isEmpty() && CefApp.getState().compareTo(CefAppState.SHUTTING_DOWN) >= 0) {
            this.scheduleNativeShutdown();
        }
    }

    private static void testSleep(int ms) {
        if (ms > 0) {
            CefLog.Debug("testSleep %s ms", ms);
            try {
                Thread.sleep(ms);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void initialize() {
        boolean success;
        CefSettings settings;
        CefApp.setState(CefAppState.INITIALIZING);
        CefApp.testSleep(INIT_TEST_DELAY_MS);
        String library_path = CefApp.getJcefLibPath();
        if (this.settings_.log_severity == CefSettings.LogSeverity.LOGSEVERITY_INFO || this.settings_.log_severity == CefSettings.LogSeverity.LOGSEVERITY_VERBOSE) {
            CefLog.Info("initialize on " + Thread.currentThread() + " with library path " + library_path, new Object[0]);
        }
        CefSettings cefSettings = settings = this.settings_ != null ? this.settings_ : new CefSettings();
        if (OS.isMacintosh()) {
            if (settings.browser_subprocess_path == null) {
                path = Paths.get(library_path, "../Frameworks/jcef Helper.app/Contents/MacOS/jcef Helper");
                settings.browser_subprocess_path = path.normalize().toAbsolutePath().toString();
            }
        } else if (OS.isWindows()) {
            if (settings.browser_subprocess_path == null) {
                path = Paths.get(library_path, "jcef_helper.exe");
                settings.browser_subprocess_path = path.normalize().toAbsolutePath().toString();
            }
        } else if (OS.isLinux()) {
            if (settings.browser_subprocess_path == null) {
                path = Paths.get(library_path, "jcef_helper");
                settings.browser_subprocess_path = path.normalize().toAbsolutePath().toString();
            }
            if (settings.resources_dir_path == null) {
                path = Paths.get(library_path, new String[0]);
                settings.resources_dir_path = path.normalize().toAbsolutePath().toString();
            }
            if (settings.locales_dir_path == null) {
                path = Paths.get(library_path, "locales");
                settings.locales_dir_path = path.normalize().toAbsolutePath().toString();
            }
        }
        if (success = this.N_Initialize(appHandler_ == null ? this : appHandler_, settings, false)) {
            CefLog.Debug("CefApp: native initialization is finished.", new Object[0]);
            CefApp.setState(CefAppState.INITIALIZED);
            LinkedList<CefAppStateHandler> linkedList = this.initializationListeners_;
            synchronized (linkedList) {
                this.isInitialized_ = true;
                this.initializationListeners_.forEach(l -> l.stateHasChanged(CefAppState.INITIALIZED));
                this.initializationListeners_.clear();
            }
            CefLog.Info("version: %s | settings: %s", this.getVersion(), settings.getDescription());
        } else {
            CefLog.Error("CefApp: N_Initialize failed.", new Object[0]);
        }
    }

    protected final void handleBeforeTerminate() {
        CefLog.Info("Cmd+Q termination request.", new Object[0]);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                CefAppHandler handler;
                CefAppHandler cefAppHandler = handler = appHandler_ == null ? CefApp.this : appHandler_;
                if (!handler.onBeforeTerminate()) {
                    CefApp.this.dispose();
                }
            }
        });
    }

    private void scheduleNativeShutdown() {
        new Thread(() -> {
            CefLog.Info("shutdown CEF on " + Thread.currentThread(), new Object[0]);
            this.N_Shutdown();
            CefApp cefApp = this;
            synchronized (cefApp) {
                CefApp.setState(CefAppState.TERMINATED);
                self = null;
            }
        }, "CEF-shutdown-thread").start();
    }

    public final void doMessageLoopWork(final long delay_ms) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (CefApp.getState() == CefAppState.TERMINATED) {
                    return;
                }
                long kMaxTimerDelay = 33L;
                if (CefApp.this.workTimer_ != null) {
                    CefApp.this.workTimer_.stop();
                    CefApp.this.workTimer_ = null;
                }
                if (delay_ms <= 0L) {
                    CefApp.this.N_DoMessageLoopWork();
                    CefApp.this.doMessageLoopWork(33L);
                } else {
                    long timer_delay_ms = delay_ms;
                    if (timer_delay_ms > 33L) {
                        timer_delay_ms = 33L;
                    }
                    CefApp.this.workTimer_ = new Timer((int)timer_delay_ms, new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent evt) {
                            CefApp.this.workTimer_.stop();
                            CefApp.this.workTimer_ = null;
                            CefApp.this.N_DoMessageLoopWork();
                            CefApp.this.doMessageLoopWork(33L);
                        }
                    });
                    CefApp.this.workTimer_.start();
                }
            }
        });
    }

    public static final boolean startup(String[] args) {
        if (OS.isLinux() || OS.isMacintosh()) {
            futureStartup_ = new CompletableFuture();
            Runnable r = () -> {
                CefApp.testSleep(STARTUP_TEST_DELAY_MS);
                try {
                    SystemBootstrap.loadLibrary("jcef");
                    boolean result = CefApp.N_Startup(OS.isMacintosh() ? CefApp.getCefFrameworkPath(args) : null);
                    if (!result) {
                        System.err.println("N_Startup failed.");
                    }
                    futureStartup_.complete(result);
                }
                catch (Throwable e) {
                    futureStartup_.completeExceptionally(e);
                }
            };
            new Thread(r, "CefStartup-thread").start();
        }
        return true;
    }

    private static final String getJcefLibPath() {
        String[] paths;
        if (OS.isMacintosh()) {
            return System.getProperty("java.home") + "/lib";
        }
        String library_path = System.getProperty("java.library.path");
        for (String path : paths = library_path.split(System.getProperty("path.separator"))) {
            File dir = new File(path);
            String[] found = dir.list(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.equalsIgnoreCase("libjcef.dylib") || name.equalsIgnoreCase("libjcef.so") || name.equalsIgnoreCase("jcef.dll");
                }
            });
            if (found == null || found.length == 0) continue;
            return path;
        }
        return library_path;
    }

    private static final String getCefFrameworkPath(String[] args) {
        String switchPrefix = "--framework-dir-path=";
        for (String arg : args) {
            if (!arg.startsWith(switchPrefix)) continue;
            return new File(arg.substring(switchPrefix.length())).getAbsolutePath();
        }
        String parentPrefix = OS.isMacintosh() ? "/../.." : "/..";
        return new File(CefApp.getJcefLibPath() + parentPrefix + "/Frameworks/Chromium Embedded Framework.framework").getAbsolutePath();
    }

    private static final native boolean N_Startup(String var0);

    private final native boolean N_PreInitialize();

    private final native boolean N_Initialize(CefAppHandler var1, CefSettings var2, boolean var3);

    private final native void N_Shutdown();

    private final native void N_DoMessageLoopWork();

    private final native CefVersion N_GetVersion();

    private final native boolean N_RegisterSchemeHandlerFactory(String var1, String var2, CefSchemeHandlerFactory var3);

    private final native boolean N_ClearSchemeHandlerFactories();

    public static enum CefAppState {
        NONE,
        NEW,
        INITIALIZING,
        INITIALIZED,
        SHUTTING_DOWN,
        TERMINATED;

    }

    public final class CefVersion {
        public final int JCEF_COMMIT_NUMBER;
        public final String JCEF_COMMIT_HASH;
        public final int CEF_VERSION_MAJOR;
        public final int CEF_VERSION_MINOR;
        public final int CEF_VERSION_PATCH;
        public final int CEF_COMMIT_NUMBER;
        public final int CHROME_VERSION_MAJOR;
        public final int CHROME_VERSION_MINOR;
        public final int CHROME_VERSION_BUILD;
        public final int CHROME_VERSION_PATCH;

        private CefVersion(int jcefCommitNo, String jcefCommitHash, int cefMajor, int cefMinor, int cefPatch, int cefCommitNo, int chrMajor, int chrMin, int chrBuild, int chrPatch) {
            this.JCEF_COMMIT_NUMBER = jcefCommitNo;
            this.JCEF_COMMIT_HASH = jcefCommitHash;
            this.CEF_VERSION_MAJOR = cefMajor;
            this.CEF_VERSION_MINOR = cefMinor;
            this.CEF_VERSION_PATCH = cefPatch;
            this.CEF_COMMIT_NUMBER = cefCommitNo;
            this.CHROME_VERSION_MAJOR = chrMajor;
            this.CHROME_VERSION_MINOR = chrMin;
            this.CHROME_VERSION_BUILD = chrBuild;
            this.CHROME_VERSION_PATCH = chrPatch;
        }

        public String getJcefVersion() {
            return this.CEF_VERSION_MAJOR + "." + this.CEF_VERSION_MINOR + "." + this.CEF_VERSION_PATCH + "." + this.JCEF_COMMIT_NUMBER + "." + this.JCEF_COMMIT_HASH;
        }

        public String getCefVersion() {
            return this.CEF_VERSION_MAJOR + "." + this.CEF_VERSION_MINOR + "." + this.CEF_VERSION_PATCH;
        }

        public String getChromeVersion() {
            return this.CHROME_VERSION_MAJOR + "." + this.CHROME_VERSION_MINOR + "." + this.CHROME_VERSION_BUILD + "." + this.CHROME_VERSION_PATCH;
        }

        public String toString() {
            return "JCEF Version = " + this.getJcefVersion() + "\nCEF Version = " + this.getCefVersion() + "\nChromium Version = " + this.getChromeVersion();
        }
    }
}

