/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.com.amazonaws.services.s3.transfer.internal;

import java.util.Collection;
import java.util.Collections;
import org.gradle.internal.impldep.com.amazonaws.AmazonClientException;
import org.gradle.internal.impldep.com.amazonaws.AmazonServiceException;
import org.gradle.internal.impldep.com.amazonaws.event.ProgressListenerChain;
import org.gradle.internal.impldep.com.amazonaws.services.s3.transfer.MultipleFileUpload;
import org.gradle.internal.impldep.com.amazonaws.services.s3.transfer.TransferProgress;
import org.gradle.internal.impldep.com.amazonaws.services.s3.transfer.Upload;
import org.gradle.internal.impldep.com.amazonaws.services.s3.transfer.internal.MultipleFileTransfer;

public class MultipleFileUploadImpl
extends MultipleFileTransfer<Upload>
implements MultipleFileUpload {
    private final String keyPrefix;
    private final String bucketName;

    public MultipleFileUploadImpl(String description, TransferProgress transferProgress, ProgressListenerChain progressListenerChain, String keyPrefix, String bucketName, Collection<? extends Upload> subTransfers) {
        super(description, transferProgress, progressListenerChain, subTransfers);
        this.keyPrefix = keyPrefix;
        this.bucketName = bucketName;
    }

    @Override
    public String getKeyPrefix() {
        return this.keyPrefix;
    }

    @Override
    public String getBucketName() {
        return this.bucketName;
    }

    @Override
    public void waitForCompletion() throws AmazonClientException, AmazonServiceException, InterruptedException {
        if (this.subTransfers.isEmpty()) {
            return;
        }
        super.waitForCompletion();
    }

    @Override
    public Collection<? extends Upload> getSubTransfers() {
        return Collections.unmodifiableCollection(this.subTransfers);
    }
}

