/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.gnu.trove;

import java.util.ConcurrentModificationException;
import org.gradle.internal.impldep.gnu.trove.TByteObjectHashMap;
import org.gradle.internal.impldep.gnu.trove.TIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TByteObjectIterator<V>
extends TIterator {
    private final TByteObjectHashMap<V> _map;

    public TByteObjectIterator(TByteObjectHashMap<V> map) {
        super(map);
        this._map = map;
    }

    @Override
    protected final int nextIndex() {
        if (this._expectedSize != this._map.size()) {
            throw new ConcurrentModificationException();
        }
        Object[] values = this._map._values;
        int i = this._index;
        while (i-- > 0 && !TByteObjectHashMap.isFull(values, i)) {
        }
        return i;
    }

    public void advance() {
        this.moveToNextIndex();
    }

    public byte key() {
        return this._map._set[this._index];
    }

    public V value() {
        return this._map._values[this._index];
    }

    public V setValue(V val) {
        V old = this.value();
        this._map._values[this._index] = val;
        return old;
    }
}

