/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.io.opencensus.trace;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import org.gradle.internal.impldep.io.opencensus.common.Clock;
import org.gradle.internal.impldep.io.opencensus.internal.Provider;
import org.gradle.internal.impldep.io.opencensus.trace.TraceComponent;
import org.gradle.internal.impldep.io.opencensus.trace.Tracer;
import org.gradle.internal.impldep.io.opencensus.trace.config.TraceConfig;
import org.gradle.internal.impldep.io.opencensus.trace.export.ExportComponent;
import org.gradle.internal.impldep.io.opencensus.trace.propagation.PropagationComponent;

public final class Tracing {
    private static final Logger logger = Logger.getLogger(Tracing.class.getName());
    private static final TraceComponent traceComponent = Tracing.loadTraceComponent(TraceComponent.class.getClassLoader());

    public static Tracer getTracer() {
        return traceComponent.getTracer();
    }

    public static PropagationComponent getPropagationComponent() {
        return traceComponent.getPropagationComponent();
    }

    public static Clock getClock() {
        return traceComponent.getClock();
    }

    public static ExportComponent getExportComponent() {
        return traceComponent.getExportComponent();
    }

    public static TraceConfig getTraceConfig() {
        return traceComponent.getTraceConfig();
    }

    static TraceComponent loadTraceComponent(@Nullable ClassLoader classLoader) {
        try {
            return Provider.createInstance(Class.forName("io.opentelemetry.opencensusshim.OpenTelemetryTraceComponentImpl", true, classLoader), TraceComponent.class);
        }
        catch (ClassNotFoundException e) {
            logger.log(Level.FINE, "Couldn't load full implementation for OpenTelemetry TraceComponent, now trying to load original implementation.", e);
            try {
                return Provider.createInstance(Class.forName("io.opencensus.impl.trace.TraceComponentImpl", true, classLoader), TraceComponent.class);
            }
            catch (ClassNotFoundException e2) {
                logger.log(Level.FINE, "Couldn't load full implementation for TraceComponent, now trying to load lite implementation.", e2);
                try {
                    return Provider.createInstance(Class.forName("io.opencensus.impllite.trace.TraceComponentImplLite", true, classLoader), TraceComponent.class);
                }
                catch (ClassNotFoundException e3) {
                    logger.log(Level.FINE, "Couldn't load lite implementation for TraceComponent, now using default implementation for TraceComponent.", e3);
                    return TraceComponent.newNoopTraceComponent();
                }
            }
        }
    }

    private Tracing() {
    }
}

