/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.eclipse.jgit.util;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import org.gradle.internal.impldep.org.eclipse.jgit.annotations.Nullable;
import org.gradle.internal.impldep.org.eclipse.jgit.errors.ConfigInvalidException;
import org.gradle.internal.impldep.org.eclipse.jgit.util.SystemReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Monitoring {
    private static final Logger LOG = LoggerFactory.getLogger(Monitoring.class);

    @Nullable
    public static ObjectInstance registerMBean(Object mbean, String metricName) {
        boolean register = false;
        try {
            Class<?>[] interfaces;
            Class<?>[] classArray = interfaces = mbean.getClass().getInterfaces();
            int n = interfaces.length;
            int n2 = 0;
            while (n2 < n) {
                Class<?> i = classArray[n2];
                register = SystemReader.getInstance().getUserConfig().getBoolean("jmx", i.getSimpleName(), false);
                if (!register) {
                    ++n2;
                    continue;
                }
                break;
            }
        }
        catch (IOException | ConfigInvalidException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            return null;
        }
        if (!register) {
            return null;
        }
        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
        try {
            ObjectName mbeanName = Monitoring.objectName(mbean.getClass(), metricName);
            if (server.isRegistered(mbeanName)) {
                server.unregisterMBean(mbeanName);
            }
            return server.registerMBean(mbean, mbeanName);
        }
        catch (InstanceAlreadyExistsException | InstanceNotFoundException | MBeanRegistrationException | MalformedObjectNameException | NotCompliantMBeanException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private static ObjectName objectName(Class mbean, String metricName) throws MalformedObjectNameException {
        return new ObjectName(String.format("org.eclipse.jgit/%s:type=%s", metricName, mbean.getSimpleName()));
    }
}

