/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.gradleinternal.buildinit.plugins.internal.maven;

import java.io.File;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.maven.execution.DefaultMavenExecutionRequest;
import org.apache.maven.execution.DefaultMavenExecutionResult;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.execution.MavenExecutionRequestPopulationException;
import org.apache.maven.execution.MavenExecutionRequestPopulator;
import org.apache.maven.execution.MavenExecutionResult;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.project.ProjectBuildingResult;
import org.codehaus.plexus.ContainerConfiguration;
import org.codehaus.plexus.DefaultContainerConfiguration;
import org.codehaus.plexus.DefaultPlexusContainer;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.PlexusContainerException;
import org.codehaus.plexus.classworlds.ClassWorld;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositorySystemSession;
import org.gradle.internal.SystemProperties;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;
import org.gradle.internal.impldep.org.apache.maven.settings.Settings;
import org.gradle.internal.impldep.org.gradleinternal.buildinit.plugins.internal.maven.MavenConversionException;
import org.gradle.util.internal.CollectionUtils;

public class MavenProjectsCreator {
    public Set<MavenProject> create(Settings mavenSettings, File pomFile) {
        if (!pomFile.exists()) {
            throw new MavenConversionException(String.format("Unable to create Maven project model. The POM file %s does not exist.", pomFile));
        }
        try {
            return this.createNow(mavenSettings, pomFile);
        }
        catch (Exception e) {
            throw new MavenConversionException(String.format("Unable to create Maven project model using POM %s.", pomFile), e);
        }
    }

    private Set<MavenProject> createNow(Settings settings, File pomFile) throws PlexusContainerException, ComponentLookupException, MavenExecutionRequestPopulationException, ProjectBuildingException {
        ContainerConfiguration containerConfiguration = new DefaultContainerConfiguration().setClassWorld(new ClassWorld("plexus.core", Thread.currentThread().getContextClassLoader())).setName("mavenCore").setClassPathScanning("index").setAutoWiring(true);
        DefaultPlexusContainer container = new DefaultPlexusContainer(containerConfiguration);
        ProjectBuilder builder = (ProjectBuilder)container.lookup(ProjectBuilder.class);
        DefaultMavenExecutionRequest executionRequest = new DefaultMavenExecutionRequest();
        Properties properties = (Properties)SystemProperties.getInstance().withSystemProperties(() -> {
            Properties currentProperties = new Properties();
            currentProperties.putAll((Map<?, ?>)System.getProperties());
            return currentProperties;
        });
        executionRequest.setSystemProperties(properties);
        MavenExecutionRequestPopulator populator = (MavenExecutionRequestPopulator)container.lookup(MavenExecutionRequestPopulator.class);
        this.populateFromSettings(settings, (MavenExecutionRequest)executionRequest, populator);
        populator.populateDefaults((MavenExecutionRequest)executionRequest);
        ProjectBuildingRequest buildingRequest = executionRequest.getProjectBuildingRequest();
        buildingRequest.getRemoteRepositories().forEach(repository -> {
            if (repository.getId().equals("central")) {
                repository.setUrl("https://repo.maven.apache.org/maven2/");
            }
        });
        buildingRequest.setProcessPlugins(false);
        MavenProject mavenProject = builder.build(pomFile, buildingRequest).getProject();
        LinkedHashSet<MavenProject> reactorProjects = new LinkedHashSet<MavenProject>();
        reactorProjects.add(mavenProject);
        List allProjects = builder.build(ImmutableList.of(pomFile), true, buildingRequest);
        CollectionUtils.collect((Iterable)allProjects, reactorProjects, ProjectBuildingResult::getProject);
        DefaultMavenExecutionResult result = new DefaultMavenExecutionResult();
        result.setProject(mavenProject);
        DefaultRepositorySystemSession repoSession = new DefaultRepositorySystemSession();
        MavenSession session = new MavenSession((PlexusContainer)container, (RepositorySystemSession)repoSession, (MavenExecutionRequest)executionRequest, (MavenExecutionResult)result);
        session.setCurrentProject(mavenProject);
        return reactorProjects;
    }

    private void populateFromSettings(Settings settings, MavenExecutionRequest executionRequest, MavenExecutionRequestPopulator populator) throws MavenExecutionRequestPopulationException {
        populator.populateFromSettings(executionRequest, settings);
    }
}

