/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus.bin;

import java.io.Closeable;
import java.io.IOException;
import java.nio.channels.SocketChannel;
import java.nio.file.attribute.PosixFilePermission;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import org.freedesktop.dbus.bin.DBusDaemon;
import org.freedesktop.dbus.connections.BusAddress;
import org.freedesktop.dbus.connections.config.TransportConfigBuilder;
import org.freedesktop.dbus.connections.transports.AbstractTransport;
import org.freedesktop.dbus.connections.transports.TransportBuilder;
import org.freedesktop.dbus.exceptions.AuthenticationException;
import org.freedesktop.dbus.exceptions.DBusException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmbeddedDBusDaemon
implements Closeable {
    private static final Logger LOGGER = LoggerFactory.getLogger(EmbeddedDBusDaemon.class);
    private final BusAddress address;
    private DBusDaemon daemonThread;
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private TransportBuilder.SaslAuthMode saslAuthMode;
    private String unixSocketFileOwner;
    private String unixSocketFileGroup;
    private PosixFilePermission[] unixSocketFilePermissions;

    public EmbeddedDBusDaemon(BusAddress _address) {
        this.address = BusAddress.of(Objects.requireNonNull(_address, "Address required"));
    }

    public EmbeddedDBusDaemon(String _address) throws DBusException {
        this(BusAddress.of(_address));
    }

    @Override
    public void close() throws IOException {
        this.closed.set(true);
        if (this.daemonThread != null) {
            this.daemonThread.close();
            this.daemonThread = null;
        }
    }

    public void startInForeground() {
        block2: {
            this.daemonThread = new DBusDaemon();
            this.daemonThread.start();
            try {
                this.startListening();
            }
            catch (IOException | DBusException ex) {
                if (this.closed.get()) break block2;
                throw new RuntimeException(ex);
            }
        }
    }

    public void startInBackground() {
        Thread thread = new Thread(this::startInForeground);
        thread.setName("EmbeddedDBusDaemon-" + this.address);
        thread.setDaemon(true);
        thread.setUncaughtExceptionHandler((th, ex) -> LOGGER.error("Got uncaught exception", ex));
        thread.start();
    }

    public void startInBackgroundAndWait(long _maxWaitMillis) {
        this.startInBackground();
        long sleepMs = 100L;
        long waited = 0L;
        while (!this.isRunning()) {
            if (waited >= _maxWaitMillis) {
                throw new RuntimeException("EmbeddedDbusDaemon not started in the specified time of " + _maxWaitMillis + " ms");
            }
            try {
                Thread.sleep(sleepMs);
            }
            catch (InterruptedException _ex) {
                LOGGER.debug("Interrupted while waiting for DBus daemon to start");
                break;
            }
            LOGGER.debug("Waiting for embedded daemon to start: {} of {} ms waited", (Object)(waited += sleepMs), (Object)_maxWaitMillis);
        }
    }

    public synchronized boolean isRunning() {
        return this.daemonThread != null && this.daemonThread.isRunning();
    }

    public TransportBuilder.SaslAuthMode getSaslAuthMode() {
        return this.saslAuthMode;
    }

    public void setSaslAuthMode(TransportBuilder.SaslAuthMode _saslAuthMode) {
        this.saslAuthMode = _saslAuthMode;
    }

    public void setUnixSocketOwner(String _owner) {
        this.unixSocketFileOwner = _owner;
    }

    public void setUnixSocketGroup(String _group) {
        this.unixSocketFileGroup = _group;
    }

    public void setUnixSocketPermissions(PosixFilePermission ... _permissions) {
        this.unixSocketFilePermissions = _permissions;
    }

    private void startListening() throws IOException, DBusException {
        if (!TransportBuilder.getRegisteredBusTypes().contains(this.address.getBusType())) {
            throw new IllegalArgumentException("Unknown or unsupported address type: " + this.address.getType());
        }
        try (AbstractTransport transport = ((TransportBuilder)((TransportConfigBuilder)((TransportConfigBuilder)((TransportConfigBuilder)((TransportConfigBuilder)TransportBuilder.create(this.address).configure().withSaslAuthMode(this.getSaslAuthMode()).withUnixSocketFileOwner(this.unixSocketFileOwner)).withUnixSocketFileGroup(this.unixSocketFileGroup)).withUnixSocketFilePermissions(this.unixSocketFilePermissions)).withAutoConnect(false)).back()).build();){
            while (this.daemonThread.isRunning()) {
                try {
                    SocketChannel s = transport.connect();
                    this.daemonThread.addSock(s);
                }
                catch (AuthenticationException _ex) {
                    LOGGER.error("Authentication failed");
                }
            }
        }
    }
}

