/*
 * Decompiled with CFR 0.152.
 */
package com.jediterm.terminal.emulator;

import com.jediterm.terminal.TerminalDataStream;
import com.jediterm.terminal.util.CharUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class SystemCommandSequence {
    private static final char ST = '\u009c';
    static final char OSC = '\u009d';
    private final List<String> myArgs;
    private final StringBuilder mySequence = new StringBuilder();

    public SystemCommandSequence(@NotNull TerminalDataStream stream) throws IOException {
        StringBuilder argBuilder = new StringBuilder();
        boolean end = false;
        ArrayList<String> args = new ArrayList<String>();
        while (!end) {
            char ch = stream.getChar();
            this.mySequence.append(ch);
            end = this.isEnd();
            if (ch == ';' || end) {
                if (end && this.isTwoBytesEnd()) {
                    argBuilder.deleteCharAt(argBuilder.length() - 1);
                }
                args.add(argBuilder.toString());
                argBuilder.setLength(0);
                continue;
            }
            argBuilder.append(ch);
        }
        this.myArgs = List.copyOf(args);
    }

    private boolean isEnd() {
        int len = this.mySequence.length();
        if (len > 0) {
            char ch = this.mySequence.charAt(len - 1);
            return ch == '\u0007' || ch == '\u009c' || this.isTwoBytesEnd();
        }
        return false;
    }

    private boolean isTwoBytesEnd() {
        int len = this.mySequence.length();
        return len > 1 && this.mySequence.charAt(len - 2) == '\u001b' && this.mySequence.charAt(len - 1) == '\\';
    }

    @Nullable
    public String getStringAt(int i) {
        return i < this.myArgs.size() ? this.myArgs.get(i) : null;
    }

    @NotNull
    public List<String> getArgs() {
        return this.myArgs;
    }

    public int getIntAt(int position, int defaultValue) {
        if (position < this.myArgs.size()) {
            return this.parseArg(this.myArgs.get(position), defaultValue);
        }
        return defaultValue;
    }

    private int parseArg(@NotNull String arg, int defaultValue) {
        if (!arg.isEmpty() && Character.isDigit(arg.charAt(arg.length() - 1))) {
            try {
                return Integer.parseInt(arg);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    @NotNull
    public String format(@NotNull String body) {
        return "\u001b]" + body + this.getTerminator();
    }

    public String toString() {
        return CharUtils.toHumanReadableText(this.mySequence.toString());
    }

    @NotNull
    private String getTerminator() {
        int len = this.mySequence.length();
        if (this.isTwoBytesEnd()) {
            return this.mySequence.substring(len - 2);
        }
        return this.mySequence.substring(len - 1);
    }
}

