/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.TreeSet;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.stream.Collectors;
import org.gradle.api.internal.changedetection.state.FallbackHandlingResourceHasher;
import org.gradle.api.internal.changedetection.state.ResourceEntryFilter;
import org.gradle.internal.fingerprint.hashing.RegularFileSnapshotContext;
import org.gradle.internal.fingerprint.hashing.ResourceHasher;
import org.gradle.internal.fingerprint.hashing.ZipEntryContext;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.hash.Hasher;
import org.gradle.internal.hash.Hashing;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetaInfAwareClasspathResourceHasher
extends FallbackHandlingResourceHasher {
    private static final Logger LOGGER = LoggerFactory.getLogger(MetaInfAwareClasspathResourceHasher.class);
    private final ResourceEntryFilter attributeResourceFilter;

    public MetaInfAwareClasspathResourceHasher(ResourceHasher delegate, ResourceEntryFilter attributeResourceFilter) {
        super(delegate);
        this.attributeResourceFilter = attributeResourceFilter;
    }

    @Override
    public void appendConfigurationToHasher(Hasher hasher) {
        super.appendConfigurationToHasher(hasher);
        hasher.putString(this.getClass().getName());
        this.attributeResourceFilter.appendConfigurationToHasher(hasher);
    }

    @Override
    boolean filter(RegularFileSnapshotContext context) {
        return MetaInfAwareClasspathResourceHasher.isManifestFile(String.join((CharSequence)"/", context.getRelativePathSegments().get()));
    }

    @Override
    boolean filter(ZipEntryContext context) {
        return !context.getEntry().isDirectory() && MetaInfAwareClasspathResourceHasher.isManifestFile(context.getEntry().getName());
    }

    @Override
    Optional<HashCode> tryHash(RegularFileSnapshotContext snapshotContext) {
        return Optional.of(snapshotContext).map(context -> {
            HashCode hashCode;
            FileInputStream manifestFileInputStream = new FileInputStream(context.getSnapshot().getAbsolutePath());
            try {
                hashCode = this.hashManifest(manifestFileInputStream);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        manifestFileInputStream.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    LOGGER.debug("Could not load fingerprint for " + context.getSnapshot().getAbsolutePath() + ". Falling back to full entry fingerprinting", (Throwable)e);
                    return null;
                }
            }
            manifestFileInputStream.close();
            return hashCode;
        });
    }

    @Override
    Optional<HashCode> tryHash(ZipEntryContext zipEntryContext) {
        return Optional.of(zipEntryContext).map(context -> {
            try {
                return zipEntryContext.getEntry().withInputStream(this::hashManifest);
            }
            catch (IOException e) {
                LOGGER.debug("Could not load fingerprint for " + zipEntryContext.getRootParentName() + "!" + zipEntryContext.getFullName() + ". Falling back to full entry fingerprinting", (Throwable)e);
                return null;
            }
        });
    }

    private static boolean isManifestFile(String name) {
        return name.equals("META-INF/MANIFEST.MF");
    }

    private HashCode hashManifest(InputStream inputStream) throws IOException {
        Manifest manifest = new Manifest(inputStream);
        Hasher hasher = Hashing.newHasher();
        Attributes mainAttributes = manifest.getMainAttributes();
        this.hashManifestAttributes(mainAttributes, "main", hasher);
        Map<String, Attributes> entries = manifest.getEntries();
        TreeSet<String> names = new TreeSet<String>(manifest.getEntries().keySet());
        for (String name : names) {
            this.hashManifestAttributes(entries.get(name), name, hasher);
        }
        return hasher.hash();
    }

    private void hashManifestAttributes(Attributes attributes, String name, Hasher hasher) {
        Map<String, String> entries = attributes.entrySet().stream().collect(Collectors.toMap(entry -> entry.getKey().toString().toLowerCase(Locale.ROOT), entry -> (String)entry.getValue()));
        List normalizedEntries = entries.entrySet().stream().filter((? super T entry) -> !this.attributeResourceFilter.shouldBeIgnored((String)entry.getKey())).sorted(Map.Entry.comparingByKey()).collect(Collectors.toList());
        if (!normalizedEntries.isEmpty()) {
            hasher.putString(name);
            for (Map.Entry entry2 : normalizedEntries) {
                hasher.putString((CharSequence)entry2.getKey());
                hasher.putString((CharSequence)entry2.getValue());
            }
        }
    }
}

