/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.action;

import java.util.List;
import org.gradle.api.Action;
import org.gradle.api.internal.ReusableAction;
import org.gradle.internal.Actions;
import org.gradle.internal.action.ConfigurableRule;
import org.gradle.internal.action.ConfigurableRules;
import org.gradle.internal.reflect.Instantiator;

public class InstantiatingAction<DETAILS>
implements Action<DETAILS> {
    private final ConfigurableRules<DETAILS> rules;
    private final Instantiator instantiator;
    private final ExceptionHandler<DETAILS> exceptionHandler;
    private final Action<DETAILS>[] reusableRules;

    public InstantiatingAction(ConfigurableRules<DETAILS> rules, Instantiator instantiator2, ExceptionHandler<DETAILS> exceptionHandler) {
        this.rules = rules;
        this.instantiator = instantiator2;
        this.exceptionHandler = exceptionHandler;
        this.reusableRules = new Action[rules.getConfigurableRules().size()];
    }

    public InstantiatingAction<DETAILS> withInstantiator(Instantiator instantiator2) {
        return new InstantiatingAction<DETAILS>(this.rules, instantiator2, this.exceptionHandler);
    }

    @Override
    public void execute(DETAILS target) {
        List<ConfigurableRule<DETAILS>> configurableRules = this.rules.getConfigurableRules();
        int i = 0;
        for (ConfigurableRule<DETAILS> rule : configurableRules) {
            try {
                Action<DETAILS> instance = this.reusableRules[i];
                if (!(instance instanceof ReusableAction)) {
                    instance = this.instantiator.newInstance(rule.getRuleClass(), rule.getRuleParams().isolate());
                    this.reusableRules[i] = instance instanceof ReusableAction ? instance : Actions.doNothing();
                }
                instance.execute(target);
            }
            catch (Throwable t) {
                this.exceptionHandler.handleException(target, t);
            }
            ++i;
        }
    }

    public ConfigurableRules<DETAILS> getRules() {
        return this.rules;
    }

    public Instantiator getInstantiator() {
        return this.instantiator;
    }

    public static interface ExceptionHandler<U> {
        public void handleException(U var1, Throwable var2);
    }
}

