/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.metaobject;

import groovy.lang.GroovyObject;
import groovy.lang.GroovySystem;
import groovy.lang.MetaBeanProperty;
import groovy.lang.MetaClass;
import groovy.lang.MetaClassImpl;
import groovy.lang.MetaMethod;
import groovy.lang.MetaProperty;
import groovy.lang.MissingMethodException;
import groovy.lang.MissingPropertyException;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.codehaus.groovy.runtime.InvokerInvocationException;
import org.codehaus.groovy.runtime.MetaClassHelper;
import org.codehaus.groovy.runtime.metaclass.MultipleSetterProperty;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.gradle.api.internal.DynamicObjectAware;
import org.gradle.api.internal.coerce.MethodArgumentsTransformer;
import org.gradle.api.internal.coerce.PropertySetTransformer;
import org.gradle.api.internal.coerce.StringToEnumTransformer;
import org.gradle.api.internal.provider.support.LazyGroovySupport;
import org.gradle.api.provider.HasConfigurableValue;
import org.gradle.internal.Cast;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.metaobject.AbstractDynamicObject;
import org.gradle.internal.metaobject.DynamicInvokeResult;
import org.gradle.internal.metaobject.DynamicObject;
import org.gradle.internal.metaobject.InstrumentedMetaClass;
import org.gradle.internal.metaobject.MethodMixIn;
import org.gradle.internal.metaobject.PropertyMixIn;
import org.gradle.internal.reflect.JavaPropertyReflectionUtil;
import org.gradle.internal.state.ModelObject;

public class BeanDynamicObject
extends AbstractDynamicObject {
    private static final Method META_PROP_METHOD;
    private static final Field MISSING_PROPERTY_GET_METHOD;
    private static final Field MISSING_PROPERTY_SET_METHOD;
    private static final Field MISSING_METHOD_METHOD;
    private final Object bean;
    private final boolean includeProperties;
    private final MetaClassAdapter delegate;
    private final boolean implementsMissing;
    @Nullable
    private final Class<?> publicType;
    private final MethodArgumentsTransformer argsTransformer;
    private final PropertySetTransformer propertySetTransformer;
    private BeanDynamicObject withNoProperties;
    private BeanDynamicObject withNoImplementsMissing;
    private static final MethodHandle ADD_INVOCATION_HOOKS_TO_META_CLASS_METHOD;

    public BeanDynamicObject(Object bean) {
        this(bean, null, true, true, StringToEnumTransformer.INSTANCE, StringToEnumTransformer.INSTANCE);
    }

    public BeanDynamicObject(Object bean, @Nullable Class<?> publicType) {
        this(bean, publicType, true, true, StringToEnumTransformer.INSTANCE, StringToEnumTransformer.INSTANCE);
    }

    BeanDynamicObject(Object bean, @Nullable Class<?> publicType, boolean includeProperties, boolean implementsMissing, PropertySetTransformer propertySetTransformer, MethodArgumentsTransformer methodArgumentsTransformer) {
        if (bean == null) {
            throw new IllegalArgumentException("Value is null");
        }
        this.bean = bean;
        this.publicType = publicType;
        this.includeProperties = includeProperties;
        this.implementsMissing = implementsMissing;
        this.propertySetTransformer = propertySetTransformer;
        this.argsTransformer = methodArgumentsTransformer;
        this.delegate = this.determineDelegate(bean);
    }

    public MetaClassAdapter determineDelegate(Object bean) {
        if (bean instanceof Class) {
            return new ClassAdapter((Class)bean);
        }
        if (bean instanceof Map) {
            return new MapAdapter();
        }
        if (bean instanceof DynamicObject || bean instanceof DynamicObjectAware || !(bean instanceof GroovyObject)) {
            return new MetaClassAdapter();
        }
        return new GroovyObjectAdapter();
    }

    public BeanDynamicObject withNoProperties() {
        if (!this.includeProperties) {
            return this;
        }
        if (this.withNoProperties == null) {
            this.withNoProperties = new BeanDynamicObject(this.bean, this.publicType, false, this.implementsMissing, this.propertySetTransformer, this.argsTransformer);
        }
        return this.withNoProperties;
    }

    public BeanDynamicObject withNotImplementsMissing() {
        if (!this.implementsMissing) {
            return this;
        }
        if (this.withNoImplementsMissing == null) {
            this.withNoImplementsMissing = new BeanDynamicObject(this.bean, this.publicType, this.includeProperties, false, this.propertySetTransformer, this.argsTransformer);
        }
        return this.withNoImplementsMissing;
    }

    @Override
    public String getDisplayName() {
        return this.bean.toString();
    }

    @Override
    @Nullable
    public Class<?> getPublicType() {
        return this.publicType != null ? this.publicType : this.bean.getClass();
    }

    @Override
    public boolean hasUsefulDisplayName() {
        if (this.bean instanceof ModelObject) {
            return ((ModelObject)this.bean).hasUsefulDisplayName();
        }
        return !JavaPropertyReflectionUtil.hasDefaultToString(this.bean);
    }

    private MetaClass getMetaClass() {
        if (this.bean instanceof GroovyObject) {
            return ((GroovyObject)this.bean).getMetaClass();
        }
        return GroovySystem.getMetaClassRegistry().getMetaClass(this.bean.getClass());
    }

    @Override
    public boolean hasProperty(String name) {
        return this.delegate.hasProperty(name);
    }

    @Override
    public DynamicInvokeResult tryGetProperty(String name) {
        return this.delegate.getProperty(name);
    }

    @Override
    public DynamicInvokeResult trySetProperty(String name, Object value) {
        return this.delegate.setProperty(name, value);
    }

    @Override
    public Map<String, ?> getProperties() {
        return this.delegate.getProperties();
    }

    @Override
    public boolean hasMethod(String name, Object ... arguments) {
        return this.delegate.hasMethod(name, arguments);
    }

    @Override
    public DynamicInvokeResult tryInvokeMethod(String name, Object ... arguments) {
        return this.delegate.invokeMethod(name, arguments);
    }

    static {
        try {
            META_PROP_METHOD = MetaClassImpl.class.getDeclaredMethod("getMetaProperty", String.class, Boolean.TYPE);
            META_PROP_METHOD.setAccessible(true);
            MISSING_PROPERTY_GET_METHOD = MetaClassImpl.class.getDeclaredField("propertyMissingGet");
            MISSING_PROPERTY_GET_METHOD.setAccessible(true);
            MISSING_PROPERTY_SET_METHOD = MetaClassImpl.class.getDeclaredField("propertyMissingSet");
            MISSING_PROPERTY_SET_METHOD.setAccessible(true);
            MISSING_METHOD_METHOD = MetaClassImpl.class.getDeclaredField("methodMissing");
            MISSING_METHOD_METHOD.setAccessible(true);
        }
        catch (Exception e) {
            throw UncheckedException.throwAsUncheckedException(e);
        }
        try {
            Class<?> metaClassHelperClass = Class.forName("org.gradle.internal.classpath.InstrumentedGroovyMetaClassHelper");
            ADD_INVOCATION_HOOKS_TO_META_CLASS_METHOD = MethodHandles.lookup().findStatic(metaClassHelperClass, "addInvocationHooksToMetaClassIfInstrumented", MethodType.methodType(Void.TYPE, Class.class, String.class));
        }
        catch (NoSuchMethodException e) {
            throw new NoSuchMethodError(e.getMessage());
        }
        catch (IllegalAccessException e) {
            throw new IllegalAccessError(e.getMessage());
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private class ClassAdapter
    extends MetaClassAdapter {
        private final MetaClass classMetaData;

        ClassAdapter(Class<?> cl) {
            this.classMetaData = GroovySystem.getMetaClassRegistry().getMetaClass(cl);
        }

        @Override
        @Nullable
        protected MetaProperty lookupProperty(MetaClass metaClass, String name) {
            MetaProperty metaProperty = super.lookupProperty(metaClass, name);
            if (metaProperty != null) {
                return metaProperty;
            }
            metaProperty = this.classMetaData.getMetaProperty(name);
            if (metaProperty != null && Modifier.isStatic(metaProperty.getModifiers())) {
                return metaProperty;
            }
            return null;
        }

        @Override
        @Nullable
        protected MetaMethod lookupMethod(MetaClass metaClass, String name, Class[] arguments) {
            MetaMethod metaMethod = super.lookupMethod(metaClass, name, arguments);
            if (metaMethod != null) {
                return metaMethod;
            }
            metaMethod = this.classMetaData.getMetaMethod(name, (Object[])arguments);
            if (metaMethod != null && Modifier.isStatic(metaMethod.getModifiers())) {
                return metaMethod;
            }
            return null;
        }
    }

    private class MapAdapter
    extends MetaClassAdapter {
        Map<String, Object> map;

        private MapAdapter() {
            this.map = (Map)Cast.uncheckedNonnullCast(BeanDynamicObject.this.bean);
        }

        @Override
        public boolean hasProperty(String name) {
            return this.map.containsKey(name) || super.hasProperty(name);
        }

        @Override
        protected DynamicInvokeResult getOpaqueProperty(String name) {
            return DynamicInvokeResult.found(this.map.get(name));
        }

        @Override
        protected void getOpaqueProperties(Map<String, Object> properties) {
            properties.putAll(this.map);
        }

        @Override
        protected DynamicInvokeResult setOpaqueProperty(MetaClass metaClass, String name, Object value) {
            this.map.put(name, value);
            return DynamicInvokeResult.found();
        }
    }

    private class GroovyObjectAdapter
    extends MetaClassAdapter {
        private final GroovyObject groovyObject;

        private GroovyObjectAdapter() {
            this.groovyObject = (GroovyObject)BeanDynamicObject.this.bean;
        }

        @Override
        protected DynamicInvokeResult getOpaqueProperty(String name) {
            try {
                return DynamicInvokeResult.found(this.groovyObject.getProperty(name));
            }
            catch (MissingPropertyException e) {
                if (!name.equals(e.getProperty())) {
                    throw e;
                }
                return DynamicInvokeResult.notFound();
            }
        }

        @Override
        protected DynamicInvokeResult setOpaqueProperty(MetaClass metaClass, String name, Object value) {
            try {
                this.groovyObject.setProperty(name, value);
                return DynamicInvokeResult.found();
            }
            catch (MissingPropertyException e) {
                if (!name.equals(e.getProperty())) {
                    throw e;
                }
                return DynamicInvokeResult.notFound();
            }
        }

        @Override
        protected DynamicInvokeResult invokeOpaqueMethod(MetaClass metaClass, String name, Object[] arguments) {
            try {
                try {
                    return DynamicInvokeResult.found(this.groovyObject.invokeMethod(name, (Object)arguments));
                }
                catch (InvokerInvocationException e) {
                    if (e.getCause() instanceof RuntimeException) {
                        throw (RuntimeException)e.getCause();
                    }
                    throw e;
                }
            }
            catch (MissingMethodException e) {
                if (!e.getMethod().equals(name) || !Arrays.equals(e.getArguments(), arguments)) {
                    throw e;
                }
                return DynamicInvokeResult.notFound();
            }
        }
    }

    private class MetaClassAdapter {
        private MetaClassAdapter() {
        }

        protected String getDisplayName() {
            return BeanDynamicObject.this.getDisplayName();
        }

        public boolean hasProperty(String name) {
            if (!BeanDynamicObject.this.includeProperties) {
                return false;
            }
            if (this.lookupProperty(BeanDynamicObject.this.getMetaClass(), name) != null) {
                return true;
            }
            if (BeanDynamicObject.this.bean instanceof PropertyMixIn) {
                PropertyMixIn propertyMixIn = (PropertyMixIn)BeanDynamicObject.this.bean;
                return propertyMixIn.getAdditionalProperties().hasProperty(name);
            }
            return false;
        }

        public DynamicInvokeResult getProperty(String name) {
            block11: {
                if (!BeanDynamicObject.this.includeProperties) {
                    return DynamicInvokeResult.notFound();
                }
                this.maybeAddCallInterceptionHooksToMetaclass(name);
                MetaClass metaClass = BeanDynamicObject.this.getMetaClass();
                MetaProperty property2 = this.lookupProperty(metaClass, name);
                if (property2 != null) {
                    if (property2 instanceof MetaBeanProperty && ((MetaBeanProperty)property2).getGetter() == null) {
                        throw BeanDynamicObject.this.getWriteOnlyProperty(name);
                    }
                    try {
                        return DynamicInvokeResult.found(property2.getProperty(BeanDynamicObject.this.bean));
                    }
                    catch (InvokerInvocationException e) {
                        if (e.getCause() instanceof RuntimeException) {
                            throw (RuntimeException)e.getCause();
                        }
                        throw e;
                    }
                }
                if (BeanDynamicObject.this.bean instanceof PropertyMixIn) {
                    PropertyMixIn propertyMixIn = (PropertyMixIn)BeanDynamicObject.this.bean;
                    return propertyMixIn.getAdditionalProperties().tryGetProperty(name);
                }
                if (!BeanDynamicObject.this.implementsMissing) {
                    return DynamicInvokeResult.notFound();
                }
                MetaMethod propertyMissing = this.findGetPropertyMissingMethod(metaClass);
                if (propertyMissing != null) {
                    try {
                        return DynamicInvokeResult.found(propertyMissing.invoke(BeanDynamicObject.this.bean, new Object[]{name}));
                    }
                    catch (MissingPropertyException e) {
                        if (name.equals(e.getProperty())) break block11;
                        throw e;
                    }
                }
            }
            return this.getOpaqueProperty(name);
        }

        private void maybeAddCallInterceptionHooksToMetaclass(String name) {
            try {
                ADD_INVOCATION_HOOKS_TO_META_CLASS_METHOD.invoke(BeanDynamicObject.this.bean.getClass(), name);
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }

        protected DynamicInvokeResult getOpaqueProperty(String name) {
            return DynamicInvokeResult.notFound();
        }

        @Nullable
        private MetaMethod findGetPropertyMissingMethod(MetaClass metaClass) {
            if (metaClass instanceof MetaClassImpl) {
                try {
                    return (MetaMethod)MISSING_PROPERTY_GET_METHOD.get(metaClass);
                }
                catch (IllegalAccessException e) {
                    throw UncheckedException.throwAsUncheckedException(e);
                }
            }
            for (MetaMethod method : metaClass.getMethods()) {
                if (!method.getName().equals("propertyMissing") || method.getParameterTypes().length != 1) continue;
                return method;
            }
            return null;
        }

        @Nullable
        private MetaMethod findSetPropertyMissingMethod(MetaClass metaClass) {
            if (metaClass instanceof MetaClassImpl) {
                try {
                    return (MetaMethod)MISSING_PROPERTY_SET_METHOD.get(metaClass);
                }
                catch (IllegalAccessException e) {
                    throw UncheckedException.throwAsUncheckedException(e);
                }
            }
            for (MetaMethod method : metaClass.getMethods()) {
                if (!method.getName().equals("propertyMissing") || method.getParameterTypes().length != 2) continue;
                return method;
            }
            return null;
        }

        @Nullable
        private MetaMethod findMethodMissingMethod(MetaClass metaClass) {
            if (metaClass instanceof MetaClassImpl) {
                try {
                    return (MetaMethod)MISSING_METHOD_METHOD.get(metaClass);
                }
                catch (IllegalAccessException e) {
                    throw UncheckedException.throwAsUncheckedException(e);
                }
            }
            for (MetaMethod method : metaClass.getMethods()) {
                if (!method.getName().equals("methodMissing") || method.getParameterTypes().length != 2) continue;
                return method;
            }
            return null;
        }

        @Nullable
        protected MetaProperty lookupProperty(MetaClass metaClass, String name) {
            boolean isInstrumented;
            boolean bl = isInstrumented = metaClass instanceof InstrumentedMetaClass && ((InstrumentedMetaClass)metaClass).interceptsPropertyAccess(name);
            if (metaClass instanceof MetaClassImpl && !isInstrumented) {
                try {
                    return (MetaProperty)META_PROP_METHOD.invoke((Object)metaClass, name, false);
                }
                catch (Throwable e) {
                    throw UncheckedException.throwAsUncheckedException(e);
                }
            }
            return metaClass.getMetaProperty(name);
        }

        public DynamicInvokeResult setProperty(String name, Object value) {
            MetaClass metaClass;
            block16: {
                if (!BeanDynamicObject.this.includeProperties) {
                    return DynamicInvokeResult.notFound();
                }
                this.maybeAddCallInterceptionHooksToMetaclass(name);
                metaClass = BeanDynamicObject.this.getMetaClass();
                MetaProperty property2 = this.lookupProperty(metaClass, name);
                if (property2 != null) {
                    if (property2 instanceof MultipleSetterProperty) {
                        String setterName = MetaProperty.getSetterName((String)property2.getName());
                        DynamicInvokeResult setterResult = this.invokeMethod(setterName, value);
                        if (setterResult.isFound()) {
                            return DynamicInvokeResult.found();
                        }
                    } else {
                        if (property2 instanceof MetaBeanProperty) {
                            MetaBeanProperty metaBeanProperty = (MetaBeanProperty)property2;
                            if (metaBeanProperty.getSetter() == null) {
                                if (metaBeanProperty.getField() == null) {
                                    this.trySetGetterOnlyProperty(name, value, metaBeanProperty);
                                } else {
                                    value = BeanDynamicObject.this.propertySetTransformer.transformValue(metaBeanProperty.getField().getType(), value);
                                    metaBeanProperty.getField().setProperty(BeanDynamicObject.this.bean, value);
                                }
                            } else {
                                Class setterType = metaBeanProperty.getSetter().getParameterTypes()[0].getTheClass();
                                value = BeanDynamicObject.this.propertySetTransformer.transformValue(setterType, value);
                                value = DefaultTypeTransformation.castToType((Object)value, (Class)setterType);
                                metaBeanProperty.getSetter().invoke(BeanDynamicObject.this.bean, new Object[]{value});
                            }
                        } else {
                            value = BeanDynamicObject.this.propertySetTransformer.transformValue(property2.getType(), value);
                            property2.setProperty(BeanDynamicObject.this.bean, value);
                        }
                        return DynamicInvokeResult.found();
                    }
                }
                if (BeanDynamicObject.this.bean instanceof PropertyMixIn) {
                    PropertyMixIn propertyMixIn = (PropertyMixIn)BeanDynamicObject.this.bean;
                    return propertyMixIn.getAdditionalProperties().trySetProperty(name, value);
                }
                if (!BeanDynamicObject.this.implementsMissing) {
                    return DynamicInvokeResult.notFound();
                }
                MetaMethod propertyMissingMethod = this.findSetPropertyMissingMethod(metaClass);
                if (propertyMissingMethod != null) {
                    try {
                        propertyMissingMethod.invoke(BeanDynamicObject.this.bean, new Object[]{name, value});
                        return DynamicInvokeResult.found();
                    }
                    catch (MissingPropertyException e) {
                        if (name.equals(e.getProperty())) break block16;
                        throw e;
                    }
                }
            }
            return this.setOpaqueProperty(metaClass, name, value);
        }

        private void trySetGetterOnlyProperty(String name, Object value, MetaBeanProperty metaBeanProperty) {
            Object propertyValue;
            Class propertyType = metaBeanProperty.getType();
            if (HasConfigurableValue.class.isAssignableFrom(propertyType) && (propertyValue = metaBeanProperty.getGetter().invoke(BeanDynamicObject.this.bean, new Object[0])) instanceof LazyGroovySupport) {
                value = BeanDynamicObject.this.propertySetTransformer.transformValue(propertyType, value);
                ((LazyGroovySupport)propertyValue).setFromAnyValue(value);
                return;
            }
            throw BeanDynamicObject.this.setGetterOnlyProperty(name);
        }

        protected DynamicInvokeResult setOpaqueProperty(MetaClass metaClass, String name, Object value) {
            return DynamicInvokeResult.notFound();
        }

        public Map<String, ?> getProperties() {
            if (!BeanDynamicObject.this.includeProperties) {
                return Collections.emptyMap();
            }
            HashMap<String, Object> properties = new HashMap<String, Object>();
            List classProperties = BeanDynamicObject.this.getMetaClass().getProperties();
            for (MetaProperty metaProperty : classProperties) {
                MetaBeanProperty beanProperty;
                int modifiers = metaProperty.getModifiers();
                if (Modifier.isStatic(modifiers) || !Modifier.isPublic(modifiers)) continue;
                if (metaProperty.getName().equals("properties")) {
                    properties.put("properties", properties);
                    continue;
                }
                if (metaProperty instanceof MetaBeanProperty && (beanProperty = (MetaBeanProperty)metaProperty).getGetter() == null) continue;
                properties.put(metaProperty.getName(), metaProperty.getProperty(BeanDynamicObject.this.bean));
            }
            if (BeanDynamicObject.this.bean instanceof PropertyMixIn) {
                PropertyMixIn propertyMixIn = (PropertyMixIn)BeanDynamicObject.this.bean;
                properties.putAll(propertyMixIn.getAdditionalProperties().getProperties());
            }
            this.getOpaqueProperties(properties);
            return properties;
        }

        protected void getOpaqueProperties(Map<String, Object> properties) {
        }

        public boolean hasMethod(String name, Object ... arguments) {
            if (this.lookupMethod(BeanDynamicObject.this.getMetaClass(), name, this.inferTypes(arguments)) != null) {
                return true;
            }
            if (BeanDynamicObject.this.bean instanceof MethodMixIn) {
                MethodMixIn methodMixIn = (MethodMixIn)BeanDynamicObject.this.bean;
                return methodMixIn.getAdditionalMethods().hasMethod(name, arguments);
            }
            return false;
        }

        private Class[] inferTypes(Object[] arguments) {
            if (arguments == null || arguments.length == 0) {
                return MetaClassHelper.EMPTY_CLASS_ARRAY;
            }
            Class[] classes = new Class[arguments.length];
            for (int i = 0; i < arguments.length; ++i) {
                Object argType = arguments[i];
                classes[i] = argType == null ? null : argType.getClass();
            }
            return classes;
        }

        public DynamicInvokeResult invokeMethod(String name, Object ... arguments) {
            this.maybeAddCallInterceptionHooksToMetaclass(name);
            MetaClass metaClass = BeanDynamicObject.this.getMetaClass();
            MetaMethod metaMethod = this.lookupMethod(metaClass, name, this.inferTypes(arguments));
            if (metaMethod != null) {
                return DynamicInvokeResult.found(metaMethod.doMethodInvoke(BeanDynamicObject.this.bean, arguments));
            }
            if (BeanDynamicObject.this.argsTransformer.canTransform(arguments)) {
                List metaMethods = metaClass.respondsTo(BeanDynamicObject.this.bean, name);
                for (MetaMethod method : metaMethods) {
                    Object[] transformed;
                    if (method.getParameterTypes().length != arguments.length || (transformed = BeanDynamicObject.this.argsTransformer.transform(method.getParameterTypes(), arguments)) == arguments) continue;
                    return DynamicInvokeResult.found(method.doMethodInvoke(BeanDynamicObject.this.bean, transformed));
                }
            }
            if (BeanDynamicObject.this.bean instanceof MethodMixIn) {
                MethodMixIn methodMixIn = (MethodMixIn)BeanDynamicObject.this.bean;
                return methodMixIn.getAdditionalMethods().tryInvokeMethod(name, arguments);
            }
            if (!BeanDynamicObject.this.implementsMissing) {
                return DynamicInvokeResult.notFound();
            }
            return this.invokeOpaqueMethod(metaClass, name, arguments);
        }

        @Nullable
        protected MetaMethod lookupMethod(MetaClass metaClass, String name, Class[] arguments) {
            return metaClass.pickMethod(name, arguments);
        }

        protected DynamicInvokeResult invokeOpaqueMethod(MetaClass metaClass, String name, Object[] arguments) {
            block6: {
                MetaMethod methodMissingMethod = this.findMethodMissingMethod(metaClass);
                if (methodMissingMethod != null) {
                    try {
                        try {
                            return DynamicInvokeResult.found(methodMissingMethod.invoke(BeanDynamicObject.this.bean, new Object[]{name, arguments}));
                        }
                        catch (InvokerInvocationException e) {
                            if (e.getCause() instanceof MissingMethodException) {
                                throw (MissingMethodException)e.getCause();
                            }
                            throw e;
                        }
                    }
                    catch (MissingMethodException e) {
                        if (e.getMethod().equals(name) && Arrays.equals(e.getArguments(), arguments)) break block6;
                        throw e;
                    }
                }
            }
            return DynamicInvokeResult.notFound();
        }
    }
}

