/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.serialize;

import java.io.IOException;
import java.io.InputStream;
import org.gradle.internal.InternalTransformer;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.io.ClassLoaderObjectInputStream;
import org.gradle.internal.serialize.ExceptionPlaceholder;
import org.gradle.internal.serialize.TopLevelExceptionPlaceholder;

public class ExceptionReplacingObjectInputStream
extends ClassLoaderObjectInputStream {
    private InternalTransformer<Object, Object> objectTransformer = new InternalTransformer<Object, Object>(){

        @Override
        public Object transform(Object o) {
            try {
                return ExceptionReplacingObjectInputStream.this.doResolveObject(o);
            }
            catch (IOException e) {
                throw UncheckedException.throwAsUncheckedException(e);
            }
        }
    };

    public ExceptionReplacingObjectInputStream(InputStream inputSteam, ClassLoader classLoader) throws IOException {
        super(inputSteam, classLoader);
        this.enableResolveObject(true);
    }

    public final InternalTransformer<ExceptionReplacingObjectInputStream, InputStream> getObjectInputStreamCreator() {
        return new InternalTransformer<ExceptionReplacingObjectInputStream, InputStream>(){

            @Override
            public ExceptionReplacingObjectInputStream transform(InputStream inputStream) {
                try {
                    return ExceptionReplacingObjectInputStream.this.createNewInstance(inputStream);
                }
                catch (IOException e) {
                    throw UncheckedException.throwAsUncheckedException(e);
                }
            }
        };
    }

    protected ExceptionReplacingObjectInputStream createNewInstance(InputStream inputStream) throws IOException {
        return new ExceptionReplacingObjectInputStream(inputStream, this.getClassLoader());
    }

    @Override
    protected final Object resolveObject(Object obj) throws IOException {
        return this.getObjectTransformer().transform(obj);
    }

    protected Object doResolveObject(Object obj) throws IOException {
        if (obj instanceof TopLevelExceptionPlaceholder) {
            return ((ExceptionPlaceholder)obj).read(this.getClassNameTransformer(), this.getObjectInputStreamCreator());
        }
        return obj;
    }

    protected final InternalTransformer<Class<?>, String> getClassNameTransformer() {
        return new InternalTransformer<Class<?>, String>(){

            @Override
            public Class<?> transform(String type) {
                try {
                    return ExceptionReplacingObjectInputStream.this.lookupClass(type);
                }
                catch (ClassNotFoundException e) {
                    throw UncheckedException.throwAsUncheckedException(e);
                }
            }
        };
    }

    protected Class<?> lookupClass(String type) throws ClassNotFoundException {
        return this.getClassLoader().loadClass(type);
    }

    public InternalTransformer<Object, Object> getObjectTransformer() {
        return this.objectTransformer;
    }

    public void setObjectTransformer(InternalTransformer<Object, Object> objectTransformer) {
        this.objectTransformer = objectTransformer;
    }
}

