/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.jvm.toolchain.internal;

import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Provider;
import org.gradle.internal.operations.BuildOperationProgressEventEmitter;
import org.gradle.jvm.toolchain.JavaCompiler;
import org.gradle.jvm.toolchain.JavaLauncher;
import org.gradle.jvm.toolchain.JavaToolchainService;
import org.gradle.jvm.toolchain.JavaToolchainSpec;
import org.gradle.jvm.toolchain.JavadocTool;
import org.gradle.jvm.toolchain.internal.DefaultJavaToolchainUsageProgressDetails;
import org.gradle.jvm.toolchain.internal.DefaultToolchainJavaCompiler;
import org.gradle.jvm.toolchain.internal.DefaultToolchainJavaLauncher;
import org.gradle.jvm.toolchain.internal.DefaultToolchainSpec;
import org.gradle.jvm.toolchain.internal.JavaCompilerFactory;
import org.gradle.jvm.toolchain.internal.JavaToolchain;
import org.gradle.jvm.toolchain.internal.JavaToolchainQueryService;
import org.gradle.jvm.toolchain.internal.ToolchainToolFactory;

public class DefaultJavaToolchainService
implements JavaToolchainService {
    private final JavaToolchainQueryService queryService;
    private final ObjectFactory objectFactory;
    private final JavaCompilerFactory compilerFactory;
    private final ToolchainToolFactory toolFactory;
    private final BuildOperationProgressEventEmitter eventEmitter;

    @Inject
    public DefaultJavaToolchainService(JavaToolchainQueryService queryService, ObjectFactory objectFactory, JavaCompilerFactory compilerFactory, ToolchainToolFactory toolFactory, BuildOperationProgressEventEmitter eventEmitter) {
        this.queryService = queryService;
        this.objectFactory = objectFactory;
        this.compilerFactory = compilerFactory;
        this.toolFactory = toolFactory;
        this.eventEmitter = eventEmitter;
    }

    @Override
    public Provider<JavaCompiler> compilerFor(Action<? super JavaToolchainSpec> config) {
        return this.compilerFor(this.configureToolchainSpec(config));
    }

    @Override
    public Provider<JavaCompiler> compilerFor(JavaToolchainSpec spec) {
        return this.queryService.findMatchingToolchain(spec).withSideEffect(toolchain -> this.emitEvent((JavaToolchain)toolchain, DefaultJavaToolchainUsageProgressDetails.JavaTool.COMPILER)).map(javaToolchain -> new DefaultToolchainJavaCompiler((JavaToolchain)javaToolchain, this.compilerFactory));
    }

    @Override
    public Provider<JavaLauncher> launcherFor(Action<? super JavaToolchainSpec> config) {
        return this.launcherFor(this.configureToolchainSpec(config));
    }

    @Override
    public Provider<JavaLauncher> launcherFor(JavaToolchainSpec spec) {
        return this.queryService.findMatchingToolchain(spec).withSideEffect(toolchain -> this.emitEvent((JavaToolchain)toolchain, DefaultJavaToolchainUsageProgressDetails.JavaTool.LAUNCHER)).map(DefaultToolchainJavaLauncher::new);
    }

    @Override
    public Provider<JavadocTool> javadocToolFor(Action<? super JavaToolchainSpec> config) {
        return this.javadocToolFor(this.configureToolchainSpec(config));
    }

    @Override
    public Provider<JavadocTool> javadocToolFor(JavaToolchainSpec spec) {
        return this.queryService.findMatchingToolchain(spec).withSideEffect(toolchain -> this.emitEvent((JavaToolchain)toolchain, DefaultJavaToolchainUsageProgressDetails.JavaTool.JAVADOC)).map(javaToolchain -> this.toolFactory.create(JavadocTool.class, (JavaToolchain)javaToolchain));
    }

    private DefaultToolchainSpec configureToolchainSpec(Action<? super JavaToolchainSpec> config) {
        DefaultToolchainSpec toolchainSpec = this.objectFactory.newInstance(DefaultToolchainSpec.class, new Object[0]);
        config.execute(toolchainSpec);
        return toolchainSpec;
    }

    private void emitEvent(JavaToolchain toolchain, DefaultJavaToolchainUsageProgressDetails.JavaTool toolName) {
        this.eventEmitter.emitNowForCurrent(new DefaultJavaToolchainUsageProgressDetails(toolName, toolchain.getMetadata()));
    }
}

