/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.nativeplatform.internal.incremental.sourceparser;

import java.io.File;
import org.gradle.cache.internal.FileContentCache;
import org.gradle.cache.internal.FileContentCacheFactory;
import org.gradle.language.nativeplatform.internal.IncludeDirectives;
import org.gradle.language.nativeplatform.internal.incremental.sourceparser.CSourceParser;
import org.gradle.language.nativeplatform.internal.incremental.sourceparser.IncludeDirectivesSerializer;
import org.gradle.language.nativeplatform.internal.incremental.sourceparser.RegexBackedCSourceParser;

public class CachingCSourceParser
implements CSourceParser {
    private final FileContentCache<IncludeDirectives> cache;

    public CachingCSourceParser(FileContentCacheFactory cacheFactory) {
        final RegexBackedCSourceParser parser = new RegexBackedCSourceParser();
        this.cache = cacheFactory.newCache("parsedCSource", 40000, new FileContentCacheFactory.Calculator<IncludeDirectives>(){

            @Override
            public IncludeDirectives calculate(File file, boolean isRegularFile) {
                return parser.parseSource(file);
            }
        }, IncludeDirectivesSerializer.INSTANCE);
    }

    @Override
    public IncludeDirectives parseSource(File sourceFile) {
        return this.cache.get(sourceFile);
    }
}

