/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.registry;

import java.util.Collections;
import java.util.Set;
import javax.annotation.Nullable;
import org.gradle.internal.Cast;
import org.gradle.internal.impldep.com.google.common.base.Optional;
import org.gradle.internal.impldep.com.google.common.base.Predicate;
import org.gradle.model.RuleSource;
import org.gradle.model.internal.core.InstanceModelView;
import org.gradle.model.internal.core.ModelAction;
import org.gradle.model.internal.core.ModelActionRole;
import org.gradle.model.internal.core.ModelAdapter;
import org.gradle.model.internal.core.ModelNode;
import org.gradle.model.internal.core.ModelPath;
import org.gradle.model.internal.core.ModelPromise;
import org.gradle.model.internal.core.ModelRegistration;
import org.gradle.model.internal.core.ModelView;
import org.gradle.model.internal.core.MutableModelNode;
import org.gradle.model.internal.core.NodePredicate;
import org.gradle.model.internal.core.rule.describe.ModelRuleDescriptor;
import org.gradle.model.internal.registry.ModelNodeInternal;
import org.gradle.model.internal.registry.ModelRegistryInternal;
import org.gradle.model.internal.type.ModelType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModelReferenceNode
extends ModelNodeInternal {
    private static final Logger LOGGER = LoggerFactory.getLogger(ModelReferenceNode.class);
    private final MutableModelNode parent;
    private ModelNodeInternal target;

    public ModelReferenceNode(ModelRegistryInternal modelRegistry, ModelRegistration registration, MutableModelNode parent) {
        super(modelRegistry, registration);
        this.parent = parent;
    }

    @Override
    public void setTarget(ModelNode target) {
        if (this.getState() != ModelNode.State.Registered) {
            throw new IllegalStateException(String.format("Cannot set target for model element '%s' as this element is not mutable.", this.getPath()));
        }
        if (LOGGER.isDebugEnabled()) {
            String targetPath = target == null ? null : "'" + target.getPath() + "'";
            LOGGER.debug("Project {} - Setting the target of model element '{}' to point at {}.", new Object[]{this.modelRegistry.getProjectPath(), this.getPath(), targetPath});
        }
        this.target = (ModelNodeInternal)target;
    }

    public ModelNodeInternal getTarget() {
        return this.target;
    }

    @Override
    public Optional<String> getValueDescription() {
        if (this.target == null) {
            return Optional.of((Object)"null");
        }
        return Optional.of((Object)("reference to element '" + this.target.getPath() + "'"));
    }

    @Override
    public boolean canBeViewedAs(ModelType<?> type) {
        return this.target == null ? super.canBeViewedAs(type) : this.target.canBeViewedAs(type);
    }

    @Override
    public <T> ModelView<? extends T> asMutable(ModelType<T> type, ModelRuleDescriptor ruleDescriptor) {
        if (this.target == null) {
            return InstanceModelView.of(this.getPath(), type, null);
        }
        return new ModelViewWrapper<T>(this.getPath(), this.target.asMutable(type, ruleDescriptor));
    }

    @Override
    public <T> ModelView<? extends T> asImmutable(ModelType<T> type, @Nullable ModelRuleDescriptor ruleDescriptor) {
        if (this.target == null) {
            return InstanceModelView.of(this.getPath(), type, null);
        }
        return new ModelViewWrapper<T>(this.getPath(), this.target.asImmutable(type, ruleDescriptor));
    }

    @Override
    public ModelPromise getPromise() {
        return this.target == null ? super.getPromise() : this.target.getPromise();
    }

    @Override
    public ModelAdapter getAdapter() {
        return this.target == null ? super.getAdapter() : this.target.getAdapter();
    }

    @Override
    public void addLink(ModelRegistration registration) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> void addReference(String name, ModelType<T> type, ModelNode target, ModelRuleDescriptor ruleDescriptor) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeLink(String name) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void applyToLink(ModelActionRole type, ModelAction action) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void applyTo(NodePredicate predicate, ModelActionRole role, ModelAction action) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void applyTo(NodePredicate predicate, Class<? extends RuleSource> rules) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getLinkCount(Predicate<? super MutableModelNode> predicate) {
        return this.target == null ? 0 : this.target.getLinkCount(predicate);
    }

    @Override
    public Set<String> getLinkNames(Predicate<? super MutableModelNode> predicate) {
        return this.target == null ? Collections.emptySet() : this.target.getLinkNames(predicate);
    }

    @Override
    public Set<String> getLinkNames() {
        return this.target == null ? Collections.emptySet() : this.target.getLinkNames();
    }

    @Override
    @Nullable
    public ModelNodeInternal getLink(String name) {
        return this.target == null ? null : this.target.getLink(name);
    }

    @Override
    public Iterable<? extends ModelNodeInternal> getLinks() {
        return this.target == null ? Collections.emptyList() : this.target.getLinks();
    }

    @Override
    public Iterable<? extends MutableModelNode> getLinks(Predicate<? super MutableModelNode> predicate) {
        return this.target == null ? Collections.emptyList() : this.target.getLinks(predicate);
    }

    @Override
    public int getLinkCount() {
        return this.target == null ? 0 : this.target.getLinkCount();
    }

    @Override
    public boolean hasLink(String name, Predicate<? super MutableModelNode> predicate) {
        return this.target != null && this.target.hasLink(name, predicate);
    }

    @Override
    public boolean hasLink(String name) {
        return this.target != null && this.target.hasLink(name);
    }

    @Override
    public <T> T getPrivateData(ModelType<T> type) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> void setPrivateData(Class<? super T> type, T object) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> void setPrivateData(ModelType<? super T> type, T object) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object getPrivateData() {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T getPrivateData(Class<T> type) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void ensureUsable() {
        if (this.target != null) {
            this.target.ensureUsable();
        }
    }

    @Override
    public void ensureAtLeast(ModelNode.State state) {
        if (this.target != null) {
            this.target.ensureAtLeast(state);
        }
    }

    @Override
    public MutableModelNode getParent() {
        return this.parent;
    }

    private static class ModelViewWrapper<T>
    implements ModelView<T> {
        private final ModelView<? extends T> view;
        private final ModelPath path;

        public ModelViewWrapper(ModelPath path, ModelView<? extends T> view) {
            this.path = path;
            this.view = view;
        }

        @Override
        public ModelPath getPath() {
            return this.path;
        }

        @Override
        public ModelType<T> getType() {
            return (ModelType)Cast.uncheckedCast(this.view.getType());
        }

        @Override
        public T getInstance() {
            return this.view.getInstance();
        }

        @Override
        public void close() {
            this.view.close();
        }
    }
}

