/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugins.ide.eclipse;

import javax.inject.Inject;
import org.gradle.api.internal.PropertiesTransformer;
import org.gradle.api.tasks.Internal;
import org.gradle.plugins.ide.api.PropertiesFileContentMerger;
import org.gradle.plugins.ide.api.PropertiesGeneratorTask;
import org.gradle.plugins.ide.eclipse.model.EclipseJdt;
import org.gradle.plugins.ide.eclipse.model.Jdt;
import org.gradle.work.DisableCachingByDefault;

@DisableCachingByDefault(because="Not made cacheable, yet")
public abstract class GenerateEclipseJdt
extends PropertiesGeneratorTask<Jdt> {
    private EclipseJdt jdt;

    public GenerateEclipseJdt() {
        this.jdt = this.getInstantiator().newInstance(EclipseJdt.class, new PropertiesFileContentMerger(this.getTransformer()));
    }

    @Inject
    public GenerateEclipseJdt(EclipseJdt jdt) {
        this.jdt = jdt;
    }

    @Override
    protected Jdt create() {
        return new Jdt(this.getTransformer());
    }

    @Override
    protected void configure(Jdt jdtContent) {
        EclipseJdt jdtModel = this.getJdt();
        jdtModel.getFile().getBeforeMerged().execute(jdtContent);
        jdtContent.setSourceCompatibility(jdtModel.getSourceCompatibility());
        jdtContent.setTargetCompatibility(jdtModel.getTargetCompatibility());
        jdtModel.getFile().getWhenMerged().execute(jdtContent);
    }

    @Override
    protected PropertiesTransformer getTransformer() {
        if (this.jdt == null) {
            return super.getTransformer();
        }
        return this.jdt.getFile().getTransformer();
    }

    @Internal
    public EclipseJdt getJdt() {
        return this.jdt;
    }

    public void setJdt(EclipseJdt jdt) {
        this.jdt = jdt;
    }
}

