/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.provider.runner;

import org.gradle.api.NonNullApi;
import org.gradle.api.problems.Problem;
import org.gradle.api.problems.internal.DefaultProblemProgressDetails;
import org.gradle.internal.build.event.types.DefaultProblemDescriptor;
import org.gradle.internal.build.event.types.DefaultProblemDetails;
import org.gradle.internal.build.event.types.DefaultProblemEvent;
import org.gradle.internal.impldep.com.google.common.collect.BiMap;
import org.gradle.internal.impldep.com.google.common.collect.HashBiMap;
import org.gradle.internal.impldep.com.google.gson.Gson;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.BuildOperationIdFactory;
import org.gradle.internal.operations.BuildOperationListener;
import org.gradle.internal.operations.OperationFinishEvent;
import org.gradle.internal.operations.OperationIdentifier;
import org.gradle.internal.operations.OperationProgressEvent;
import org.gradle.tooling.internal.provider.runner.ClientForwardingBuildOperationListener;
import org.gradle.tooling.internal.provider.runner.ProgressEventConsumer;

@NonNullApi
public class ProblemsProgressEventConsumer
extends ClientForwardingBuildOperationListener
implements BuildOperationListener {
    private final BuildOperationIdFactory idFactory;
    private final BiMap<Throwable, OperationIdentifier> seenProblems = HashBiMap.create((int)10);

    public ProblemsProgressEventConsumer(ProgressEventConsumer progressEventConsumer, BuildOperationIdFactory idFactory) {
        super(progressEventConsumer);
        this.idFactory = idFactory;
    }

    @Override
    public void progress(OperationIdentifier buildOperationId, OperationProgressEvent progressEvent) {
        Object details = progressEvent.getDetails();
        if (details instanceof DefaultProblemProgressDetails) {
            Problem problem2 = ((DefaultProblemProgressDetails)details).getProblem();
            Throwable problemCause = problem2.getCause();
            if (this.seenProblems.containsKey((Object)problemCause)) {
                return;
            }
            this.seenProblems.put((Object)problemCause, (Object)buildOperationId);
            this.eventConsumer.progress(new DefaultProblemEvent(new DefaultProblemDescriptor(new OperationIdentifier(this.idFactory.nextId()), buildOperationId), new DefaultProblemDetails(new Gson().toJson((Object)problem2))));
        }
    }

    @Override
    public void finished(BuildOperationDescriptor buildOperation, OperationFinishEvent result2) {
        super.finished(buildOperation, result2);
    }
}

