/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.provider.runner;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.gradle.configuration.project.ConfigureProjectBuildOperationType;
import org.gradle.internal.build.event.types.DefaultPluginApplicationResult;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;
import org.gradle.internal.operations.BuildOperationAncestryTracker;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.OperationFinishEvent;
import org.gradle.internal.operations.OperationIdentifier;
import org.gradle.internal.operations.OperationStartEvent;
import org.gradle.tooling.internal.protocol.events.InternalPluginIdentifier;
import org.gradle.tooling.internal.protocol.events.InternalProjectConfigurationResult;
import org.gradle.tooling.internal.provider.runner.BuildOperationTracker;
import org.gradle.tooling.internal.provider.runner.PluginApplicationTracker;

class ProjectConfigurationTracker
implements BuildOperationTracker {
    private final Map<OperationIdentifier, ProjectConfigurationResult> results = new ConcurrentHashMap<OperationIdentifier, ProjectConfigurationResult>();
    private final BuildOperationAncestryTracker ancestryTracker;
    private final PluginApplicationTracker pluginApplicationTracker;

    ProjectConfigurationTracker(BuildOperationAncestryTracker ancestryTracker, PluginApplicationTracker pluginApplicationTracker) {
        this.ancestryTracker = ancestryTracker;
        this.pluginApplicationTracker = pluginApplicationTracker;
    }

    @Override
    public List<? extends BuildOperationTracker> getTrackers() {
        return ImmutableList.of((Object)this.pluginApplicationTracker);
    }

    public List<InternalProjectConfigurationResult.InternalPluginApplicationResult> resultsFor(OperationIdentifier buildOperation) {
        ProjectConfigurationResult result2 = this.results.remove(buildOperation);
        if (result2 == null) {
            throw new IllegalStateException("Project configuration results are not available for build operation " + buildOperation);
        }
        return result2.toInternalPluginApplicationResults();
    }

    @Override
    public void started(BuildOperationDescriptor buildOperation, OperationStartEvent startEvent) {
        if (buildOperation.getDetails() instanceof ConfigureProjectBuildOperationType.Details) {
            this.results.put(buildOperation.getId(), new ProjectConfigurationResult());
        }
    }

    @Override
    public void finished(BuildOperationDescriptor buildOperation, OperationFinishEvent finishEvent) {
        PluginApplicationTracker.PluginApplication pluginApplication = this.pluginApplicationTracker.getRunningPluginApplication(buildOperation.getId());
        if (pluginApplication != null) {
            this.ancestryTracker.findClosestExistingAncestor(buildOperation.getParentId(), this.results::get).ifPresent(result2 -> {
                if (this.hasNoEnclosingRunningPluginApplicationForSamePlugin(buildOperation, pluginApplication.getPlugin())) {
                    result2.increment(pluginApplication, finishEvent.getEndTime() - finishEvent.getStartTime());
                }
            });
        }
    }

    private boolean hasNoEnclosingRunningPluginApplicationForSamePlugin(BuildOperationDescriptor buildOperation, InternalPluginIdentifier plugin) {
        return !this.pluginApplicationTracker.hasRunningPluginApplication(buildOperation.getParentId(), pluginApplication -> pluginApplication.getPlugin().equals(plugin));
    }

    private static class PluginApplicationResult {
        private final AtomicLong duration = new AtomicLong();
        private final InternalPluginIdentifier plugin;
        private final long firstApplicationId;

        PluginApplicationResult(InternalPluginIdentifier plugin, long firstApplicationId) {
            this.plugin = plugin;
            this.firstApplicationId = firstApplicationId;
        }

        long getFirstApplicationId() {
            return this.firstApplicationId;
        }

        void increment(long duration) {
            this.duration.addAndGet(duration);
        }

        InternalProjectConfigurationResult.InternalPluginApplicationResult toInternalPluginApplicationResult() {
            return new DefaultPluginApplicationResult(this.plugin, Duration.ofMillis(this.duration.get()));
        }
    }

    private static class ProjectConfigurationResult {
        private final Map<InternalPluginIdentifier, PluginApplicationResult> pluginApplicationResults = new ConcurrentHashMap<InternalPluginIdentifier, PluginApplicationResult>();

        private ProjectConfigurationResult() {
        }

        void increment(PluginApplicationTracker.PluginApplication pluginApplication, long duration) {
            InternalPluginIdentifier plugin = pluginApplication.getPlugin();
            this.pluginApplicationResults.computeIfAbsent(plugin, key -> new PluginApplicationResult(plugin, pluginApplication.getApplicationId())).increment(duration);
        }

        List<InternalProjectConfigurationResult.InternalPluginApplicationResult> toInternalPluginApplicationResults() {
            return this.pluginApplicationResults.values().stream().sorted(Comparator.comparing(PluginApplicationResult::getFirstApplicationId)).map(PluginApplicationResult::toInternalPluginApplicationResult).collect(Collectors.toCollection(ArrayList::new));
        }
    }
}

