/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.provider.runner;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.gradle.api.NamedDomainObjectSet;
import org.gradle.api.NonNullApi;
import org.gradle.api.Task;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.project.ProjectState;
import org.gradle.api.internal.tasks.testing.filter.DefaultTestFilter;
import org.gradle.api.specs.Specs;
import org.gradle.api.tasks.testing.AbstractTestTask;
import org.gradle.api.tasks.testing.Test;
import org.gradle.api.tasks.testing.TestExecutionException;
import org.gradle.api.tasks.testing.TestFilter;
import org.gradle.execution.EntryTaskSelector;
import org.gradle.execution.TaskSelection;
import org.gradle.execution.TaskSelectionException;
import org.gradle.execution.plan.ExecutionPlan;
import org.gradle.execution.plan.QueryableExecutionPlan;
import org.gradle.internal.build.event.types.DefaultTestDescriptor;
import org.gradle.process.internal.DefaultJavaDebugOptions;
import org.gradle.tooling.internal.protocol.events.InternalJvmTestDescriptor;
import org.gradle.tooling.internal.protocol.events.InternalTestDescriptor;
import org.gradle.tooling.internal.protocol.test.InternalDebugOptions;
import org.gradle.tooling.internal.protocol.test.InternalJvmTestRequest;
import org.gradle.tooling.internal.protocol.test.InternalTaskSpec;
import org.gradle.tooling.internal.protocol.test.InternalTestSpec;
import org.gradle.tooling.internal.provider.action.TestExecutionRequestAction;

@NonNullApi
class TestExecutionBuildConfigurationAction
implements EntryTaskSelector {
    private final TestExecutionRequestAction testExecutionRequest;

    public TestExecutionBuildConfigurationAction(TestExecutionRequestAction testExecutionRequest) {
        this.testExecutionRequest = testExecutionRequest;
    }

    @Override
    public void applyTasksTo(EntryTaskSelector.Context context, ExecutionPlan plan) {
        LinkedHashSet<Task> allTasksToRun = new LinkedHashSet<Task>();
        this.collectTasksForTestDescriptors(context, allTasksToRun);
        this.collectTasksForInternalJvmTestRequest(context.getGradle(), allTasksToRun);
        this.collectTestTasks(context, allTasksToRun);
        this.configureTestTasks(allTasksToRun);
        TestExecutionBuildConfigurationAction.addEntryTasksTo(plan, allTasksToRun);
    }

    @Override
    public void postProcessExecutionPlan(EntryTaskSelector.Context context, QueryableExecutionPlan plan) {
        this.configureTestTasksForTestDescriptors(context);
        this.configureTestTasksForInternalJvmTestRequest(plan);
        this.configureTestTasksInBuild(context);
    }

    private static void addEntryTasksTo(ExecutionPlan plan, Set<Task> allTasksToRun) {
        for (Task task : allTasksToRun) {
            plan.addEntryTask(task);
        }
    }

    private void configureTestTasks(Set<Task> tasks) {
        for (Task task : tasks) {
            if (!(task instanceof AbstractTestTask)) continue;
            this.configureTestTask((AbstractTestTask)task);
        }
    }

    private void configureTestTask(AbstractTestTask test) {
        InternalDebugOptions debugOptions;
        test.getFilter().setFailOnNoMatchingTests(false);
        test.getOutputs().upToDateWhen(Specs.SATISFIES_NONE);
        if (test instanceof Test && (debugOptions = this.testExecutionRequest.getDebugOptions()).isDebugMode()) {
            ((Test)test).debugOptions(javaDebugOptions -> {
                DefaultJavaDebugOptions options = (DefaultJavaDebugOptions)javaDebugOptions;
                options.getEnabled().set(true);
                options.getPort().set(debugOptions.getPort());
                options.getServer().set(false);
                options.getSuspend().set(false);
            });
        }
    }

    private void configureTestTasksForTestDescriptors(EntryTaskSelector.Context context) {
        Map<String, List<InternalJvmTestRequest>> taskAndTests = this.testExecutionRequest.getTaskAndTests();
        for (Map.Entry<String, List<InternalJvmTestRequest>> entry : taskAndTests.entrySet()) {
            String testTaskPath = entry.getKey();
            for (AbstractTestTask testTask : TestExecutionBuildConfigurationAction.queryTestTasks(context, testTaskPath)) {
                for (InternalJvmTestRequest jvmTestRequest : entry.getValue()) {
                    Iterator<Map.Entry<String, List<String>>> filter = testTask.getFilter();
                    filter.includeTest(jvmTestRequest.getClassName(), jvmTestRequest.getMethodName());
                }
            }
        }
        for (InternalTaskSpec taskSpec : this.testExecutionRequest.getTaskSpecs()) {
            if (!(taskSpec instanceof InternalTestSpec)) continue;
            InternalTestSpec testSpec = (InternalTestSpec)taskSpec;
            Set<AbstractTestTask> tasks = TestExecutionBuildConfigurationAction.queryTestTasks(context, taskSpec.getTaskPath());
            for (AbstractTestTask task : tasks) {
                DefaultTestFilter filter = (DefaultTestFilter)task.getFilter();
                for (String cls : testSpec.getClasses()) {
                    filter.includeCommandLineTest(cls, null);
                }
                for (Map.Entry<String, List<String>> entry : testSpec.getMethods().entrySet()) {
                    String cls = entry.getKey();
                    for (String method : entry.getValue()) {
                        filter.includeCommandLineTest(cls, method);
                    }
                }
                Set<String> commandLineIncludePatterns = filter.getCommandLineIncludePatterns();
                commandLineIncludePatterns.addAll(testSpec.getPatterns());
                for (String pkg : testSpec.getPackages()) {
                    commandLineIncludePatterns.add(pkg + ".*");
                }
            }
        }
    }

    private void configureTestTasksForInternalJvmTestRequest(QueryableExecutionPlan plan) {
        Set<InternalJvmTestRequest> internalJvmTestRequests = this.testExecutionRequest.getInternalJvmTestRequests();
        if (internalJvmTestRequests.isEmpty()) {
            return;
        }
        TestExecutionBuildConfigurationAction.forEachTaskIn(plan, task -> {
            if (task instanceof AbstractTestTask) {
                AbstractTestTask testTask = (AbstractTestTask)task;
                for (InternalJvmTestRequest jvmTestRequest : internalJvmTestRequests) {
                    TestFilter filter = testTask.getFilter();
                    filter.includeTest(jvmTestRequest.getClassName(), jvmTestRequest.getMethodName());
                }
            }
        });
    }

    private void configureTestTasksInBuild(EntryTaskSelector.Context context) {
        Set<InternalTestDescriptor> testDescriptors = this.testExecutionRequest.getTestExecutionDescriptors();
        for (InternalTestDescriptor descriptor : testDescriptors) {
            String testTaskPath = TestExecutionBuildConfigurationAction.taskPathOf(descriptor);
            for (AbstractTestTask testTask : TestExecutionBuildConfigurationAction.queryTestTasks(context, testTaskPath)) {
                for (InternalTestDescriptor testDescriptor : testDescriptors) {
                    if (!TestExecutionBuildConfigurationAction.taskPathOf(testDescriptor).equals(testTaskPath)) continue;
                    TestExecutionBuildConfigurationAction.includeTestMatching((InternalJvmTestDescriptor)testDescriptor, testTask);
                }
            }
        }
    }

    private void collectTasksForTestDescriptors(EntryTaskSelector.Context context, Collection<Task> tasksToRun) {
        Map<String, List<InternalJvmTestRequest>> taskAndTests = this.testExecutionRequest.getTaskAndTests();
        for (Map.Entry<String, List<InternalJvmTestRequest>> entry : taskAndTests.entrySet()) {
            String testTaskPath = entry.getKey();
            tasksToRun.addAll(TestExecutionBuildConfigurationAction.queryTestTasks(context, testTaskPath));
        }
        for (InternalTaskSpec taskSpec : this.testExecutionRequest.getTaskSpecs()) {
            if (taskSpec instanceof InternalTestSpec) {
                tasksToRun.addAll(TestExecutionBuildConfigurationAction.queryTestTasks(context, taskSpec.getTaskPath()));
                continue;
            }
            tasksToRun.addAll(TestExecutionBuildConfigurationAction.queryTasks(context, taskSpec.getTaskPath()));
        }
    }

    private static void includeTestMatching(InternalJvmTestDescriptor descriptor, AbstractTestTask testTask) {
        String className = descriptor.getClassName();
        String methodName = descriptor.getMethodName();
        if (className == null && methodName == null) {
            testTask.getFilter().includeTestsMatching("*");
        } else {
            testTask.getFilter().includeTest(className, methodName);
        }
    }

    private void collectTestTasks(EntryTaskSelector.Context context, Collection<Task> testTasksToRun) {
        for (InternalTestDescriptor descriptor : this.testExecutionRequest.getTestExecutionDescriptors()) {
            String testTaskPath = TestExecutionBuildConfigurationAction.taskPathOf(descriptor);
            testTasksToRun.addAll(TestExecutionBuildConfigurationAction.queryTestTasks(context, testTaskPath));
        }
    }

    private static Set<Task> queryTasks(EntryTaskSelector.Context context, String testTaskPath) {
        TaskSelection taskSelection;
        try {
            taskSelection = context.getSelection(testTaskPath);
        }
        catch (TaskSelectionException e) {
            throw new TestExecutionException(String.format("Requested test task with path '%s' cannot be found.", testTaskPath));
        }
        Set<Task> tasks = taskSelection.getTasks();
        if (tasks.isEmpty()) {
            throw new TestExecutionException(String.format("Requested test task with path '%s' cannot be found.", testTaskPath));
        }
        return tasks;
    }

    private static Set<AbstractTestTask> queryTestTasks(EntryTaskSelector.Context context, String testTaskPath) {
        LinkedHashSet<AbstractTestTask> result2 = new LinkedHashSet<AbstractTestTask>();
        for (Task task : TestExecutionBuildConfigurationAction.queryTasks(context, testTaskPath)) {
            if (!(task instanceof AbstractTestTask)) {
                throw new TestExecutionException(String.format("Task '%s' of type '%s' not supported for executing tests via TestLauncher API.", testTaskPath, task.getClass().getName()));
            }
            result2.add((AbstractTestTask)task);
        }
        return result2;
    }

    private void collectTasksForInternalJvmTestRequest(GradleInternal gradle, Collection<Task> tasksToExecute) {
        Set<InternalJvmTestRequest> internalJvmTestRequests = this.testExecutionRequest.getInternalJvmTestRequests();
        if (internalJvmTestRequests.isEmpty()) {
            return;
        }
        gradle.getOwner().ensureProjectsConfigured();
        for (ProjectState projectState : gradle.getOwner().getProjects().getAllProjects()) {
            projectState.ensureConfigured();
            projectState.applyToMutableState(project -> {
                NamedDomainObjectSet testTasks = project.getTasks().withType(AbstractTestTask.class);
                tasksToExecute.addAll(testTasks);
            });
        }
    }

    private static void forEachTaskIn(QueryableExecutionPlan plan, Consumer<Task> taskConsumer) {
        plan.getTasks().forEach(taskConsumer);
    }

    private static String taskPathOf(InternalTestDescriptor descriptor) {
        return ((DefaultTestDescriptor)descriptor).getTaskPath();
    }
}

