/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.workers.internal;

import org.gradle.internal.operations.BuildOperationContext;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.operations.BuildOperationRef;
import org.gradle.internal.operations.CallableBuildOperation;
import org.gradle.workers.internal.BuildOperationAwareWorker;
import org.gradle.workers.internal.DefaultWorkResult;
import org.gradle.workers.internal.ExecuteWorkItemBuildOperationType;
import org.gradle.workers.internal.IsolatedParametersActionExecutionSpec;

public abstract class AbstractWorker
implements BuildOperationAwareWorker {
    public static final Result RESULT = new Result();
    private final BuildOperationExecutor buildOperationExecutor;

    AbstractWorker(BuildOperationExecutor buildOperationExecutor) {
        this.buildOperationExecutor = buildOperationExecutor;
    }

    @Override
    public DefaultWorkResult execute(IsolatedParametersActionExecutionSpec<?> spec) {
        return this.execute(spec, this.buildOperationExecutor.getCurrentOperation());
    }

    DefaultWorkResult executeWrappedInBuildOperation(final IsolatedParametersActionExecutionSpec<?> spec, final BuildOperationRef parentBuildOperation, final Work work) {
        return this.buildOperationExecutor.call(new CallableBuildOperation<DefaultWorkResult>(){

            @Override
            public DefaultWorkResult call(BuildOperationContext context) {
                DefaultWorkResult result2 = work.execute(spec);
                context.setResult(RESULT);
                context.failed(result2.getException());
                return result2;
            }

            @Override
            public BuildOperationDescriptor.Builder description() {
                return BuildOperationDescriptor.displayName(spec.getDisplayName()).parent(parentBuildOperation).details(new Details(spec.getActionImplementationClassName(), spec.getDisplayName()));
            }
        });
    }

    static class Result
    implements ExecuteWorkItemBuildOperationType.Result {
        Result() {
        }
    }

    static class Details
    implements ExecuteWorkItemBuildOperationType.Details {
        private final String className;
        private final String displayName;

        public Details(String className, String displayName) {
            this.className = className;
            this.displayName = displayName;
        }

        @Override
        public String getClassName() {
            return this.className;
        }

        @Override
        public String getDisplayName() {
            return this.displayName;
        }
    }

    static interface Work {
        public DefaultWorkResult execute(IsolatedParametersActionExecutionSpec<?> var1);
    }
}

