/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.apache.ivy.util.url;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.ProxySelector;
import java.net.URL;
import java.nio.charset.Charset;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.ConcurrentHashMap;
import org.gradle.internal.impldep.org.apache.http.Header;
import org.gradle.internal.impldep.org.apache.http.HttpEntity;
import org.gradle.internal.impldep.org.apache.http.HttpResponse;
import org.gradle.internal.impldep.org.apache.http.auth.AuthSchemeProvider;
import org.gradle.internal.impldep.org.apache.http.auth.AuthScope;
import org.gradle.internal.impldep.org.apache.http.auth.NTCredentials;
import org.gradle.internal.impldep.org.apache.http.client.CredentialsProvider;
import org.gradle.internal.impldep.org.apache.http.client.config.RequestConfig;
import org.gradle.internal.impldep.org.apache.http.client.methods.CloseableHttpResponse;
import org.gradle.internal.impldep.org.apache.http.client.methods.HttpGet;
import org.gradle.internal.impldep.org.apache.http.client.methods.HttpHead;
import org.gradle.internal.impldep.org.apache.http.client.methods.HttpPut;
import org.gradle.internal.impldep.org.apache.http.config.Lookup;
import org.gradle.internal.impldep.org.apache.http.config.RegistryBuilder;
import org.gradle.internal.impldep.org.apache.http.conn.HttpClientConnectionManager;
import org.gradle.internal.impldep.org.apache.http.conn.routing.HttpRoutePlanner;
import org.gradle.internal.impldep.org.apache.http.entity.ContentType;
import org.gradle.internal.impldep.org.apache.http.entity.FileEntity;
import org.gradle.internal.impldep.org.apache.http.impl.auth.BasicSchemeFactory;
import org.gradle.internal.impldep.org.apache.http.impl.auth.DigestSchemeFactory;
import org.gradle.internal.impldep.org.apache.http.impl.auth.NTLMSchemeFactory;
import org.gradle.internal.impldep.org.apache.http.impl.client.CloseableHttpClient;
import org.gradle.internal.impldep.org.apache.http.impl.client.HttpClients;
import org.gradle.internal.impldep.org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.gradle.internal.impldep.org.apache.http.impl.conn.SystemDefaultRoutePlanner;
import org.gradle.internal.impldep.org.apache.ivy.core.settings.TimeoutConstraint;
import org.gradle.internal.impldep.org.apache.ivy.util.CopyProgressListener;
import org.gradle.internal.impldep.org.apache.ivy.util.Credentials;
import org.gradle.internal.impldep.org.apache.ivy.util.FileUtil;
import org.gradle.internal.impldep.org.apache.ivy.util.HostUtil;
import org.gradle.internal.impldep.org.apache.ivy.util.Message;
import org.gradle.internal.impldep.org.apache.ivy.util.url.AbstractURLHandler;
import org.gradle.internal.impldep.org.apache.ivy.util.url.CredentialsStore;
import org.gradle.internal.impldep.org.apache.ivy.util.url.TimeoutConstrainedURLHandler;
import org.gradle.internal.impldep.org.apache.ivy.util.url.URLHandler;

public class HttpClientHandler
extends AbstractURLHandler
implements TimeoutConstrainedURLHandler,
AutoCloseable {
    private static final SimpleDateFormat LAST_MODIFIED_FORMAT = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss z", Locale.US);
    static final HttpClientHandler DELETE_ON_EXIT_INSTANCE = new HttpClientHandler();
    private final CloseableHttpClient httpClient = this.buildUnderlyingClient();

    private CloseableHttpClient buildUnderlyingClient() {
        return HttpClients.custom().setConnectionManager(HttpClientHandler.createConnectionManager()).setRoutePlanner(HttpClientHandler.createProxyRoutePlanner()).setUserAgent(this.getUserAgent()).setDefaultAuthSchemeRegistry(HttpClientHandler.createAuthSchemeRegistry()).setDefaultCredentialsProvider(new IvyCredentialsProvider()).build();
    }

    private static HttpRoutePlanner createProxyRoutePlanner() {
        Message.verbose("Using JRE standard ProxySelector for configuring HTTP proxy");
        return new SystemDefaultRoutePlanner(ProxySelector.getDefault());
    }

    private static Lookup<AuthSchemeProvider> createAuthSchemeRegistry() {
        return RegistryBuilder.create().register("Digest", new DigestSchemeFactory()).register("Basic", (DigestSchemeFactory)((Object)new BasicSchemeFactory())).register("NTLM", (DigestSchemeFactory)((Object)new NTLMSchemeFactory())).build();
    }

    private static HttpClientConnectionManager createConnectionManager() {
        return new PoolingHttpClientConnectionManager();
    }

    private static List<String> getAuthSchemePreferredOrder() {
        return Arrays.asList("Digest", "Basic", "NTLM");
    }

    @Override
    public InputStream openStream(URL url) throws IOException {
        return this.openStream(url, null);
    }

    @Override
    public InputStream openStream(URL url, TimeoutConstraint timeoutConstraint) throws IOException {
        int connectionTimeout = timeoutConstraint == null || timeoutConstraint.getConnectionTimeout() < 0 ? 0 : timeoutConstraint.getConnectionTimeout();
        int readTimeout = timeoutConstraint == null || timeoutConstraint.getReadTimeout() < 0 ? 0 : timeoutConstraint.getReadTimeout();
        CloseableHttpResponse response = this.doGet(url, connectionTimeout, readTimeout);
        this.requireSuccessStatus("GET", url, response);
        Header encoding = this.getContentEncoding(response);
        return this.getDecodingInputStream(encoding == null ? null : encoding.getValue(), response.getEntity().getContent());
    }

    @Override
    public void download(URL src, File dest, CopyProgressListener l) throws IOException {
        this.download(src, dest, l, null);
    }

    @Override
    public void download(URL src, File dest, CopyProgressListener listener, TimeoutConstraint timeoutConstraint) throws IOException {
        int connectionTimeout = timeoutConstraint == null || timeoutConstraint.getConnectionTimeout() < 0 ? 0 : timeoutConstraint.getConnectionTimeout();
        int readTimeout = timeoutConstraint == null || timeoutConstraint.getReadTimeout() < 0 ? 0 : timeoutConstraint.getReadTimeout();
        try (CloseableHttpResponse response = this.doGet(src, connectionTimeout, readTimeout);){
            this.requireSuccessStatus("GET", src, response);
            Header encoding = this.getContentEncoding(response);
            try (InputStream is = this.getDecodingInputStream(encoding == null ? null : encoding.getValue(), response.getEntity().getContent());){
                FileUtil.copy(is, dest, listener);
            }
            dest.setLastModified(this.getLastModified(response));
        }
    }

    @Override
    public void upload(File src, URL dest, CopyProgressListener l) throws IOException {
        this.upload(src, dest, l, null);
    }

    @Override
    public void upload(File src, URL dest, CopyProgressListener listener, TimeoutConstraint timeoutConstraint) throws IOException {
        int connectionTimeout = timeoutConstraint == null || timeoutConstraint.getConnectionTimeout() < 0 ? 0 : timeoutConstraint.getConnectionTimeout();
        int readTimeout = timeoutConstraint == null || timeoutConstraint.getReadTimeout() < 0 ? 0 : timeoutConstraint.getReadTimeout();
        RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(readTimeout).setConnectTimeout(connectionTimeout).setAuthenticationEnabled(this.hasCredentialsConfigured(dest)).setTargetPreferredAuthSchemes(HttpClientHandler.getAuthSchemePreferredOrder()).setProxyPreferredAuthSchemes(HttpClientHandler.getAuthSchemePreferredOrder()).setExpectContinueEnabled(true).build();
        HttpPut put = new HttpPut(this.normalizeToString(dest));
        put.setConfig(requestConfig);
        put.setEntity(new FileEntity(src));
        try (CloseableHttpResponse response = this.httpClient.execute(put);){
            this.validatePutStatusCode(dest, response.getStatusLine().getStatusCode(), response.getStatusLine().getReasonPhrase());
        }
    }

    @Override
    public URLHandler.URLInfo getURLInfo(URL url) {
        return this.getURLInfo(url, null);
    }

    @Override
    public URLHandler.URLInfo getURLInfo(URL url, int timeout) {
        return this.getURLInfo(url, HttpClientHandler.createTimeoutConstraints(timeout));
    }

    @Override
    public boolean isReachable(URL url, TimeoutConstraint timeoutConstraint) {
        return this.getURLInfo(url, timeoutConstraint).isReachable();
    }

    @Override
    public long getContentLength(URL url, TimeoutConstraint timeoutConstraint) {
        return this.getURLInfo(url, timeoutConstraint).getContentLength();
    }

    @Override
    public long getLastModified(URL url, TimeoutConstraint timeoutConstraint) {
        return this.getURLInfo(url, timeoutConstraint).getLastModified();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public URLHandler.URLInfo getURLInfo(URL url, TimeoutConstraint timeoutConstraint) {
        int connectionTimeout = timeoutConstraint == null || timeoutConstraint.getConnectionTimeout() < 0 ? 0 : timeoutConstraint.getConnectionTimeout();
        int readTimeout = timeoutConstraint == null || timeoutConstraint.getReadTimeout() < 0 ? 0 : timeoutConstraint.getReadTimeout();
        Closeable response = null;
        try {
            String httpMethod;
            if (this.getRequestMethod() == 2) {
                httpMethod = "HEAD";
                response = this.doHead(url, connectionTimeout, readTimeout);
            } else {
                httpMethod = "GET";
                response = this.doGet(url, connectionTimeout, readTimeout);
            }
            if (this.checkStatusCode(httpMethod, url, (HttpResponse)((Object)response))) {
                HttpEntity responseEntity = response.getEntity();
                Charset charSet = ContentType.getOrDefault(responseEntity).getCharset();
                String charSetName = charSet != null ? charSet.name() : null;
                URLHandler.URLInfo uRLInfo = new URLHandler.URLInfo(true, responseEntity == null ? 0L : responseEntity.getContentLength(), this.getLastModified((HttpResponse)((Object)response)), charSetName);
                return uRLInfo;
            }
        }
        catch (IOException | IllegalArgumentException e) {
            Message.error("HttpClientHandler: " + e.getMessage() + " url=" + url);
        }
        finally {
            if (response != null) {
                try {
                    response.close();
                }
                catch (IOException iOException) {}
            }
        }
        return UNAVAILABLE;
    }

    private boolean checkStatusCode(String httpMethod, URL sourceURL, HttpResponse response) {
        int status = response.getStatusLine().getStatusCode();
        if (status == 200) {
            return true;
        }
        if ("HEAD".equals(httpMethod) && status == 204) {
            return true;
        }
        Message.debug("HTTP response status: " + status + " url=" + sourceURL);
        if (status == 407) {
            Message.warn("Your proxy requires authentication.");
        } else if (String.valueOf(status).startsWith("4")) {
            Message.verbose("CLIENT ERROR: " + response.getStatusLine().getReasonPhrase() + " url=" + sourceURL);
        } else if (String.valueOf(status).startsWith("5")) {
            Message.error("SERVER ERROR: " + response.getStatusLine().getReasonPhrase() + " url=" + sourceURL);
        }
        return false;
    }

    private void requireSuccessStatus(String httpMethod, URL sourceURL, CloseableHttpResponse response) throws IOException {
        if (this.checkStatusCode(httpMethod, sourceURL, response)) {
            return;
        }
        try {
            response.close();
        }
        catch (Exception e) {
            Message.debug("Could not close the HTTP response for url=" + sourceURL, e);
        }
        throw new IOException("Failed response to request '" + httpMethod + " " + sourceURL + "' " + response.getStatusLine().getStatusCode() + " - '" + response.getStatusLine().getReasonPhrase());
    }

    private Header getContentEncoding(HttpResponse response) {
        return response.getFirstHeader("Content-Encoding");
    }

    private long getLastModified(HttpResponse response) {
        Header header = response.getFirstHeader("last-modified");
        if (header == null) {
            return System.currentTimeMillis();
        }
        String lastModified = header.getValue();
        try {
            return LAST_MODIFIED_FORMAT.parse(lastModified).getTime();
        }
        catch (ParseException parseException) {
            return System.currentTimeMillis();
        }
    }

    private CloseableHttpResponse doGet(URL url, int connectionTimeout, int readTimeout) throws IOException {
        RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(readTimeout).setConnectTimeout(connectionTimeout).setAuthenticationEnabled(this.hasCredentialsConfigured(url)).setTargetPreferredAuthSchemes(HttpClientHandler.getAuthSchemePreferredOrder()).setProxyPreferredAuthSchemes(HttpClientHandler.getAuthSchemePreferredOrder()).build();
        HttpGet httpGet = new HttpGet(this.normalizeToString(url));
        httpGet.setConfig(requestConfig);
        httpGet.addHeader("Accept-Encoding", "gzip,deflate");
        return this.httpClient.execute(httpGet);
    }

    private CloseableHttpResponse doHead(URL url, int connectionTimeout, int readTimeout) throws IOException {
        RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(readTimeout).setConnectTimeout(connectionTimeout).setAuthenticationEnabled(this.hasCredentialsConfigured(url)).setTargetPreferredAuthSchemes(HttpClientHandler.getAuthSchemePreferredOrder()).setProxyPreferredAuthSchemes(HttpClientHandler.getAuthSchemePreferredOrder()).build();
        HttpHead httpHead = new HttpHead(this.normalizeToString(url));
        httpHead.setConfig(requestConfig);
        return this.httpClient.execute(httpHead);
    }

    private boolean hasCredentialsConfigured(URL url) {
        return CredentialsStore.INSTANCE.hasCredentials(url.getHost());
    }

    @Override
    public void close() throws Exception {
        if (this.httpClient != null) {
            this.httpClient.close();
        }
    }

    static {
        Thread shutdownHook = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    DELETE_ON_EXIT_INSTANCE.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        shutdownHook.setName("ivy-httpclient-shutdown-handler");
        shutdownHook.setDaemon(true);
        Runtime.getRuntime().addShutdownHook(shutdownHook);
    }

    private static class IvyCredentialsProvider
    implements CredentialsProvider {
        private final ConcurrentHashMap<AuthScope, org.gradle.internal.impldep.org.apache.http.auth.Credentials> cachedCreds = new ConcurrentHashMap();

        private IvyCredentialsProvider() {
        }

        @Override
        public void setCredentials(AuthScope authscope, org.gradle.internal.impldep.org.apache.http.auth.Credentials credentials) {
            if (authscope == null) {
                throw new IllegalArgumentException("AuthScope cannot be null");
            }
            this.cachedCreds.put(authscope, credentials);
        }

        @Override
        public org.gradle.internal.impldep.org.apache.http.auth.Credentials getCredentials(AuthScope authscope) {
            String host;
            if (authscope == null) {
                return null;
            }
            String realm = authscope.getRealm();
            Credentials ivyConfiguredCred = CredentialsStore.INSTANCE.getCredentials(realm, host = authscope.getHost());
            if (ivyConfiguredCred == null) {
                return null;
            }
            return IvyCredentialsProvider.createCredentials(ivyConfiguredCred.getUserName(), ivyConfiguredCred.getPasswd());
        }

        @Override
        public void clear() {
            this.cachedCreds.clear();
        }

        private static org.gradle.internal.impldep.org.apache.http.auth.Credentials createCredentials(String username, String password) {
            String domain;
            String user;
            int backslashIndex = username.indexOf(92);
            if (backslashIndex >= 0) {
                user = username.substring(backslashIndex + 1);
                domain = username.substring(0, backslashIndex);
            } else {
                user = username;
                domain = System.getProperty("http.auth.ntlm.domain", "");
            }
            return new NTCredentials(user, password, HostUtil.getLocalHostName(), domain);
        }
    }
}

