/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.qodana.sarif.model;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class PropertyBag
implements Map<String, Object> {
    public static final String TAGS_KEY = "tags";
    private final Map<String, Object> properties = new HashMap<String, Object>();
    private final Set<String> tags = new LinkedHashSet<String>();

    public Set<String> getTags() {
        return this.tags;
    }

    @Override
    public int size() {
        return this.properties.size();
    }

    @Override
    public boolean isEmpty() {
        return this.properties.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.properties.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.properties.containsValue(value);
    }

    @Override
    public Object get(Object key) {
        if (TAGS_KEY.equals(key)) {
            throw new IllegalArgumentException("tags is a reserved key");
        }
        return this.properties.get(key);
    }

    @Override
    public Object put(String key, Object value) {
        if (TAGS_KEY.equals(key)) {
            throw new IllegalArgumentException("tags is a reserved key");
        }
        return this.properties.put(key, value);
    }

    @Override
    public Object remove(Object key) {
        if (TAGS_KEY.equals(key)) {
            throw new IllegalArgumentException("tags is a reserved key");
        }
        return this.properties.remove(key);
    }

    @Override
    public void putAll(Map<? extends String, ?> m) {
        if (m.containsKey(TAGS_KEY)) {
            throw new IllegalArgumentException("tags is a reserved key");
        }
        this.properties.putAll(m);
    }

    @Override
    public void clear() {
        this.properties.clear();
    }

    @Override
    public Set<String> keySet() {
        return this.properties.keySet();
    }

    @Override
    public Collection<Object> values() {
        return this.properties.values();
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return this.properties.entrySet();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PropertyBag that = (PropertyBag)o;
        return Objects.equals(this.properties, that.properties) && Objects.equals(this.tags, that.tags);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.properties, this.tags);
    }

    public static class PropertyBagTypeAdapter
    extends TypeAdapter<PropertyBag> {
        private static final Gson embedded = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();

        public void write(JsonWriter out, PropertyBag bag) {
            HashMap<String, Object> toSerialize = new HashMap<String, Object>(bag);
            if (!bag.tags.isEmpty()) {
                toSerialize.put(PropertyBag.TAGS_KEY, bag.getTags());
            }
            embedded.toJson(toSerialize, Map.class, out);
        }

        public PropertyBag read(JsonReader reader) {
            PropertyBag result = new PropertyBag();
            Map map = (Map)embedded.fromJson(reader, Map.class);
            Object tags = map.remove(PropertyBag.TAGS_KEY);
            result.putAll(map);
            if (tags instanceof List) {
                result.tags.addAll((Collection)tags);
            }
            return result;
        }
    }
}

