/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.hash4j.distinctcount;

import com.dynatrace.hash4j.distinctcount.DistinctCountUtil;
import com.dynatrace.hash4j.distinctcount.DistinctCounter;
import com.dynatrace.hash4j.distinctcount.StateChangeObserver;
import com.dynatrace.hash4j.distinctcount.UltraLogLog;
import com.dynatrace.hash4j.util.PackedArray;
import java.util.Arrays;
import java.util.Objects;

public final class HyperLogLog
implements DistinctCounter<HyperLogLog, Estimator> {
    public static final Estimator CORRECTED_RAW_ESTIMATOR = new CorrectedRawEstimator();
    public static final Estimator MAXIMUM_LIKELIHOOD_ESTIMATOR = new MaximumLikelihoodEstimator();
    public static final Estimator DEFAULT_ESTIMATOR = CORRECTED_RAW_ESTIMATOR;
    private static final PackedArray.PackedArrayHandler ARRAY_HANDLER = PackedArray.getHandler(6);
    private static final int MIN_P = 3;
    private static final int MAX_P = 26;
    private static final int MIN_STATE_SIZE = ARRAY_HANDLER.numBytes(8);
    private static final int MAX_STATE_SIZE = ARRAY_HANDLER.numBytes(0x4000000);
    private final int p;
    private final byte[] state;

    private static double powHalf(int x) {
        return Double.longBitsToDouble(1023L - (long)x << 52);
    }

    private HyperLogLog(int p) {
        this.state = ARRAY_HANDLER.create(1 << p);
        this.p = p;
    }

    private HyperLogLog(byte[] state) {
        this.state = state;
        this.p = HyperLogLog.calculateP(state.length);
    }

    private HyperLogLog(byte[] state, int p) {
        this.state = state;
        this.p = p;
    }

    public static HyperLogLog create(int p) {
        DistinctCountUtil.checkPrecisionParameter(p, 3, 26);
        return new HyperLogLog(p);
    }

    public static HyperLogLog create(UltraLogLog ullSketch) {
        int p = ullSketch.getP();
        DistinctCountUtil.checkPrecisionParameter(p, 3, 26);
        byte[] ullState = ullSketch.getState();
        return new HyperLogLog(ARRAY_HANDLER.create(i -> Math.max(0, ((ullState[i] & 0xFF) >>> 2) + 2 - p), 1 << p), p);
    }

    public static HyperLogLog wrap(byte[] state) {
        Objects.requireNonNull(state, "null argument");
        if (state.length > MAX_STATE_SIZE || state.length < MIN_STATE_SIZE || !DistinctCountUtil.isUnsignedPowerOfTwo(HyperLogLog.mul4DivideBy3(state.length))) {
            throw new IllegalArgumentException("illegal array length");
        }
        return new HyperLogLog(state);
    }

    private static int mul4DivideBy3(int x) {
        return (int)(0x2AAAAAAACL * (long)x >> 33);
    }

    @Override
    public HyperLogLog copy() {
        return new HyperLogLog(Arrays.copyOf(this.state, this.state.length), this.p);
    }

    @Override
    public HyperLogLog downsize(int p) {
        DistinctCountUtil.checkPrecisionParameter(p, 3, 26);
        if (p >= this.p) {
            return this.copy();
        }
        return new HyperLogLog(p).add(this);
    }

    public static HyperLogLog merge(HyperLogLog sketch1, HyperLogLog sketch2) {
        Objects.requireNonNull(sketch1, "first sketch was null");
        Objects.requireNonNull(sketch2, "second sketch was null");
        if (sketch1.p <= sketch2.p) {
            return sketch1.copy().add(sketch2);
        }
        return sketch2.copy().add(sketch1);
    }

    @Override
    public byte[] getState() {
        return this.state;
    }

    @Override
    public int getP() {
        return this.p;
    }

    static int calculateP(int stateLength) {
        return 30 - Long.numberOfLeadingZeros(0x2AAAAAAACL * (long)stateLength);
    }

    @Override
    public HyperLogLog add(long hashValue) {
        this.add(hashValue, null);
        return this;
    }

    @Override
    public HyperLogLog addToken(int token) {
        return this.add(DistinctCounter.reconstructHash(token));
    }

    public static int computeToken(long hashValue) {
        return DistinctCounter.computeToken(hashValue);
    }

    @Override
    public HyperLogLog add(long hashValue, StateChangeObserver stateChangeObserver) {
        int idx = (int)(hashValue >>> -this.p);
        int newValue = Long.numberOfLeadingZeros((hashValue ^ 0xFFFFFFFFFFFFFFFFL) << this.p ^ 0xFFFFFFFFFFFFFFFFL) + 1;
        int oldValue = (int)ARRAY_HANDLER.update(this.state, idx, newValue, Math::max);
        if (stateChangeObserver != null && newValue > oldValue) {
            double stateChangeProbabilityDecrement = this.getRegisterChangeProbability(oldValue) - this.getRegisterChangeProbability(newValue);
            stateChangeObserver.stateChanged(stateChangeProbabilityDecrement);
        }
        return this;
    }

    @Override
    public HyperLogLog addToken(int token, StateChangeObserver stateChangeObserver) {
        return this.add(DistinctCounter.reconstructHash(token), stateChangeObserver);
    }

    private double getRegisterChangeProbability(int registerValue) {
        int r = registerValue + this.p;
        if (r <= 64) {
            return HyperLogLog.powHalf(r);
        }
        return 0.0;
    }

    @Override
    public HyperLogLog add(HyperLogLog other) {
        Objects.requireNonNull(other, "null argument");
        byte[] otherData = other.state;
        if (other.p < this.p) {
            throw new IllegalArgumentException("other has smaller precision");
        }
        int deltaP = other.p - this.p;
        int j = 0;
        for (int i = 0; i < 1 << this.p; ++i) {
            int oldR;
            int r = oldR = (int)ARRAY_HANDLER.get(this.state, i);
            int otherR = (int)ARRAY_HANDLER.get(otherData, j);
            if (otherR != 0 && (otherR += deltaP) > r) {
                r = otherR;
            }
            ++j;
            for (long k = 1L; k < 1L << deltaP; ++k) {
                int nlz = Long.numberOfLeadingZeros(k) - 64 + deltaP;
                if (nlz >= r && ARRAY_HANDLER.get(otherData, j) != 0L) {
                    r = nlz + 1;
                }
                ++j;
            }
            if (oldR >= r) continue;
            ARRAY_HANDLER.set(this.state, i, r);
        }
        return this;
    }

    @Override
    public double getDistinctCountEstimate() {
        return DEFAULT_ESTIMATOR.estimate(this);
    }

    @Override
    public double getDistinctCountEstimate(Estimator estimator) {
        return estimator.estimate(this);
    }

    @Override
    public double getStateChangeProbability() {
        double sum = 0.0;
        int off = 0;
        while (off + 2 < this.state.length) {
            byte s0 = this.state[off];
            byte s1 = this.state[off + 1];
            byte s2 = this.state[off + 2];
            int r0 = s0 & 0x3F;
            int r1 = (s0 >>> 6 & 3 | s1 << 2) & 0x3F;
            int r2 = (s1 >>> 4 & 0xF | s2 << 4) & 0x3F;
            int r3 = s2 >>> 2 & 0x3F;
            sum += this.getRegisterChangeProbability(r0);
            sum += this.getRegisterChangeProbability(r1);
            sum += this.getRegisterChangeProbability(r2);
            sum += this.getRegisterChangeProbability(r3);
            off += 3;
        }
        return sum;
    }

    @Override
    public HyperLogLog reset() {
        ARRAY_HANDLER.clear(this.state);
        return this;
    }

    private static double unsignedLongToDouble(long l) {
        double d = l & Long.MAX_VALUE;
        if (l < 0L) {
            d += 9.223372036854776E18;
        }
        return d;
    }

    private static final class MaximumLikelihoodEstimator
    implements Estimator {
        private static final double INV_SQRT_FISHER_INFORMATION = 1.0367047097785012;
        private static final double ML_EQUATION_SOLVER_EPS = 0.0010367047097785012;
        private static final double ML_BIAS_CORRECTION_CONSTANT = 1.01015908095854;

        private MaximumLikelihoodEstimator() {
        }

        @Override
        public double estimate(HyperLogLog hyperLogLog) {
            byte[] state = hyperLogLog.state;
            int p = hyperLogLog.p;
            long agg = 0L;
            int[] c = new int[66 - p];
            long inc = 1L << -hyperLogLog.p;
            int off = 0;
            while (off + 2 < state.length) {
                byte s0 = state[off];
                byte s1 = state[off + 1];
                byte s2 = state[off + 2];
                int r0 = s0 & 0x3F;
                int r1 = (s0 >>> 6 & 3 | s1 << 2) & 0x3F;
                int r2 = (s1 >>> 4 & 0xF | s2 << 4) & 0x3F;
                int r3 = s2 >>> 2 & 0x3F;
                agg += inc >>> r0;
                agg += inc >>> r1;
                agg += inc >>> r2;
                agg += inc >>> r3;
                if (r0 < c.length) {
                    int n = r0;
                    c[n] = c[n] + 1;
                }
                if (r1 < c.length) {
                    int n = r1;
                    c[n] = c[n] + 1;
                }
                if (r2 < c.length) {
                    int n = r2;
                    c[n] = c[n] + 1;
                }
                if (r3 < c.length) {
                    int n = r3;
                    c[n] = c[n] + 1;
                }
                off += 3;
            }
            int m = 1 << p;
            if (c[0] == m) {
                return 0.0;
            }
            c[0] = 0;
            int n = c.length - 2;
            c[n] = c[n] + c[c.length - 1];
            c[c.length - 1] = 0;
            double a = HyperLogLog.unsignedLongToDouble(agg) / (double)inc;
            return (double)m * DistinctCountUtil.solveMaximumLikelihoodEquation(a, c, 0.0010367047097785012 / Math.sqrt(m)) / (1.0 + 1.01015908095854 / (double)m);
        }
    }

    static final class CorrectedRawEstimator
    implements Estimator {
        private static final double ONE_THIRD = 0.3333333333333333;
        static final double[] ESTIMATION_FACTORS = new double[]{40.67760431873907, 172.99391414703106, 714.5560640781132, 2905.6322537477818, 11719.723738552972, 47075.733045730056, 188699.0930713932, 755591.1970832772, 3023956.9501793, 1.2099014641293615E7, 4.8402434765532516E7, 1.9362249398321322E8, 7.745154882959671E8, 3.098112980431337E9, 1.2392553978741665E10, 4.9570420031520744E10, 1.982820883617127E11, 7.931291699206317E11, 3.1725183126326094E12, 1.2690076516433127E13, 5.076031259754041E13, 2.0304126345377997E14, 8.12165079942359E14, 3.248660372023916E15};

        private CorrectedRawEstimator() {
        }

        static double sigma(double x) {
            double oldSum;
            if (x <= 0.0) {
                return 0.0;
            }
            if (x >= 1.0) {
                return Double.POSITIVE_INFINITY;
            }
            double z = 1.0;
            double sum = 0.0;
            while ((oldSum = sum) < (sum += (x *= x) * (z += z))) {
            }
            return sum;
        }

        static double tau(double x) {
            double oneMinusX;
            double zPrime;
            if (x <= 0.0 || x >= 1.0) {
                return 0.0;
            }
            double y = 1.0;
            double z = 1.0 - x;
            while ((zPrime = z) > (z -= (oneMinusX = 1.0 - (x = Math.sqrt(x))) * oneMinusX * (y *= 0.5))) {
            }
            return z * 0.3333333333333333;
        }

        @Override
        public double estimate(HyperLogLog hyperLogLog) {
            byte[] state = hyperLogLog.state;
            int c0 = 0;
            int cMax = 0;
            long agg = 0L;
            int maxR = 65 - hyperLogLog.p;
            long inc = 1L << -hyperLogLog.p;
            int off = 0;
            while (off + 2 < state.length) {
                byte s0 = state[off];
                byte s1 = state[off + 1];
                byte s2 = state[off + 2];
                int r0 = s0 & 0x3F;
                int r1 = (s0 >>> 6 & 3 | s1 << 2) & 0x3F;
                int r2 = (s1 >>> 4 & 0xF | s2 << 4) & 0x3F;
                int r3 = s2 >>> 2 & 0x3F;
                agg += inc >>> r0;
                agg += inc >>> r1;
                agg += inc >>> r2;
                agg += inc >>> r3;
                if (r0 >= maxR) {
                    ++cMax;
                }
                if (r1 >= maxR) {
                    ++cMax;
                }
                if (r2 >= maxR) {
                    ++cMax;
                }
                if (r3 >= maxR) {
                    ++cMax;
                }
                if (r0 == 0) {
                    ++c0;
                }
                if (r1 == 0) {
                    ++c0;
                }
                if (r2 == 0) {
                    ++c0;
                }
                if (r3 == 0) {
                    ++c0;
                }
                off += 3;
            }
            double sum = 0.0;
            if (cMax > 0) {
                double m = 1 << hyperLogLog.p;
                sum += Double.longBitsToDouble(0x3FF0000000000000L - (32L - (long)hyperLogLog.p << 53)) * CorrectedRawEstimator.tau(1.0 - (double)cMax / m);
            }
            sum += HyperLogLog.unsignedLongToDouble(agg) / (double)inc;
            if (c0 > 0) {
                double m = 1 << hyperLogLog.p;
                sum += m * CorrectedRawEstimator.sigma((double)c0 / m);
            }
            return ESTIMATION_FACTORS[hyperLogLog.p - 3] / sum;
        }
    }

    public static interface Estimator
    extends DistinctCounter.Estimator<HyperLogLog> {
    }
}

