/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.hash4j.distinctcount;

import com.dynatrace.hash4j.distinctcount.DistinctCountUtil;
import com.dynatrace.hash4j.distinctcount.DistinctCounter;
import com.dynatrace.hash4j.distinctcount.StateChangeObserver;
import java.util.Arrays;
import java.util.Objects;

public final class UltraLogLog
implements DistinctCounter<UltraLogLog, Estimator> {
    public static final Estimator MAXIMUM_LIKELIHOOD_ESTIMATOR = new MaximumLikelihoodEstimator();
    public static final Estimator OPTIMAL_FGRA_ESTIMATOR;
    public static final Estimator DEFAULT_ESTIMATOR;
    private static final int MIN_P = 3;
    private static final int MAX_P = 26;
    private static final int MIN_STATE_SIZE = 8;
    private static final int MAX_STATE_SIZE = 0x4000000;
    private final byte[] state;

    private UltraLogLog(int p) {
        this.state = new byte[1 << p];
    }

    private UltraLogLog(byte[] state) {
        this.state = state;
    }

    public static UltraLogLog create(int p) {
        DistinctCountUtil.checkPrecisionParameter(p, 3, 26);
        return new UltraLogLog(p);
    }

    public static UltraLogLog wrap(byte[] state) {
        Objects.requireNonNull(state, "null argument");
        if (state.length > 0x4000000 || state.length < 8 || !DistinctCountUtil.isUnsignedPowerOfTwo(state.length)) {
            throw new IllegalArgumentException("illegal array length");
        }
        return new UltraLogLog(state);
    }

    @Override
    public UltraLogLog copy() {
        return new UltraLogLog(Arrays.copyOf(this.state, this.state.length));
    }

    @Override
    public UltraLogLog downsize(int p) {
        DistinctCountUtil.checkPrecisionParameter(p, 3, 26);
        if (1 << p >= this.state.length) {
            return this.copy();
        }
        return new UltraLogLog(p).add(this);
    }

    public static UltraLogLog merge(UltraLogLog sketch1, UltraLogLog sketch2) {
        Objects.requireNonNull(sketch1, "first sketch was null");
        Objects.requireNonNull(sketch2, "second sketch was null");
        if (sketch1.state.length <= sketch2.state.length) {
            return sketch1.copy().add(sketch2);
        }
        return sketch2.copy().add(sketch1);
    }

    @Override
    public byte[] getState() {
        return this.state;
    }

    @Override
    public int getP() {
        return 31 - Integer.numberOfLeadingZeros(this.state.length);
    }

    @Override
    public UltraLogLog add(long hashValue) {
        this.add(hashValue, null);
        return this;
    }

    @Override
    public UltraLogLog addToken(int token) {
        return this.add(DistinctCounter.reconstructHash(token));
    }

    public static int computeToken(long hashValue) {
        return DistinctCounter.computeToken(hashValue);
    }

    @Override
    public UltraLogLog add(long hashValue, StateChangeObserver stateChangeObserver) {
        byte newState;
        int q = Long.numberOfLeadingZeros((long)this.state.length - 1L);
        int idx = (int)(hashValue >>> q);
        int nlz = Long.numberOfLeadingZeros((hashValue ^ 0xFFFFFFFFFFFFFFFFL) << -q ^ 0xFFFFFFFFFFFFFFFFL);
        byte oldState = this.state[idx];
        long hashPrefix = UltraLogLog.unpack(oldState);
        this.state[idx] = newState = UltraLogLog.pack(hashPrefix |= 1L << nlz + ~q);
        if (stateChangeObserver != null && newState != oldState) {
            int p = 64 - q;
            stateChangeObserver.stateChanged(UltraLogLog.getRegisterChangeProbability(oldState, p) - UltraLogLog.getRegisterChangeProbability(newState, p));
        }
        return this;
    }

    @Override
    public UltraLogLog addToken(int token, StateChangeObserver stateChangeObserver) {
        return this.add(DistinctCounter.reconstructHash(token), stateChangeObserver);
    }

    @Override
    public UltraLogLog add(UltraLogLog other) {
        Objects.requireNonNull(other, "null argument");
        byte[] otherData = other.state;
        if (otherData.length < this.state.length) {
            throw new IllegalArgumentException("other has smaller precision");
        }
        int p = this.getP();
        int otherP = other.getP();
        int deltaP = otherP - p;
        int j = 0;
        for (int i = 0; i < this.state.length; ++i) {
            long hashPrefix = UltraLogLog.unpack(this.state[i]) | UltraLogLog.unpack(otherData[j]);
            ++j;
            for (long k = 1L; k < 1L << deltaP; ++k) {
                if (otherData[j] != 0) {
                    hashPrefix |= 1L << Long.numberOfLeadingZeros(k) + otherP - 1;
                }
                ++j;
            }
            if (hashPrefix == 0L) continue;
            this.state[i] = UltraLogLog.pack(hashPrefix);
        }
        return this;
    }

    static long unpack(byte register) {
        return (4L | (long)(register & 3)) << (register >>> 2) - 2;
    }

    static byte pack(long hashPrefix) {
        int nlz = Long.numberOfLeadingZeros(hashPrefix) + 1;
        return (byte)((long)(-nlz << 2) | hashPrefix << nlz >>> 62);
    }

    @Override
    public double getDistinctCountEstimate() {
        return this.getDistinctCountEstimate(DEFAULT_ESTIMATOR);
    }

    @Override
    public double getDistinctCountEstimate(Estimator estimator) {
        return estimator.estimate(this);
    }

    static double getRegisterChangeProbability(byte reg, int p) {
        int r = reg & 0xFF;
        int off = p + 1 << 2;
        int t = r - off;
        if (t < 0) {
            long x = t == -2 ? 4598175219545276416L : (t == -4 ? 4604930618986332160L : (t == -8 ? 4602678819172646912L : 0x3FF0000000000000L));
            return Double.longBitsToDouble(x - ((long)p << 52));
        }
        if (r < 252) {
            long x = (r & 3) == 0 ? 4606056518893174784L : ((r & 3) == 1 ? 4600427019358961664L : ((r & 3) == 2 ? 4603804719079489536L : 4593671619917905920L));
            return Double.longBitsToDouble(x - ((long)(r >>> 2) - 1L << 52));
        }
        if (r == 252) {
            return 1.6263032587282567E-19;
        }
        if (r == 253) {
            return 5.421010862427522E-20;
        }
        if (r == 254) {
            return 1.0842021724855044E-19;
        }
        return 0.0;
    }

    @Override
    public double getStateChangeProbability() {
        int p = this.getP();
        double sum = 0.0;
        for (byte x : this.state) {
            sum += UltraLogLog.getRegisterChangeProbability(x, p);
        }
        return sum;
    }

    @Override
    public UltraLogLog reset() {
        Arrays.fill(this.state, (byte)0);
        return this;
    }

    static {
        DEFAULT_ESTIMATOR = OPTIMAL_FGRA_ESTIMATOR = new OptimalFGRAEstimator();
    }

    static final class OptimalFGRAEstimator
    implements Estimator {
        static final double ETA_0 = 4.663135749698441;
        static final double ETA_1 = 2.137850286535751;
        static final double ETA_2 = 2.7811447941454626;
        static final double ETA_3 = 0.9824082439220764;
        static final double TAU = 0.8194911850376387;
        static final double V = 0.6118931496978426;
        static final double POW_2_TAU = Math.pow(2.0, 0.8194911850376387);
        static final double POW_2_MINUS_TAU = Math.pow(2.0, -0.8194911850376387);
        static final double POW_4_MINUS_TAU = Math.pow(4.0, -0.8194911850376387);
        private static final double MINUS_INV_TAU = -1.2202693796566837;
        static final double ETA_X = 0.7265489129393036;
        private static final double ETA23X = 2.475726710465334;
        private static final double ETA13X = 1.5903155617414035;
        private static final double ETA3012XX = -2.585029651717508;
        private static final double POW_4_MINUS_TAU_ETA_23 = POW_4_MINUS_TAU * 1.7987365502233863;
        private static final double POW_4_MINUS_TAU_ETA_01 = POW_4_MINUS_TAU * 2.5252854631626898;
        private static final double POW_4_MINUS_TAU_ETA_3 = POW_4_MINUS_TAU * 0.9824082439220764;
        private static final double POW_4_MINUS_TAU_ETA_1 = POW_4_MINUS_TAU * 2.137850286535751;
        private static final double POW_2_MINUS_TAU_ETA_X = POW_2_MINUS_TAU * 0.7265489129393036;
        private static final double PHI_1 = 4.663135749698441 / (POW_2_TAU * (2.0 * POW_2_TAU - 1.0));
        private static final double P_INITIAL = 0.7265489129393036 * (POW_4_MINUS_TAU / (2.0 - POW_2_MINUS_TAU));
        private static final double POW_2_MINUS_TAU_ETA_02 = POW_2_MINUS_TAU * 1.8819909555529781;
        private static final double POW_2_MINUS_TAU_ETA_13 = POW_2_MINUS_TAU * 1.1554420426136747;
        private static final double POW_2_MINUS_TAU_ETA_2 = POW_2_MINUS_TAU * 2.7811447941454626;
        private static final double POW_2_MINUS_TAU_ETA_3 = POW_2_MINUS_TAU * 0.9824082439220764;
        static final double[] ESTIMATION_FACTORS = new double[]{94.59940317105753, 455.6357508097479, 2159.47633067634, 10149.50737889237, 47499.51084005241, 221818.67873312163, 1034754.2279126811, 4824372.022091801, 2.2486738498576667E7, 1.047980404094012E8, 4.8837154531911695E8, 2.27579316515324E9, 1.0604931024655107E10, 4.9417323383735405E10, 2.3027603606246478E11, 1.0730435513524987E12, 5.000178308875647E12, 2.329986496461238E13, 1.0857284075307834E14, 5.059282619272261E14, 2.35752686818917E15, 1.0985614301620942E16, 5.119081407311257E16, 2.3853917967466928E17};
        static final double[] REGISTER_CONTRIBUTIONS = new double[]{0.8484060852397345, 0.38895826537877115, 0.5059986013571249, 0.17873833769198574, 0.48074231113842836, 0.22039999321992973, 0.286719934334865, 0.10128060494380546, 0.272408665778737, 0.12488783845238811, 0.16246748612446876, 0.057389819499496945, 0.15435812382651734, 0.07076666367111045, 0.09206086109372673, 0.032519467908117806, 0.08746575782796642, 0.04009934633506583, 0.052165527684877616, 0.01842688829220614, 0.049561750316546825, 0.02272196388927665, 0.02955916603768511, 0.010441444278634157, 0.028083757066063253, 0.01287521344292119, 0.016749457651834092, 0.0059165582867257505, 0.01591342932621048, 0.007295633511635504, 0.009490942040547306, 0.0033525689575199494, 0.009017213484812202, 0.004134010560062819, 0.0053779640325944825, 0.0018997055501242264, 0.005109529653470475, 0.0023425029894189064, 0.003047378965366866, 0.0010764524825292335, 0.002895272838296102, 0.0013273599996205937, 0.0017267721580652433, 6.099629213946215E-4, 0.001640582475626021, 7.521375966439396E-4, 9.78461202153218E-4, 3.456304588587883E-4, 9.296225294315218E-4, 4.2619256603108554E-4, 5.544369705334033E-4, 1.9584864899296144E-4, 5.267629394230223E-4, 2.4149850260197735E-4, 3.141671367426608E-4, 1.1097602172856929E-4, 2.984858752501032E-4, 1.3684313478791045E-4, 1.780202170034317E-4, 6.288364745953644E-5, 1.691345595068001E-4, 7.754103374067414E-5, 1.0087368777819569E-4, 3.563250021240636E-5, 9.583870324044556E-5, 4.393798726469656E-5, 5.7159243243573585E-5, 2.019086237330832E-5, 5.430621078030427E-5, 2.489709811361428E-5, 3.238881377433127E-5, 1.1440985643660703E-5, 3.0772166458844975E-5, 1.4107735312149528E-5, 1.8352854204840335E-5, 6.4829401576968245E-6, 1.7436794336501408E-5, 7.994031863851523E-6, 1.0399493473609907E-5, 3.673504573582387E-6, 9.880415704239646E-6, 4.5297522264427E-6, 5.892787209039795E-6, 2.0815610701125073E-6, 5.598656072018156E-6, 2.5667467408713467E-6, 3.339099272396502E-6, 1.1794994131128855E-6, 3.1724322893920124E-6, 1.4544258719747923E-6, 1.8920730641376115E-6, 6.683536147505137E-7, 1.797632592771347E-6, 8.241384252626048E-7, 1.0721275972923483E-6, 3.787170636831222E-7, 1.0186136830719034E-6, 4.6699124175514954E-7, 6.075122608437811E-7, 2.1459690074139074E-7, 5.771890426962716E-7, 2.64616735721948E-7, 3.4424181226899694E-7, 1.2159956395929028E-7, 3.2705941079050064E-7, 1.499428909222517E-7, 1.9506178385544662E-7, 6.890339004899508E-8, 1.8532551776613992E-7, 8.496390251653092E-8, 1.10530151087912E-7, 3.9043537704077566E-8, 1.0501317620635024E-7, 4.814409463788256E-8, 6.263099853823858E-8, 2.2123698636101623E-8, 5.950485022176909E-8, 2.728045416758512E-8, 3.548933878482537E-8, 1.2536211371284819E-8, 3.371793262359259E-8, 1.5458244363870842E-8, 2.0109741131065348E-8, 7.103540783595807E-9, 1.9105988439127425E-8, 8.759286679951094E-9, 1.1395018960775247E-8, 4.025162799966202E-9, 1.082625077614191E-8, 4.963377556696614E-9, 6.45689351594096E-9, 2.2808253038606898E-9, 6.134605714922463E-9, 2.8124569580199258E-9, 3.6587454588460008E-9, 1.2924108477736359E-9, 3.4761237344042517E-9, 1.5936555400752456E-9, 2.073197939470036E-9, 7.323339479861321E-10, 1.969716845451942E-9, 9.030317684223642E-10, 1.1747605141076048E-9, 4.149709918458438E-10, 1.1161238056222668E-9, 5.116955039992654E-10, 6.656683567123106E-10, 2.351398901376407E-10, 6.324423494438382E-10, 2.899480372329477E-10, 3.771954843619131E-10, 1.3324007947640234E-10, 3.5836824136820584E-10, 1.64296664008522E-10, 2.1373471036795443E-10, 7.549939216389946E-11, 2.0306640839956248E-10, 9.309734965594018E-11, 1.2111101089492876E-10, 4.278110790325553E-11, 1.1506590556926544E-10, 5.27528453804198E-11, 6.862655548431996E-11, 2.424156196458913E-11, 6.520114640735252E-11, 2.9891964766076615E-11, 3.8886671681143153E-11, 1.3736281159710114E-11, 3.694569187806878E-11, 1.6938035306585002E-11, 2.2034811797927628E-11, 7.783550431866983E-12, 2.0934971600365387E-11, 9.597798013354695E-12, 1.2485844377510246E-11, 4.410484658912948E-12, 1.186262900027782E-11, 5.438513088312147E-12, 7.075000741965357E-12, 2.499164757366473E-12, 6.721860888303071E-12, 3.0816885884228205E-12, 4.0089908207546885E-12, 1.4161310983908962E-12, 3.808887035128585E-12, 1.7462134230080132E-12, 2.27166158521571E-12, 8.02439007639917E-13, 2.158274425407386E-12, 9.894774345950254E-13, 1.2872183021794324E-12, 4.546954457209435E-13, 1.2229684032123849E-12, 5.60679227792338E-13, 7.293916348496756E-13, 2.576494243063289E-13, 6.929849594884327E-13, 3.177042603366454E-13, 4.1330375437322283E-13, 1.459949213701249E-13, 3.926742120366818E-13, 1.8002449891623002E-13, 2.3419516377399323E-13, 8.272681812992227E-14, 2.2250560374709368E-13, 1.0200939759416105E-13, 1.3270475807388645E-13, 4.6876469220125044E-14, 1.260809652919964E-13, 5.780278384424677E-14, 7.51960567061224E-14, 2.6562164679104723E-14, 7.144273915469492E-14, 3.275347074822785E-14, 4.26092253678056E-14, 1.505123154917496E-14, 4.0482438932039044E-14, 1.855948407166197E-14, 2.41441661434439E-14, 8.528656225261955E-15, 2.2939040149870594E-14, 1.051657858350517E-14, 1.3681092620911158E-14, 4.832692711626445E-15, 1.299821791569287E-14, 5.959132520925467E-15, 7.752278301513157E-15, 2.7384054683585176E-15, 7.365332981676317E-15, 3.3766932962065717E-15, 4.392764564158709E-15, 1.5516948741837312E-15, 4.173505189928762E-15, 1.91337540768026E-15, 2.4891238118169875E-15, 8.792551031572981E-16};

        OptimalFGRAEstimator() {
        }

        static double calculateTheoreticalRelativeStandardError(int p) {
            return Math.sqrt(0.6118931496978426 / (double)(1 << p));
        }

        static double smallRangeEstimate(long c0, long c4, long c8, long c10, long m) {
            long alpha = m + 3L * (c0 + c4 + c8 + c10);
            long beta = m - c0 - c4;
            long gamma = 4L * c0 + 2L * c4 + 3L * c8 + c10;
            double quadRootZ = (Math.sqrt(beta * beta + 4L * alpha * gamma) - (double)beta) / (double)(2L * alpha);
            double rootZ = quadRootZ * quadRootZ;
            return rootZ * rootZ;
        }

        static double largeRangeEstimate(long c4w0, long c4w1, long c4w2, long c4w3, long m) {
            long alpha = m + 3L * (c4w0 + c4w1 + c4w2 + c4w3);
            long beta = c4w0 + c4w1 + 2L * (c4w2 + c4w3);
            long gamma = m + 2L * c4w0 + c4w2 - c4w3;
            return Math.sqrt((Math.sqrt(beta * beta + 4L * alpha * gamma) - (double)beta) / (double)(2L * alpha));
        }

        static double psiPrime(double z, double zSquare) {
            return (z + 2.475726710465334) * (zSquare + 1.5903155617414035) + -2.585029651717508;
        }

        static double sigma(double z) {
            if (z <= 0.0) {
                return 0.9824082439220764;
            }
            if (z >= 1.0) {
                return Double.POSITIVE_INFINITY;
            }
            double powZ = z;
            double nextPowZ = powZ * powZ;
            double s = 0.0;
            double powTau = 0.7265489129393036;
            while (true) {
                double oldS = s;
                double nextNextPowZ = nextPowZ * nextPowZ;
                if (!((s += powTau * (powZ - nextPowZ) * OptimalFGRAEstimator.psiPrime(nextPowZ, nextNextPowZ)) > oldS)) {
                    return s / z;
                }
                powZ = nextPowZ;
                nextPowZ = nextNextPowZ;
                powTau *= POW_2_TAU;
            }
        }

        private static double calculateContribution0(int c0, double z) {
            return (double)c0 * OptimalFGRAEstimator.sigma(z);
        }

        private static double calculateContribution4(int c4, double z) {
            return (double)c4 * POW_2_MINUS_TAU_ETA_X * OptimalFGRAEstimator.psiPrime(z, z * z);
        }

        private static double calculateContribution8(int c8, double z) {
            return (double)c8 * (z * POW_4_MINUS_TAU_ETA_01 + POW_4_MINUS_TAU_ETA_1);
        }

        private static double calculateContribution10(int c10, double z) {
            return (double)c10 * (z * POW_4_MINUS_TAU_ETA_23 + POW_4_MINUS_TAU_ETA_3);
        }

        static double phi(double z, double zSquare) {
            if (z <= 0.0) {
                return 0.0;
            }
            if (z >= 1.0) {
                return PHI_1;
            }
            double previousPowZ = zSquare;
            double powZ = z;
            double nextPowZ = Math.sqrt(powZ);
            double p = P_INITIAL / (1.0 + nextPowZ);
            double ps = OptimalFGRAEstimator.psiPrime(powZ, previousPowZ);
            double s = nextPowZ * (ps + ps) * p;
            while (true) {
                double nextPs;
                previousPowZ = powZ;
                powZ = nextPowZ;
                double oldS = s;
                nextPowZ = Math.sqrt(powZ);
                if (!((s += nextPowZ * ((nextPs = OptimalFGRAEstimator.psiPrime(powZ, previousPowZ)) + nextPs - (powZ + nextPowZ) * ps) * (p *= POW_2_MINUS_TAU / (1.0 + nextPowZ))) > oldS)) {
                    return s;
                }
                ps = nextPs;
            }
        }

        private static double calculateLargeRangeContribution(int c4w0, int c4w1, int c4w2, int c4w3, int m, int w) {
            double z = OptimalFGRAEstimator.largeRangeEstimate(c4w0, c4w1, c4w2, c4w3, m);
            double rootZ = Math.sqrt(z);
            double s = OptimalFGRAEstimator.phi(rootZ, z) * (double)(c4w0 + c4w1 + c4w2 + c4w3);
            s += z * (1.0 + rootZ) * ((double)c4w0 * 4.663135749698441 + (double)c4w1 * 2.137850286535751 + (double)c4w2 * 2.7811447941454626 + (double)c4w3 * 0.9824082439220764);
            return (s += rootZ * ((double)(c4w0 + c4w1) * (z * POW_2_MINUS_TAU_ETA_02 + POW_2_MINUS_TAU_ETA_2) + (double)(c4w2 + c4w3) * (z * POW_2_MINUS_TAU_ETA_13 + POW_2_MINUS_TAU_ETA_3))) * Math.pow(POW_2_MINUS_TAU, w) / ((1.0 + rootZ) * (1.0 + z));
        }

        @Override
        public double estimate(UltraLogLog ultraLogLog) {
            byte[] state = ultraLogLog.state;
            int m = state.length;
            int p = ultraLogLog.getP();
            int c0 = 0;
            int c4 = 0;
            int c8 = 0;
            int c10 = 0;
            int c4w0 = 0;
            int c4w1 = 0;
            int c4w2 = 0;
            int c4w3 = 0;
            double sum = 0.0;
            for (byte reg : state) {
                int r = reg & 0xFF;
                int r2 = r - (p << 2) - 4;
                if (r2 < 0) {
                    if (r2 < -8) {
                        ++c0;
                    }
                    if (r2 == -8) {
                        ++c4;
                    }
                    if (r2 == -4) {
                        ++c8;
                    }
                    if (r2 != -2) continue;
                    ++c10;
                    continue;
                }
                if (r < 252) {
                    sum += REGISTER_CONTRIBUTIONS[r2];
                    continue;
                }
                if (r == 252) {
                    ++c4w0;
                }
                if (r == 253) {
                    ++c4w1;
                }
                if (r == 254) {
                    ++c4w2;
                }
                if (r != 255) continue;
                ++c4w3;
            }
            if (c0 > 0 || c4 > 0 || c8 > 0 || c10 > 0) {
                double z = OptimalFGRAEstimator.smallRangeEstimate(c0, c4, c8, c10, m);
                if (c0 > 0) {
                    sum += OptimalFGRAEstimator.calculateContribution0(c0, z);
                }
                if (c4 > 0) {
                    sum += OptimalFGRAEstimator.calculateContribution4(c4, z);
                }
                if (c8 > 0) {
                    sum += OptimalFGRAEstimator.calculateContribution8(c8, z);
                }
                if (c10 > 0) {
                    sum += OptimalFGRAEstimator.calculateContribution10(c10, z);
                }
            }
            if (c4w0 > 0 || c4w1 > 0 || c4w2 > 0 || c4w3 > 0) {
                sum += OptimalFGRAEstimator.calculateLargeRangeContribution(c4w0, c4w1, c4w2, c4w3, m, 65 - p);
            }
            return ESTIMATION_FACTORS[p - 3] * Math.pow(sum, -1.2202693796566837);
        }
    }

    private static final class MaximumLikelihoodEstimator
    implements Estimator {
        private static final double INV_SQRT_FISHER_INFORMATION = 0.7608621002725182;
        private static final double ML_EQUATION_SOLVER_EPS = 7.608621002725182E-4;
        private static final double ML_BIAS_CORRECTION_CONSTANT = 0.48147376527720065;

        private MaximumLikelihoodEstimator() {
        }

        private static double contribute(int r, int[] b, int p) {
            int k;
            int r2 = r - (p << 2) - 4;
            if (r2 < 0) {
                if (r2 == -8) {
                    b[1] = b[1] + 1;
                    return 0.5;
                }
                if (r2 == -4) {
                    b[2] = b[2] + 1;
                    return 0.75;
                }
                if (r2 == -2) {
                    b[1] = b[1] + 1;
                    b[2] = b[2] + 1;
                    return 0.25;
                }
                return 1.0;
            }
            double ret = 0.0;
            if (r < 252) {
                int n = k = (r2 >>> 2) + 3;
                b[n] = b[n] + 1;
                ret += Double.longBitsToDouble(0x3FF0000000000000L - ((long)k << 52));
            } else {
                k = 65 - p;
                int n = k - 1;
                b[n] = b[n] + 1;
            }
            if ((r & 1) == 0) {
                ret += Double.longBitsToDouble(0x4010000000000000L - ((long)k << 52));
            } else {
                int n = k - 2;
                b[n] = b[n] + 1;
            }
            if ((r & 2) == 0) {
                ret += Double.longBitsToDouble(0x4000000000000000L - ((long)k << 52));
            } else {
                int n = k - 1;
                b[n] = b[n] + 1;
            }
            return ret;
        }

        @Override
        public double estimate(UltraLogLog ultraLogLog) {
            byte[] state = ultraLogLog.state;
            int p = ultraLogLog.getP();
            double a = 0.0;
            int[] b = new int[64];
            for (byte r : state) {
                a += MaximumLikelihoodEstimator.contribute(r & 0xFF, b, p);
            }
            int m = state.length;
            return (double)m * DistinctCountUtil.solveMaximumLikelihoodEquation(a, b, 7.608621002725182E-4 / Math.sqrt(m)) / (1.0 + 0.48147376527720065 / (double)m);
        }
    }

    public static interface Estimator
    extends DistinctCounter.Estimator<UltraLogLog> {
    }
}

