/*
 * Decompiled with CFR 0.152.
 */
package org.rauschig.jarchivelib;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.attribute.PosixFilePermission;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.rauschig.jarchivelib.AttributeAccessor;

abstract class FileModeMapper {
    private static final Logger LOG = Logger.getLogger(FileModeMapper.class.getCanonicalName());
    private static boolean IS_POSIX = FileSystems.getDefault().supportedFileAttributeViews().contains("posix");
    private ArchiveEntry archiveEntry;

    public FileModeMapper(ArchiveEntry archiveEntry) {
        this.archiveEntry = archiveEntry;
    }

    public abstract void map(File var1) throws IOException;

    public ArchiveEntry getArchiveEntry() {
        return this.archiveEntry;
    }

    public static void map(ArchiveEntry entry, File file) throws IOException {
        FileModeMapper.create(entry).map(file);
    }

    public static FileModeMapper create(ArchiveEntry entry) {
        if (IS_POSIX) {
            return new PosixPermissionMapper(entry);
        }
        return new FallbackFileModeMapper(entry);
    }

    public static class PosixFilePermissionsMapper {
        public static Map<Integer, PosixFilePermission> intToPosixFilePermission = new HashMap<Integer, PosixFilePermission>();

        public Set<PosixFilePermission> map(int mode) {
            HashSet<PosixFilePermission> permissionSet = new HashSet<PosixFilePermission>();
            for (Map.Entry<Integer, PosixFilePermission> entry : intToPosixFilePermission.entrySet()) {
                if ((mode & entry.getKey()) <= 0) continue;
                permissionSet.add(entry.getValue());
            }
            return permissionSet;
        }

        static {
            intToPosixFilePermission.put(256, PosixFilePermission.OWNER_READ);
            intToPosixFilePermission.put(128, PosixFilePermission.OWNER_WRITE);
            intToPosixFilePermission.put(64, PosixFilePermission.OWNER_EXECUTE);
            intToPosixFilePermission.put(32, PosixFilePermission.GROUP_READ);
            intToPosixFilePermission.put(16, PosixFilePermission.GROUP_WRITE);
            intToPosixFilePermission.put(8, PosixFilePermission.GROUP_EXECUTE);
            intToPosixFilePermission.put(4, PosixFilePermission.OTHERS_READ);
            intToPosixFilePermission.put(2, PosixFilePermission.OTHERS_WRITE);
            intToPosixFilePermission.put(1, PosixFilePermission.OTHERS_EXECUTE);
        }
    }

    public static class PosixPermissionMapper
    extends FileModeMapper {
        public static final int UNIX_PERMISSION_MASK = 511;

        public PosixPermissionMapper(ArchiveEntry archiveEntry) {
            super(archiveEntry);
        }

        @Override
        public void map(File file) throws IOException {
            int mode = this.getMode() & 0x1FF;
            if (mode > 0) {
                this.setPermissions(mode, file);
            }
        }

        public int getMode() throws IOException {
            return AttributeAccessor.create(this.getArchiveEntry()).getMode();
        }

        private void setPermissions(int mode, File file) {
            try {
                Set<PosixFilePermission> posixFilePermissions = new PosixFilePermissionsMapper().map(mode);
                Files.setPosixFilePermissions(file.toPath(), posixFilePermissions);
            }
            catch (Exception e) {
                LOG.warning("Could not set file permissions of " + file + ". Exception was: " + e.getMessage());
            }
        }
    }

    public static class FallbackFileModeMapper
    extends FileModeMapper {
        public FallbackFileModeMapper(ArchiveEntry archiveEntry) {
            super(archiveEntry);
        }

        @Override
        public void map(File file) throws IOException {
        }
    }
}

