/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.profiler.report;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.function.Consumer;
import org.gradle.profiler.InvocationSettings;
import org.gradle.profiler.report.BenchmarkResult;

public abstract class AbstractGenerator {
    private final File outputFile;

    public AbstractGenerator(File outputFile) {
        this.outputFile = outputFile;
    }

    public void write(InvocationSettings settings, BenchmarkResult result) throws IOException {
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(this.outputFile));){
            this.write(settings, result, writer);
        }
    }

    protected abstract void write(InvocationSettings var1, BenchmarkResult var2, BufferedWriter var3) throws IOException;

    public void summarizeResults(Consumer<String> consumer) {
        consumer.accept(this.outputFile.getAbsolutePath());
    }
}

