@rem
@rem Copyright 2015 the original author or authors.
@rem
@rem Licensed under the Apache License, Version 2.0 (the "License");
@rem you may not use this file except in compliance with the License.
@rem You may obtain a copy of the License at
@rem
@rem      https://www.apache.org/licenses/LICENSE-2.0
@rem
@rem Unless required by applicable law or agreed to in writing, software
@rem distributed under the License is distributed on an "AS IS" BASIS,
@rem WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
@rem See the License for the specific language governing permissions and
@rem limitations under the License.
@rem

@if "%DEBUG%"=="" @echo off
@rem ##########################################################################
@rem
@rem  gradle-profiler startup script for Windows
@rem
@rem ##########################################################################

@rem Set local scope for the variables with windows NT shell
if "%OS%"=="Windows_NT" setlocal

set DIRNAME=%~dp0
if "%DIRNAME%"=="" set DIRNAME=.
@rem This is normally unused
set APP_BASE_NAME=%~n0
set APP_HOME=%DIRNAME%..

@rem Resolve any "." and ".." in APP_HOME to make it shorter.
for %%i in ("%APP_HOME%") do set APP_HOME=%%~fi

@rem Add default JVM options here. You can also use JAVA_OPTS and GRADLE_PROFILER_OPTS to pass JVM options to this script.
set DEFAULT_JVM_OPTS=

@rem Find java.exe
if defined JAVA_HOME goto findJavaFromJavaHome

set JAVA_EXE=java.exe
%JAVA_EXE% -version >NUL 2>&1
if %ERRORLEVEL% equ 0 goto execute

echo.
echo ERROR: JAVA_HOME is not set and no 'java' command could be found in your PATH.
echo.
echo Please set the JAVA_HOME variable in your environment to match the
echo location of your Java installation.

goto fail

:findJavaFromJavaHome
set JAVA_HOME=%JAVA_HOME:"=%
set JAVA_EXE=%JAVA_HOME%/bin/java.exe

if exist "%JAVA_EXE%" goto execute

echo.
echo ERROR: JAVA_HOME is set to an invalid directory: %JAVA_HOME%
echo.
echo Please set the JAVA_HOME variable in your environment to match the
echo location of your Java installation.

goto fail

:execute
@rem Setup the command line

set CLASSPATH=%APP_HOME%\lib\gradle-profiler-0.21.17-alpha-4.jar;%APP_HOME%\lib\gradle-tooling-api-7.2.jar;%APP_HOME%\lib\annotations-3.0.1.jar;%APP_HOME%\lib\ide-provisioning-0.21.17-alpha-4.jar;%APP_HOME%\lib\ide-starter-squashed-233.13135.103.jar;%APP_HOME%\lib\guava-32.1.3-jre.jar;%APP_HOME%\lib\config-1.3.3.jar;%APP_HOME%\lib\commons-math3-3.6.1.jar;%APP_HOME%\lib\javaparser-core-3.18.0.jar;%APP_HOME%\lib\jopt-simple-5.0.4.jar;%APP_HOME%\lib\ant-compress-1.5.jar;%APP_HOME%\lib\commons-io-2.14.0.jar;%APP_HOME%\lib\flightrecorder-8.0.1.jar;%APP_HOME%\lib\dd-plist-1.23.jar;%APP_HOME%\lib\gson-2.10.1.jar;%APP_HOME%\lib\client-protocol-0.21.17-alpha-4.jar;%APP_HOME%\lib\slf4j-simple-1.7.10.jar;%APP_HOME%\lib\slf4j-api-2.0.9.jar;%APP_HOME%\lib\jcip-annotations-1.0.jar;%APP_HOME%\lib\jsr305-3.0.2.jar;%APP_HOME%\lib\failureaccess-1.0.1.jar;%APP_HOME%\lib\listenablefuture-9999.0-empty-to-avoid-conflict-with-guava.jar;%APP_HOME%\lib\error_prone_annotations-2.21.1.jar;%APP_HOME%\lib\grpc-util-1.59.0.jar;%APP_HOME%\lib\grpc-core-1.59.0.jar;%APP_HOME%\lib\animal-sniffer-annotations-1.23.jar;%APP_HOME%\lib\ant-1.10.14.jar;%APP_HOME%\lib\commons-compress-1.24.0.jar;%APP_HOME%\lib\xz-1.9.jar;%APP_HOME%\lib\dec-0.1.2.jar;%APP_HOME%\lib\common-8.0.1.jar;%APP_HOME%\lib\ant-launcher-1.10.14.jar;%APP_HOME%\lib\encoder-1.2.2.jar;%APP_HOME%\lib\lz4-java-1.8.0.jar;%APP_HOME%\lib\kotlinx-coroutines-core-jvm-1.7.3.jar;%APP_HOME%\lib\kotlin-stdlib-1.9.21.jar;%APP_HOME%\lib\kotlin-reflect-1.9.21.jar;%APP_HOME%\lib\jackson-databind-2.15.2.jar;%APP_HOME%\lib\jackson-annotations-2.15.2.jar;%APP_HOME%\lib\jackson-core-2.15.2.jar;%APP_HOME%\lib\jackson-module-kotlin-2.15.2.jar;%APP_HOME%\lib\httpmime-4.5.14.jar;%APP_HOME%\lib\gradle-api-8.4.jar;%APP_HOME%\lib\kodein-di-jvm-7.20.2.jar;%APP_HOME%\lib\jarchivelib-1.2.0.jar;%APP_HOME%\lib\qodana-sarif-0.2.86.jar;%APP_HOME%\lib\annotations-24.0.0.jar;%APP_HOME%\lib\jackson-datatype-jsr310-2.15.2.jar;%APP_HOME%\lib\monte-screen-recorder-0.7.7.0.jar;%APP_HOME%\lib\allure-java-commons-2.24.0.jar;%APP_HOME%\lib\oro-2.0.8.jar;%APP_HOME%\lib\velocity-engine-core-2.3.jar;%APP_HOME%\lib\cli-parser-1.1.6.jar;%APP_HOME%\lib\swingx-core-1.6.2-2.jar;%APP_HOME%\lib\commons-logging-1.2.jar;%APP_HOME%\lib\groovy-3.0.19.jar;%APP_HOME%\lib\xstream-1.4.20.jar;%APP_HOME%\lib\miglayout-swing-11.1.jar;%APP_HOME%\lib\jna-platform-5.13.0.jar;%APP_HOME%\lib\streamex-0.8.2.jar;%APP_HOME%\lib\intellij-deps-fastutil-8.5.11-18.jar;%APP_HOME%\lib\pty4j-0.12.13.jar;%APP_HOME%\lib\caffeine-3.1.8.jar;%APP_HOME%\lib\opentelemetry-sdk-1.31.0.jar;%APP_HOME%\lib\kotlinx-html-jvm-0.9.1.jar;%APP_HOME%\lib\jsoup-1.16.1.jar;%APP_HOME%\lib\kotlinx-collections-immutable-jvm-0.3.6.jar;%APP_HOME%\lib\hash4j-0.13.0.jar;%APP_HOME%\lib\kotlinx-serialization-protobuf-jvm-1.6.0.jar;%APP_HOME%\lib\kotlinx-serialization-core-jvm-1.6.0.jar;%APP_HOME%\lib\jcef-111.2.1-g870da30-chromium-111.0.5563.64-api-1.12.jar;%APP_HOME%\lib\log4j-over-slf4j-1.7.36.jar;%APP_HOME%\lib\aalto-xml-1.3.2.jar;%APP_HOME%\lib\jaxen-1.2.0.jar;%APP_HOME%\lib\annotations-java5-24.0.0.jar;%APP_HOME%\lib\kotlinx-coroutines-debug-1.7.3.jar;%APP_HOME%\lib\trove4j-1.0.20221201.jar;%APP_HOME%\lib\kryo5-5.5.0.jar;%APP_HOME%\lib\imgscalr-lib-4.2.jar;%APP_HOME%\lib\java-compatibility-1.0.1.jar;%APP_HOME%\lib\netty-buffer-4.1.99.Final.jar;%APP_HOME%\lib\jbr-api-17.1.9.0.jar;%APP_HOME%\lib\jsvg-1.2.0-jb.1.jar;%APP_HOME%\lib\slf4j-jdk14-2.0.9.jar;%APP_HOME%\lib\kotlinx-serialization-json-jvm-1.6.0.jar;%APP_HOME%\lib\automaton-1.12-4.jar;%APP_HOME%\lib\ap-validation-76.jar;%APP_HOME%\lib\icu4j-73.2.jar;%APP_HOME%\lib\HdrHistogram-2.1.12.jar;%APP_HOME%\lib\commons-codec-1.16.0.jar;%APP_HOME%\lib\cglib-nodep-3.3.0.jar;%APP_HOME%\lib\winp-1.30.1.jar;%APP_HOME%\lib\commons-imaging-1.0-RC-1.jar;%APP_HOME%\lib\netty-codec-http2-4.1.99.Final.jar;%APP_HOME%\lib\javax.activation-1.2.0.jar;%APP_HOME%\lib\jaxb-api-2.3.1.jar;%APP_HOME%\lib\jaxb-runtime-2.3.1.jar;%APP_HOME%\lib\javax.annotation-api-1.3.2.jar;%APP_HOME%\lib\byte-buddy-agent-1.14.0.jar;%APP_HOME%\lib\asm-all-9.5.3.jar;%APP_HOME%\lib\groovy-jsr223-3.0.19.jar;%APP_HOME%\lib\groovy-json-3.0.19.jar;%APP_HOME%\lib\groovy-templates-3.0.19.jar;%APP_HOME%\lib\groovy-xml-3.0.19.jar;%APP_HOME%\lib\blockmap-1.0.7.jar;%APP_HOME%\lib\classgraph-4.8.162.jar;%APP_HOME%\lib\marketplace-zip-signer-0.1.8.jar;%APP_HOME%\lib\netty-handler-proxy-4.1.99.Final.jar;%APP_HOME%\lib\rhino-runtime-1.7.14.jar;%APP_HOME%\lib\jgoodies-common-1.4.0.jar;%APP_HOME%\lib\forms-1.1-preview.jar;%APP_HOME%\lib\jvm-native-trusted-roots-1.0.21.jar;%APP_HOME%\lib\opentelemetry-extension-kotlin-1.31.0.jar;%APP_HOME%\lib\proxy-vole-1.1.0.jar;%APP_HOME%\lib\snakeyaml-engine-2.7.jar;%APP_HOME%\lib\ion-java-1.8.2-4.jar;%APP_HOME%\lib\bcpkix-jdk18on-1.76.jar;%APP_HOME%\lib\snakeyaml-2.2.jar;%APP_HOME%\lib\dbus-java-transport-native-unixsocket-4.2.1.jar;%APP_HOME%\lib\commons-cli-1.5.0.jar;%APP_HOME%\lib\jediterm-core-3.28.jar;%APP_HOME%\lib\jediterm-ui-3.28.jar;%APP_HOME%\lib\rd-core-2023.3.3.jar;%APP_HOME%\lib\rd-framework-2023.3.3.jar;%APP_HOME%\lib\rd-text-2023.3.3.jar;%APP_HOME%\lib\rd-swing-2023.3.3.jar;%APP_HOME%\lib\protobuf-java-3.24.4-jb.2.jar;%APP_HOME%\lib\grpc-stub-1.59.0.jar;%APP_HOME%\lib\grpc-protobuf-1.59.0.jar;%APP_HOME%\lib\grpc-kotlin-stub-1.4.0.jar;%APP_HOME%\lib\grpc-inprocess-1.59.0.jar;%APP_HOME%\lib\grpc-netty-shaded-1.59.0.jar;%APP_HOME%\lib\bcpg-jdk18on-1.76.jar;%APP_HOME%\lib\rd-gen-2023.3.3.jar;%APP_HOME%\lib\opentelemetry-exporter-otlp-common-1.31.0.jar;%APP_HOME%\lib\kotlinx-datetime-jvm-0.4.1.jar;%APP_HOME%\lib\checker-qual-3.37.0.jar;%APP_HOME%\lib\httpclient-4.5.14.jar;%APP_HOME%\lib\gradle-api-impldep-8.4.jar;%APP_HOME%\lib\gradle-wrapper-8.4.jar;%APP_HOME%\lib\gradle-launcher-8.4.jar;%APP_HOME%\lib\allure-model-2.24.0.jar;%APP_HOME%\lib\mxparser-1.2.2.jar;%APP_HOME%\lib\miglayout-core-11.1.jar;%APP_HOME%\lib\jna-5.13.0.jar;%APP_HOME%\lib\purejavacomm-0.0.11.1.jar;%APP_HOME%\lib\opentelemetry-sdk-trace-1.31.0.jar;%APP_HOME%\lib\opentelemetry-sdk-metrics-1.31.0.jar;%APP_HOME%\lib\opentelemetry-sdk-logs-1.31.0.jar;%APP_HOME%\lib\opentelemetry-sdk-common-1.31.0.jar;%APP_HOME%\lib\opentelemetry-extension-incubator-1.31.0-alpha.jar;%APP_HOME%\lib\opentelemetry-api-events-1.31.0-alpha.jar;%APP_HOME%\lib\opentelemetry-api-1.31.0.jar;%APP_HOME%\lib\stax2-api-4.2.jar;%APP_HOME%\lib\netty-common-4.1.99.Final.jar;%APP_HOME%\lib\model-76.jar;%APP_HOME%\lib\netty-codec-http-4.1.99.Final.jar;%APP_HOME%\lib\netty-handler-4.1.99.Final.jar;%APP_HOME%\lib\netty-codec-4.1.99.Final.jar;%APP_HOME%\lib\netty-transport-native-unix-common-4.1.99.Final.jar;%APP_HOME%\lib\netty-transport-4.1.99.Final.jar;%APP_HOME%\lib\txw2-2.3.1.jar;%APP_HOME%\lib\istack-commons-runtime-3.0.7.jar;%APP_HOME%\lib\stax-ex-1.8.jar;%APP_HOME%\lib\FastInfoset-1.2.15.jar;%APP_HOME%\lib\netty-codec-socks-4.1.99.Final.jar;%APP_HOME%\lib\delight-rhino-sandbox-0.0.17.jar;%APP_HOME%\lib\bcutil-jdk18on-1.76.jar;%APP_HOME%\lib\bcprov-jdk18on-1.76.jar;%APP_HOME%\lib\dbus-java-core-4.2.1.jar;%APP_HOME%\lib\grpc-context-1.59.0.jar;%APP_HOME%\lib\grpc-api-1.59.0.jar;%APP_HOME%\lib\annotations-4.1.1.4.jar;%APP_HOME%\lib\perfmark-api-0.26.0.jar;%APP_HOME%\lib\proto-google-common-protos-2.22.0.jar;%APP_HOME%\lib\grpc-protobuf-lite-1.59.0.jar;%APP_HOME%\lib\opentelemetry-exporter-common-1.31.0.jar;%APP_HOME%\lib\httpcore-4.4.16.jar;%APP_HOME%\lib\kaverit-jvm-2.4.0.jar;%APP_HOME%\lib\xmlpull-1.1.3.1.jar;%APP_HOME%\lib\opentelemetry-context-1.31.0.jar;%APP_HOME%\lib\netty-resolver-4.1.99.Final.jar


@rem Execute gradle-profiler
"%JAVA_EXE%" %DEFAULT_JVM_OPTS% %JAVA_OPTS% %GRADLE_PROFILER_OPTS%  -classpath "%CLASSPATH%" org.gradle.profiler.Main %*

:end
@rem End local scope for the variables with windows NT shell
if %ERRORLEVEL% equ 0 goto mainEnd

:fail
rem Set variable GRADLE_PROFILER_EXIT_CONSOLE if you need the _script_ return code instead of
rem the _cmd.exe /c_ return code!
set EXIT_CODE=%ERRORLEVEL%
if %EXIT_CODE% equ 0 set EXIT_CODE=1
if not ""=="%GRADLE_PROFILER_EXIT_CONSOLE%" exit %EXIT_CODE%
exit /b %EXIT_CODE%

:mainEnd
if "%OS%"=="Windows_NT" endlocal

:omega
