/*
 * Decompiled with CFR 0.152.
 */
package org.cef.browser;

import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.SwingUtilities;
import org.cef.CefApp;
import org.cef.CefClient;
import org.cef.browser.CefBrowser;
import org.cef.browser.CefFrame;
import org.cef.browser.CefRequestContext;
import org.cef.callback.CefDragData;
import org.cef.callback.CefNativeAdapter;
import org.cef.callback.CefPdfPrintCallback;
import org.cef.callback.CefRunFileDialogCallback;
import org.cef.callback.CefStringVisitor;
import org.cef.handler.CefAppStateHandler;
import org.cef.handler.CefClientHandler;
import org.cef.handler.CefDialogHandler;
import org.cef.handler.CefLifeSpanHandlerAdapter;
import org.cef.handler.CefRenderHandler;
import org.cef.handler.CefWindowHandler;
import org.cef.input.CefCompositionUnderline;
import org.cef.input.CefTouchEvent;
import org.cef.misc.CefLog;
import org.cef.misc.CefPdfPrintSettings;
import org.cef.misc.CefRange;
import org.cef.network.CefRequest;

abstract class CefBrowser_N
extends CefNativeAdapter
implements CefBrowser,
CefAppStateHandler {
    private static final boolean TRACE_LIFESPAN = Boolean.getBoolean("jcef.trace.cefbrowser_n.lifespan");
    private volatile boolean isPending_ = false;
    private final CefClient client_;
    private final String url_;
    private CefRequestContext request_context_;
    private volatile CefBrowser_N parent_ = null;
    private volatile Point inspectAt_ = null;
    private volatile CefBrowser_N devTools_ = null;
    private boolean closeAllowed_ = false;
    private volatile boolean isClosed_ = false;
    private volatile boolean isClosing_ = false;
    private volatile boolean isCreating_ = false;
    private boolean isNativeCtxInitialized_ = false;
    private final List<Runnable> delayedActions_ = new ArrayList<Runnable>();

    protected CefBrowser_N(CefClient client, String url, CefRequestContext context, CefBrowser_N parent, Point inspectAt) {
        this.client_ = client;
        this.url_ = url;
        this.request_context_ = context;
        this.parent_ = parent;
        this.inspectAt_ = inspectAt;
        CefApp.getInstance().onInitialization(this);
    }

    protected String getUrl() {
        return this.url_;
    }

    protected CefBrowser_N getParentBrowser() {
        return this.parent_;
    }

    protected Point getInspectAt() {
        return this.inspectAt_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stateHasChanged(CefApp.CefAppState state) {
        if (this.isClosing_ || this.isClosed_) {
            return;
        }
        if (CefApp.CefAppState.INITIALIZED == state) {
            List<Runnable> list = this.delayedActions_;
            synchronized (list) {
                this.isNativeCtxInitialized_ = true;
                if (this.request_context_ == null) {
                    this.request_context_ = CefRequestContext.getGlobalContext();
                }
                this.delayedActions_.forEach(r -> r.run());
                this.delayedActions_.clear();
            }
        }
    }

    @Override
    public boolean isClosed() {
        return this.isClosed_;
    }

    @Override
    public boolean isClosing() {
        return this.isClosing_;
    }

    @Override
    public CefClient getClient() {
        return this.client_;
    }

    @Override
    public CefRequestContext getRequestContext() {
        return this.request_context_;
    }

    @Override
    public CefRenderHandler getRenderHandler() {
        return null;
    }

    @Override
    public CefWindowHandler getWindowHandler() {
        return null;
    }

    @Override
    public synchronized void setCloseAllowed() {
        this.closeAllowed_ = true;
    }

    @Override
    public synchronized boolean doClose() {
        if (this.closeAllowed_) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Component uiComponent = CefBrowser_N.this.getUIComponent();
                    if (uiComponent == null) {
                        return;
                    }
                    Component parent = SwingUtilities.getRoot(uiComponent);
                    if (parent != null) {
                        parent.dispatchEvent(new WindowEvent((Window)parent, 201));
                    }
                }
            });
            return false;
        }
        return true;
    }

    @Override
    public synchronized void onBeforeClose() {
        if (TRACE_LIFESPAN) {
            CefLog.Debug("CefBrowser_N: %s: onBeforeClose", this);
        }
        this.isClosed_ = true;
        if (this.request_context_ != null) {
            this.request_context_.dispose();
        }
        if (this.parent_ != null) {
            this.parent_.closeDevTools();
            this.parent_.devTools_ = null;
            this.parent_ = null;
        }
    }

    @Override
    public CefBrowser getDevTools() {
        return this.getDevTools(null);
    }

    @Override
    public synchronized CefBrowser getDevTools(Point inspectAt) {
        if (this.devTools_ == null) {
            this.devTools_ = (CefBrowser_N)this.createDevToolsBrowser(this.client_, this.url_, this.request_context_, this, inspectAt);
        }
        return this.devTools_;
    }

    protected abstract CefBrowser createDevToolsBrowser(CefClient var1, String var2, CefRequestContext var3, CefBrowser var4, Point var5);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeNative(Runnable nativeRunnable, String name) {
        List<Runnable> list = this.delayedActions_;
        synchronized (list) {
            if (this.isNativeCtxInitialized_) {
                nativeRunnable.run();
            } else {
                CefLog.Debug("CefBrowser_N: %s: add delayed action %s", this, name);
                this.delayedActions_.add(nativeRunnable);
            }
        }
    }

    private void checkNativeCtxInitialized() {
        if (!this.isNativeCtxInitialized_) {
            String m1 = new Throwable().getStackTrace()[1].getMethodName();
            CefLog.Error("CefBrowser_N: %s: can't invoke native method '%s' before native context initialized", this, m1);
        }
    }

    protected void createBrowser(CefClientHandler clientHandler, long windowHandle, String url, boolean osr, boolean transparent, Component canvas) {
        if (this.isClosing_ || this.isClosed_ || this.isCreating_) {
            return;
        }
        if (this.getNativeRef("CefBrowser") == 0L && !this.isPending_) {
            this.isCreating_ = true;
            this.executeNative(() -> {
                try {
                    if (TRACE_LIFESPAN) {
                        CefLog.Debug("CefBrowser_N: %s: started native creation", this);
                    }
                    this.N_CreateBrowser(clientHandler, windowHandle, url, osr, transparent, canvas, this.request_context_);
                }
                catch (UnsatisfiedLinkError err) {
                    err.printStackTrace();
                }
            }, "createBrowser");
        }
    }

    private void notifyBrowserCreated() {
        this.isPending_ = true;
    }

    protected final void createDevTools(CefBrowser_N parent, CefClientHandler clientHandler, long windowHandle, boolean osr, boolean transparent, Component canvas, Point inspectAt) {
        if (this.getNativeRef("CefBrowser") == 0L && !this.isPending_) {
            this.executeNative(() -> {
                try {
                    this.isPending_ = this.N_CreateDevTools(parent, clientHandler, windowHandle, osr, transparent, canvas, inspectAt);
                }
                catch (UnsatisfiedLinkError err) {
                    err.printStackTrace();
                }
            }, "createDevTools");
        }
    }

    protected final long getWindowHandle(long surfaceHandle) {
        try {
            this.checkNativeCtxInitialized();
            if (this.isNativeCtxInitialized_) {
                return this.N_GetWindowHandle(surfaceHandle);
            }
        }
        catch (UnsatisfiedLinkError err) {
            err.printStackTrace();
        }
        return 0L;
    }

    protected void finalize() throws Throwable {
        this.close(true);
        super.finalize();
    }

    @Override
    public boolean canGoBack() {
        try {
            this.checkNativeCtxInitialized();
            if (this.isNativeCtxInitialized_) {
                return this.N_CanGoBack();
            }
        }
        catch (UnsatisfiedLinkError ule) {
            ule.printStackTrace();
        }
        return false;
    }

    @Override
    public void goBack() {
        try {
            this.checkNativeCtxInitialized();
            if (this.isNativeCtxInitialized_) {
                this.N_GoBack();
            }
        }
        catch (UnsatisfiedLinkError ule) {
            ule.printStackTrace();
        }
    }

    @Override
    public boolean canGoForward() {
        try {
            this.checkNativeCtxInitialized();
            if (this.isNativeCtxInitialized_) {
                return this.N_CanGoForward();
            }
        }
        catch (UnsatisfiedLinkError ule) {
            ule.printStackTrace();
        }
        return false;
    }

    @Override
    public void goForward() {
        try {
            this.checkNativeCtxInitialized();
            if (this.isNativeCtxInitialized_) {
                this.N_GoForward();
            }
        }
        catch (UnsatisfiedLinkError ule) {
            ule.printStackTrace();
        }
    }

    @Override
    public boolean isLoading() {
        try {
            this.checkNativeCtxInitialized();
            if (this.isNativeCtxInitialized_) {
                return this.N_IsLoading();
            }
        }
        catch (UnsatisfiedLinkError ule) {
            ule.printStackTrace();
        }
        return false;
    }

    @Override
    public void reload() {
        try {
            this.checkNativeCtxInitialized();
            if (this.isNativeCtxInitialized_) {
                this.N_Reload();
            }
        }
        catch (UnsatisfiedLinkError ule) {
            ule.printStackTrace();
        }
    }

    @Override
    public void reloadIgnoreCache() {
        try {
            this.checkNativeCtxInitialized();
            if (this.isNativeCtxInitialized_) {
                this.N_ReloadIgnoreCache();
            }
        }
        catch (UnsatisfiedLinkError ule) {
            ule.printStackTrace();
        }
    }

    @Override
    public void stopLoad() {
        try {
            this.checkNativeCtxInitialized();
            if (this.isNativeCtxInitialized_) {
                this.N_StopLoad();
            }
        }
        catch (UnsatisfiedLinkError ule) {
            ule.printStackTrace();
        }
    }

    @Override
    public int getIdentifier() {
        try {
            this.checkNativeCtxInitialized();
            if (this.isNativeCtxInitialized_) {
                return this.N_GetIdentifier();
            }
        }
        catch (UnsatisfiedLinkError ule) {
            ule.printStackTrace();
        }
        return -1;
    }

    @Override
    public CefFrame getMainFrame() {
        try {
            this.checkNativeCtxInitialized();
            if (this.isNativeCtxInitialized_) {
                return this.N_GetMainFrame();
            }
        }
        catch (UnsatisfiedLinkError ule) {
            ule.printStackTrace();
        }
        return null;
    }

    @Override
    public CefFrame getFocusedFrame() {
        try {
            this.checkNativeCtxInitialized();
            if (this.isNativeCtxInitialized_) {
                return this.N_GetFocusedFrame();
            }
        }
        catch (UnsatisfiedLinkError ule) {
            ule.printStackTrace();
        }
        return null;
    }

    @Override
    public CefFrame getFrame(long identifier) {
        try {
            this.checkNativeCtxInitialized();
            if (this.isNativeCtxInitialized_) {
                return this.N_GetFrame(identifier);
            }
        }
        catch (UnsatisfiedLinkError ule) {
            ule.printStackTrace();
        }
        return null;
    }

    @Override
    public CefFrame getFrame(String name) {
        try {
            this.checkNativeCtxInitialized();
            if (this.isNativeCtxInitialized_) {
                return this.N_GetFrame2(name);
            }
        }
        catch (UnsatisfiedLinkError ule) {
            ule.printStackTrace();
        }
        return null;
    }

    @Override
    public Vector<Long> getFrameIdentifiers() {
        try {
            this.checkNativeCtxInitialized();
            if (this.isNativeCtxInitialized_) {
                return this.N_GetFrameIdentifiers();
            }
        }
        catch (UnsatisfiedLinkError ule) {
            ule.printStackTrace();
        }
        return null;
    }

    @Override
    public Vector<String> getFrameNames() {
        try {
            this.checkNativeCtxInitialized();
            if (this.isNativeCtxInitialized_) {
                return this.N_GetFrameNames();
            }
        }
        catch (UnsatisfiedLinkError ule) {
            ule.printStackTrace();
        }
        return null;
    }

    @Override
    public int getFrameCount() {
        try {
            this.checkNativeCtxInitialized();
            if (this.isNativeCtxInitialized_) {
                return this.N_GetFrameCount();
            }
        }
        catch (UnsatisfiedLinkError ule) {
            ule.printStackTrace();
        }
        return -1;
    }

    @Override
    public boolean isPopup() {
        try {
            this.checkNativeCtxInitialized();
            if (this.isNativeCtxInitialized_) {
                return this.N_IsPopup();
            }
        }
        catch (UnsatisfiedLinkError ule) {
            ule.printStackTrace();
        }
        return false;
    }

    @Override
    public boolean hasDocument() {
        try {
            this.checkNativeCtxInitialized();
            if (this.isNativeCtxInitialized_) {
                return this.N_HasDocument();
            }
        }
        catch (UnsatisfiedLinkError ule) {
            ule.printStackTrace();
        }
        return false;
    }

    @Override
    public void viewSource() {
        try {
            this.checkNativeCtxInitialized();
            if (this.isNativeCtxInitialized_) {
                this.N_ViewSource();
            }
        }
        catch (UnsatisfiedLinkError ule) {
            ule.printStackTrace();
        }
    }

    @Override
    public void getSource(CefStringVisitor visitor) {
        try {
            this.checkNativeCtxInitialized();
            if (this.isNativeCtxInitialized_) {
                this.N_GetSource(visitor);
            }
        }
        catch (UnsatisfiedLinkError ule) {
            ule.printStackTrace();
        }
    }

    @Override
    public void getText(CefStringVisitor visitor) {
        try {
            this.checkNativeCtxInitialized();
            if (this.isNativeCtxInitialized_) {
                this.N_GetText(visitor);
            }
        }
        catch (UnsatisfiedLinkError ule) {
            ule.printStackTrace();
        }
    }

    @Override
    public void loadRequest(CefRequest request) {
        try {
            this.checkNativeCtxInitialized();
            if (this.isNativeCtxInitialized_) {
                this.N_LoadRequest(request);
            }
        }
        catch (UnsatisfiedLinkError ule) {
            ule.printStackTrace();
        }
    }

    @Override
    public void loadURL(String url) {
        try {
            this.checkNativeCtxInitialized();
            if (this.isNativeCtxInitialized_) {
                this.N_LoadURL(url);
            }
        }
        catch (UnsatisfiedLinkError ule) {
            ule.printStackTrace();
        }
    }

    @Override
    public void executeJavaScript(String code, String url, int line) {
        try {
            this.checkNativeCtxInitialized();
            if (this.isNativeCtxInitialized_) {
                this.N_ExecuteJavaScript(code, url, line);
            }
        }
        catch (UnsatisfiedLinkError ule) {
            ule.printStackTrace();
        }
    }

    @Override
    public String getURL() {
        try {
            this.checkNativeCtxInitialized();
            if (this.isNativeCtxInitialized_) {
                return this.N_GetURL();
            }
        }
        catch (UnsatisfiedLinkError ule) {
            ule.printStackTrace();
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close(final boolean force) {
        if (this.isClosing_ || this.isClosed_) {
            return;
        }
        if (force) {
            this.isClosing_ = true;
        }
        if (TRACE_LIFESPAN) {
            CefLog.Debug("CefBrowser_N: %s: close, force=%d", this.toString(), force ? 1 : 0);
        }
        List<Runnable> list = this.delayedActions_;
        synchronized (list) {
            this.delayedActions_.clear();
        }
        if (this.getNativeRef("CefBrowser") == 0L) {
            CefLog.Debug("CefBrowser_N: %s: native part of browser wasn't created yet, browser will be closed immediately after creation", this);
            if (this.client_ != null) {
                this.client_.addLifeSpanHandler(new CefLifeSpanHandlerAdapter(){

                    @Override
                    public void onAfterCreated(CefBrowser browser) {
                        if (browser == CefBrowser_N.this) {
                            CefLog.Debug("CefBrowser_N: %s: close browser (immediately after creation)", browser);
                            browser.close(force);
                        }
                    }
                });
            }
            return;
        }
        try {
            this.checkNativeCtxInitialized();
            if (this.isNativeCtxInitialized_) {
                this.N_Close(force);
            }
        }
        catch (UnsatisfiedLinkError ule) {
            ule.printStackTrace();
        }
    }

    @Override
    public void setFocus(boolean enable) {
        try {
            this.checkNativeCtxInitialized();
            if (this.isNativeCtxInitialized_) {
                this.N_SetFocus(enable);
            }
        }
        catch (UnsatisfiedLinkError ule) {
            ule.printStackTrace();
        }
    }

    @Override
    public void setWindowVisibility(boolean visible) {
        try {
            this.checkNativeCtxInitialized();
            if (this.isNativeCtxInitialized_) {
                this.N_SetWindowVisibility(visible);
            }
        }
        catch (UnsatisfiedLinkError ule) {
            ule.printStackTrace();
        }
    }

    @Override
    public double getZoomLevel() {
        try {
            this.checkNativeCtxInitialized();
            if (this.isNativeCtxInitialized_) {
                return this.N_GetZoomLevel();
            }
        }
        catch (UnsatisfiedLinkError ule) {
            ule.printStackTrace();
        }
        return 0.0;
    }

    @Override
    public void setZoomLevel(double zoomLevel) {
        try {
            this.checkNativeCtxInitialized();
            if (this.isNativeCtxInitialized_) {
                this.N_SetZoomLevel(zoomLevel);
            }
        }
        catch (UnsatisfiedLinkError ule) {
            ule.printStackTrace();
        }
    }

    @Override
    public void runFileDialog(CefDialogHandler.FileDialogMode mode, String title, String defaultFilePath, Vector<String> acceptFilters, CefRunFileDialogCallback callback) {
        try {
            this.checkNativeCtxInitialized();
            if (this.isNativeCtxInitialized_) {
                this.N_RunFileDialog(mode, title, defaultFilePath, acceptFilters, callback);
            }
        }
        catch (UnsatisfiedLinkError ule) {
            ule.printStackTrace();
        }
    }

    @Override
    public void startDownload(String url) {
        try {
            this.checkNativeCtxInitialized();
            if (this.isNativeCtxInitialized_) {
                this.N_StartDownload(url);
            }
        }
        catch (UnsatisfiedLinkError ule) {
            ule.printStackTrace();
        }
    }

    @Override
    public void print() {
        try {
            this.checkNativeCtxInitialized();
            if (this.isNativeCtxInitialized_) {
                this.N_Print();
            }
        }
        catch (UnsatisfiedLinkError ule) {
            ule.printStackTrace();
        }
    }

    @Override
    public void printToPDF(String path, CefPdfPrintSettings settings, CefPdfPrintCallback callback) {
        if (path == null || path.isEmpty()) {
            throw new IllegalArgumentException("path was null or empty");
        }
        try {
            this.checkNativeCtxInitialized();
            if (this.isNativeCtxInitialized_) {
                this.N_PrintToPDF(path, settings, callback);
            }
        }
        catch (UnsatisfiedLinkError ule) {
            ule.printStackTrace();
        }
    }

    @Override
    public void find(String searchText, boolean forward, boolean matchCase, boolean findNext) {
        try {
            this.checkNativeCtxInitialized();
            if (this.isNativeCtxInitialized_) {
                this.N_Find(searchText, forward, matchCase, findNext);
            }
        }
        catch (UnsatisfiedLinkError ule) {
            ule.printStackTrace();
        }
    }

    @Override
    public void stopFinding(boolean clearSelection) {
        try {
            this.checkNativeCtxInitialized();
            if (this.isNativeCtxInitialized_) {
                this.N_StopFinding(clearSelection);
            }
        }
        catch (UnsatisfiedLinkError ule) {
            ule.printStackTrace();
        }
    }

    protected final void closeDevTools() {
        try {
            this.checkNativeCtxInitialized();
            if (this.isNativeCtxInitialized_) {
                this.N_CloseDevTools();
            }
        }
        catch (UnsatisfiedLinkError ule) {
            ule.printStackTrace();
        }
    }

    @Override
    public void replaceMisspelling(String word) {
        try {
            this.checkNativeCtxInitialized();
            if (this.isNativeCtxInitialized_) {
                this.N_ReplaceMisspelling(word);
            }
        }
        catch (UnsatisfiedLinkError ule) {
            ule.printStackTrace();
        }
    }

    @Override
    public final void wasResized(int width, int height) {
        try {
            this.checkNativeCtxInitialized();
            if (this.isNativeCtxInitialized_) {
                this.N_WasResized(width, height);
            }
        }
        catch (UnsatisfiedLinkError ule) {
            ule.printStackTrace();
        }
    }

    @Override
    public void notifyScreenInfoChanged() {
        try {
            this.checkNativeCtxInitialized();
            if (this.isNativeCtxInitialized_) {
                this.N_NotifyScreenInfoChanged();
            }
        }
        catch (UnsatisfiedLinkError ule) {
            ule.printStackTrace();
        }
    }

    protected final void invalidate() {
        try {
            this.checkNativeCtxInitialized();
            if (this.isNativeCtxInitialized_) {
                this.N_Invalidate();
            }
        }
        catch (UnsatisfiedLinkError ule) {
            ule.printStackTrace();
        }
    }

    @Override
    public final void sendKeyEvent(KeyEvent e) {
        try {
            this.checkNativeCtxInitialized();
            if (this.isNativeCtxInitialized_) {
                this.N_SendKeyEvent(e);
            }
        }
        catch (UnsatisfiedLinkError ule) {
            ule.printStackTrace();
        }
    }

    @Override
    public final void sendMouseEvent(MouseEvent e) {
        try {
            this.checkNativeCtxInitialized();
            if (this.isNativeCtxInitialized_) {
                this.N_SendMouseEvent(e);
            }
        }
        catch (UnsatisfiedLinkError ule) {
            ule.printStackTrace();
        }
    }

    @Override
    public final void sendMouseWheelEvent(MouseWheelEvent e) {
        try {
            this.checkNativeCtxInitialized();
            if (this.isNativeCtxInitialized_) {
                this.N_SendMouseWheelEvent(e);
            }
        }
        catch (UnsatisfiedLinkError ule) {
            ule.printStackTrace();
        }
    }

    @Override
    public void sendTouchEvent(CefTouchEvent e) {
        try {
            this.N_SendTouchEvent(e);
        }
        catch (UnsatisfiedLinkError ule) {
            ule.printStackTrace();
        }
    }

    protected final void dragTargetDragEnter(CefDragData dragData, Point pos, int modifiers, int allowedOps) {
        try {
            this.checkNativeCtxInitialized();
            if (this.isNativeCtxInitialized_) {
                this.N_DragTargetDragEnter(dragData, pos, modifiers, allowedOps);
            }
        }
        catch (UnsatisfiedLinkError ule) {
            ule.printStackTrace();
        }
    }

    protected final void dragTargetDragOver(Point pos, int modifiers, int allowedOps) {
        try {
            this.checkNativeCtxInitialized();
            if (this.isNativeCtxInitialized_) {
                this.N_DragTargetDragOver(pos, modifiers, allowedOps);
            }
        }
        catch (UnsatisfiedLinkError ule) {
            ule.printStackTrace();
        }
    }

    protected final void dragTargetDragLeave() {
        try {
            this.checkNativeCtxInitialized();
            if (this.isNativeCtxInitialized_) {
                this.N_DragTargetDragLeave();
            }
        }
        catch (UnsatisfiedLinkError ule) {
            ule.printStackTrace();
        }
    }

    protected final void dragTargetDrop(Point pos, int modifiers) {
        try {
            this.checkNativeCtxInitialized();
            if (this.isNativeCtxInitialized_) {
                this.N_DragTargetDrop(pos, modifiers);
            }
        }
        catch (UnsatisfiedLinkError ule) {
            ule.printStackTrace();
        }
    }

    protected final void dragSourceEndedAt(Point pos, int operation) {
        try {
            this.checkNativeCtxInitialized();
            if (this.isNativeCtxInitialized_) {
                this.N_DragSourceEndedAt(pos, operation);
            }
        }
        catch (UnsatisfiedLinkError ule) {
            ule.printStackTrace();
        }
    }

    protected final void dragSourceSystemDragEnded() {
        try {
            this.checkNativeCtxInitialized();
            if (this.isNativeCtxInitialized_) {
                this.N_DragSourceSystemDragEnded();
            }
        }
        catch (UnsatisfiedLinkError ule) {
            ule.printStackTrace();
        }
    }

    protected final void updateUI(Rectangle contentRect, Rectangle browserRect) {
        try {
            this.checkNativeCtxInitialized();
            if (this.isNativeCtxInitialized_) {
                this.N_UpdateUI(contentRect, browserRect);
            }
        }
        catch (UnsatisfiedLinkError ule) {
            ule.printStackTrace();
        }
    }

    protected final void setParent(long windowHandle, Component canvas) {
        if (this.isClosing_ || this.isClosed_) {
            return;
        }
        try {
            this.checkNativeCtxInitialized();
            if (this.isNativeCtxInitialized_) {
                this.N_SetParent(windowHandle, canvas);
            }
        }
        catch (UnsatisfiedLinkError ule) {
            ule.printStackTrace();
        }
    }

    protected final void notifyMoveOrResizeStarted() {
        try {
            this.checkNativeCtxInitialized();
            if (this.isNativeCtxInitialized_) {
                this.N_NotifyMoveOrResizeStarted();
            }
        }
        catch (UnsatisfiedLinkError ule) {
            ule.printStackTrace();
        }
    }

    @Override
    public final void ImeSetComposition(String text, List<CefCompositionUnderline> underlines, CefRange replacementRange, CefRange selectionRange) {
        try {
            this.checkNativeCtxInitialized();
            if (this.isNativeCtxInitialized_) {
                this.N_ImeSetComposition(text, underlines, replacementRange, selectionRange);
            }
        }
        catch (UnsatisfiedLinkError ule) {
            ule.printStackTrace();
        }
    }

    @Override
    public final void ImeCommitText(String text, CefRange replacementRange, int relativeCursorPos) {
        try {
            this.checkNativeCtxInitialized();
            if (this.isNativeCtxInitialized_) {
                this.N_ImeCommitText(text, replacementRange, relativeCursorPos);
            }
        }
        catch (UnsatisfiedLinkError ule) {
            ule.printStackTrace();
        }
    }

    @Override
    public final void ImeFinishComposingText(boolean keepSelection) {
        try {
            this.checkNativeCtxInitialized();
            if (this.isNativeCtxInitialized_) {
                this.N_ImeFinishComposingText(keepSelection);
            }
        }
        catch (UnsatisfiedLinkError ule) {
            ule.printStackTrace();
        }
    }

    @Override
    public final void ImeCancelComposing() {
        try {
            this.checkNativeCtxInitialized();
            if (this.isNativeCtxInitialized_) {
                this.N_ImeCancelComposing();
            }
        }
        catch (UnsatisfiedLinkError ule) {
            ule.printStackTrace();
        }
    }

    private final native boolean N_CreateBrowser(CefClientHandler var1, long var2, String var4, boolean var5, boolean var6, Component var7, CefRequestContext var8);

    private final native boolean N_CreateDevTools(CefBrowser var1, CefClientHandler var2, long var3, boolean var5, boolean var6, Component var7, Point var8);

    private final native long N_GetWindowHandle(long var1);

    private final native boolean N_CanGoBack();

    private final native void N_GoBack();

    private final native boolean N_CanGoForward();

    private final native void N_GoForward();

    private final native boolean N_IsLoading();

    private final native void N_Reload();

    private final native void N_ReloadIgnoreCache();

    private final native void N_StopLoad();

    private final native int N_GetIdentifier();

    private final native CefFrame N_GetMainFrame();

    private final native CefFrame N_GetFocusedFrame();

    private final native CefFrame N_GetFrame(long var1);

    private final native CefFrame N_GetFrame2(String var1);

    private final native Vector<Long> N_GetFrameIdentifiers();

    private final native Vector<String> N_GetFrameNames();

    private final native int N_GetFrameCount();

    private final native boolean N_IsPopup();

    private final native boolean N_HasDocument();

    private final native void N_ViewSource();

    private final native void N_GetSource(CefStringVisitor var1);

    private final native void N_GetText(CefStringVisitor var1);

    private final native void N_LoadRequest(CefRequest var1);

    private final native void N_LoadURL(String var1);

    private final native void N_ExecuteJavaScript(String var1, String var2, int var3);

    private final native String N_GetURL();

    private final native void N_Close(boolean var1);

    private final native void N_SetFocus(boolean var1);

    private final native void N_SetWindowVisibility(boolean var1);

    private final native double N_GetZoomLevel();

    private final native void N_SetZoomLevel(double var1);

    private final native void N_RunFileDialog(CefDialogHandler.FileDialogMode var1, String var2, String var3, Vector<String> var4, CefRunFileDialogCallback var5);

    private final native void N_StartDownload(String var1);

    private final native void N_Print();

    private final native void N_PrintToPDF(String var1, CefPdfPrintSettings var2, CefPdfPrintCallback var3);

    private final native void N_Find(String var1, boolean var2, boolean var3, boolean var4);

    private final native void N_StopFinding(boolean var1);

    private final native void N_CloseDevTools();

    private final native void N_ReplaceMisspelling(String var1);

    private final native void N_WasResized(int var1, int var2);

    private final native void N_Invalidate();

    private final native void N_NotifyScreenInfoChanged();

    private final native void N_SendKeyEvent(KeyEvent var1);

    private final native void N_SendTouchEvent(CefTouchEvent var1);

    private final native void N_SendMouseEvent(MouseEvent var1);

    private final native void N_SendMouseWheelEvent(MouseWheelEvent var1);

    private final native void N_DragTargetDragEnter(CefDragData var1, Point var2, int var3, int var4);

    private final native void N_DragTargetDragOver(Point var1, int var2, int var3);

    private final native void N_DragTargetDragLeave();

    private final native void N_DragTargetDrop(Point var1, int var2);

    private final native void N_DragSourceEndedAt(Point var1, int var2);

    private final native void N_DragSourceSystemDragEnded();

    private final native void N_UpdateUI(Rectangle var1, Rectangle var2);

    private final native void N_SetParent(long var1, Component var3);

    private final native void N_NotifyMoveOrResizeStarted();

    private final native void N_ImeSetComposition(String var1, List<CefCompositionUnderline> var2, CefRange var3, CefRange var4);

    private final native void N_ImeCommitText(String var1, CefRange var2, int var3);

    private final native void N_ImeFinishComposingText(boolean var1);

    private final native void N_ImeCancelComposing();
}

