/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.hash4j.distinctcount;

class DistinctCountUtil {
    private DistinctCountUtil() {
    }

    static boolean isUnsignedPowerOfTwo(int x) {
        return (x & x - 1) == 0;
    }

    static void checkPrecisionParameter(int p, int minP, int maxP) {
        if (p < minP || p > maxP) {
            throw new IllegalArgumentException("illegal precision parameter");
        }
    }

    static double solveMaximumLikelihoodEquation(double a, int[] b, double relativeErrorLimit) {
        int kMax;
        if (a == 0.0) {
            return Double.POSITIVE_INFINITY;
        }
        for (kMax = b.length - 1; kMax >= 0 && b[kMax] == 0; --kMax) {
        }
        if (kMax < 0) {
            return 0.0;
        }
        int kMin = kMax;
        int t = b[kMax];
        long s1 = t;
        double s2 = Double.longBitsToDouble(Double.doubleToRawLongBits(t) + ((long)kMax << 52));
        for (int k = kMax - 1; k >= 0; --k) {
            t = b[k];
            if (t <= 0) continue;
            s1 += (long)t;
            s2 += Double.longBitsToDouble(Double.doubleToRawLongBits(t) + ((long)k << 52));
            kMin = k;
        }
        double gPrevious = 0.0;
        double x = s2 <= 1.5 * a ? (double)s1 / (0.5 * s2 + a) : Math.log1p(s2 / a) * ((double)s1 / s2);
        double deltaX = x;
        while (deltaX > x * relativeErrorLimit) {
            int kappa = Math.getExponent(x) + 2;
            double xPrime = Double.longBitsToDouble(Double.doubleToRawLongBits(x) - ((long)Math.max(kMax, kappa) + 1L << 52));
            double xPrime2 = xPrime * xPrime;
            double h = xPrime + xPrime2 * (-0.3333333333333333 + xPrime2 * (0.022222222222222223 - xPrime2 * 0.0021164021164021165));
            for (int k = kappa - 1; k >= kMax; --k) {
                double hPrime = 1.0 - h;
                h = (xPrime + h * hPrime) / (xPrime + hPrime);
                xPrime += xPrime;
            }
            double g = (double)b[kMax] * h;
            for (int k = kMax - 1; k >= kMin; --k) {
                double hPrime = 1.0 - h;
                h = (xPrime + h * hPrime) / (xPrime + hPrime);
                xPrime += xPrime;
                g += (double)b[k] * h;
            }
            deltaX = gPrevious < (g += x * a) && g <= (double)s1 ? (deltaX *= (g - (double)s1) / (gPrevious - g)) : 0.0;
            x += deltaX;
            gPrevious = g;
        }
        return x;
    }
}

