/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.hash4j.hashing;

import com.dynatrace.hash4j.hashing.AbstractHashStream64;
import com.dynatrace.hash4j.hashing.AbstractHasher;
import com.dynatrace.hash4j.hashing.AbstractHasher64;
import com.dynatrace.hash4j.hashing.HashStream64;
import com.dynatrace.hash4j.hashing.Hasher64;

class FarmHashNa
extends AbstractHasher64 {
    private static final long K0 = -4348849565147123417L;
    private static final long K1 = -5435081209227447693L;
    protected static final long K2 = -7286425919675154353L;
    private static final long K_MUL = -7070675565921424023L;
    private static final long SEED = 81L;
    private static final long START_X = 95310865018149119L;
    private static final long START_Y = 2480279821605975764L;
    private static final long START_Z = FarmHashNa.shiftMix(-7956866745689871395L) * -7286425919675154353L;
    private static final FarmHashNa INSTANCE = new FarmHashNa();

    FarmHashNa() {
    }

    protected long finalizeHash(long hash) {
        return hash;
    }

    static Hasher64 create() {
        return INSTANCE;
    }

    static Hasher64 create(final long seed) {
        return new FarmHashNa(){

            @Override
            protected long finalizeHash(long hash) {
                return 1.hashLen16(hash - -7286425919675154353L, seed);
            }
        };
    }

    static Hasher64 create(final long seed0, final long seed1) {
        return new FarmHashNa(){

            @Override
            protected long finalizeHash(long hash) {
                return 2.hashLen16(hash - seed0, seed1);
            }
        };
    }

    private static long shiftMix(long val) {
        return val ^ val >>> 47;
    }

    private static long hashLen16(long u, long v, long mul) {
        long a = FarmHashNa.shiftMix((u ^ v) * mul);
        return FarmHashNa.shiftMix((v ^ a) * mul) * mul;
    }

    private static long mul(int bufferCount) {
        return -7286425919675154369L + (long)(bufferCount << 1);
    }

    private static long hash1To3Bytes(int bufferCount, int firstByte, int midOrLastByte, int lastByte) {
        int y = firstByte + (midOrLastByte << 8);
        int z = bufferCount - 8 + (lastByte << 2);
        return FarmHashNa.shiftMix((long)y * -7286425919675154353L ^ (long)z * -4348849565147123417L) * -7286425919675154353L;
    }

    private static long hash4To7Bytes(int bufferCount, long first4Bytes, long last4Bytes) {
        long mul = FarmHashNa.mul(bufferCount);
        return FarmHashNa.hashLen16((long)(bufferCount - 8) + (first4Bytes << 3), last4Bytes, mul);
    }

    private static long hash8To16Bytes(int bufferCount, long first8Bytes, long last8Bytes) {
        long mul = FarmHashNa.mul(bufferCount);
        long a = first8Bytes + -7286425919675154353L;
        long c = Long.rotateRight(last8Bytes, 37) * mul + a;
        long d = (Long.rotateRight(a, 25) + last8Bytes) * mul;
        return FarmHashNa.hashLen16(c, d, mul);
    }

    protected static long hashLen16(long u, long v) {
        return FarmHashNa.hashLen16(u, v, -7070675565921424023L);
    }

    @Override
    public HashStream64 hashStream() {
        return new HashStreamImpl();
    }

    @Override
    public long hashBytesToLong(byte[] input, int off, int len) {
        long r = len <= 32 ? (len <= 16 ? FarmHashNa.hashBytesToLongLength0to16(input, off, len) : FarmHashNa.hashBytesToLongLength17to32(input, off, len)) : (len <= 64 ? FarmHashNa.hashBytesToLongLength33To64(input, off, len) : FarmHashNa.hashBytesToLongLength65Plus(input, off, len));
        return this.finalizeHash(r);
    }

    private static long hashBytesToLongLength0to16(byte[] bytes, int offset, int length) {
        if (length >= 8) {
            long mul = -7286425919675154353L + (long)(length << 1);
            long a = FarmHashNa.getLong(bytes, offset) + -7286425919675154353L;
            long b = FarmHashNa.getLong(bytes, offset + length - 8);
            long c = Long.rotateRight(b, 37) * mul + a;
            long d = (Long.rotateRight(a, 25) + b) * mul;
            return FarmHashNa.hashLength16(c, d, mul);
        }
        if (length >= 4) {
            long mul = -7286425919675154353L + (long)(length << 1);
            long a = (long)FarmHashNa.getInt(bytes, offset) & 0xFFFFFFFFL;
            return FarmHashNa.hashLength16((long)length + (a << 3), (long)FarmHashNa.getInt(bytes, offset + length - 4) & 0xFFFFFFFFL, mul);
        }
        if (length > 0) {
            byte a = bytes[offset];
            byte b = bytes[offset + (length >> 1)];
            byte c = bytes[offset + (length - 1)];
            int y = (a & 0xFF) + ((b & 0xFF) << 8);
            int z = length + ((c & 0xFF) << 2);
            return FarmHashNa.shiftMix((long)y * -7286425919675154353L ^ (long)z * -4348849565147123417L) * -7286425919675154353L;
        }
        return -7286425919675154353L;
    }

    private static long hashCharsToLongLength0to8(CharSequence input) {
        int len = input.length();
        if (len >= 4) {
            long mul = -7286425919675154353L + (long)(len << 2);
            long b = FarmHashNa.getLong(input, 0);
            long a = b + -7286425919675154353L;
            if (len >= 5) {
                b >>>= 16;
                b |= (long)input.charAt(4) << 48;
                if (len >= 6) {
                    b >>>= 16;
                    b |= (long)input.charAt(5) << 48;
                    if (len >= 7) {
                        b >>>= 16;
                        b |= (long)input.charAt(6) << 48;
                        if (len >= 8) {
                            b >>>= 16;
                            b |= (long)input.charAt(7) << 48;
                        }
                    }
                }
            }
            long c = Long.rotateRight(b, 37) * mul + a;
            long d = (Long.rotateRight(a, 25) + b) * mul;
            return FarmHashNa.hashLength16(c, d, mul);
        }
        if (len >= 2) {
            long a;
            long mul = -7286425919675154353L + (long)(len << 2);
            long b = a = (long)FarmHashNa.getInt(input, 0) & 0xFFFFFFFFL;
            if (len >= 3) {
                b >>>= 16;
                b |= (long)input.charAt(2) << 16;
            }
            return FarmHashNa.hashLength16((long)(len << 1) + (a << 3), b, mul);
        }
        if (len >= 1) {
            char y = input.charAt(0);
            int z = (len << 1) + (y >>> 8 << 2);
            return FarmHashNa.shiftMix((long)y * -7286425919675154353L ^ (long)z * -4348849565147123417L) * -7286425919675154353L;
        }
        return -7286425919675154353L;
    }

    private static long hashBytesToLongLength17to32(byte[] bytes, int offset, int length) {
        long mul = -7286425919675154353L + (long)(length << 1);
        long a = FarmHashNa.getLong(bytes, offset) * -5435081209227447693L;
        long b = FarmHashNa.getLong(bytes, offset + 8);
        long c = FarmHashNa.getLong(bytes, offset + length - 8) * mul;
        long d = FarmHashNa.getLong(bytes, offset + length - 16) * -7286425919675154353L;
        return FarmHashNa.hashLength16(Long.rotateRight(a + b, 43) + Long.rotateRight(c, 30) + d, a + Long.rotateRight(b + -7286425919675154353L, 18) + c, mul);
    }

    private static long hashCharsToLongLength9to16(CharSequence input) {
        int len = input.length();
        long mul = -7286425919675154353L + (long)(len << 2);
        long a = FarmHashNa.getLong(input, 0) * -5435081209227447693L;
        long b = FarmHashNa.getLong(input, 4);
        long c = FarmHashNa.getLong(input, len - 4) * mul;
        long d = FarmHashNa.getLong(input, len - 8) * -7286425919675154353L;
        return FarmHashNa.hashLength16(Long.rotateRight(a + b, 43) + Long.rotateRight(c, 30) + d, a + Long.rotateRight(b + -7286425919675154353L, 18) + c, mul);
    }

    private static long hashBytesToLongLength33To64(byte[] bytes, int offset, int length) {
        long mul = -7286425919675154353L + (long)(length << 1);
        long a = FarmHashNa.getLong(bytes, offset) * -7286425919675154353L;
        long b = FarmHashNa.getLong(bytes, offset + 8);
        long c = FarmHashNa.getLong(bytes, offset + length - 8) * mul;
        long d = FarmHashNa.getLong(bytes, offset + length - 16) * -7286425919675154353L;
        long y = Long.rotateRight(a + b, 43) + Long.rotateRight(c, 30) + d;
        long z = FarmHashNa.hashLength16(y, a + Long.rotateRight(b + -7286425919675154353L, 18) + c, mul);
        long e = FarmHashNa.getLong(bytes, offset + 16) * mul;
        long f = FarmHashNa.getLong(bytes, offset + 24);
        long g = (y + FarmHashNa.getLong(bytes, offset + length - 32)) * mul;
        long h = (z + FarmHashNa.getLong(bytes, offset + length - 24)) * mul;
        return FarmHashNa.hashLength16(Long.rotateRight(e + f, 43) + Long.rotateRight(g, 30) + h, e + Long.rotateRight(f + a, 18) + g, mul);
    }

    private static long hashCharsToLongLength17To32(CharSequence input) {
        int len = input.length();
        long mul = -7286425919675154353L + (long)(len << 2);
        long a = FarmHashNa.getLong(input, 0) * -7286425919675154353L;
        long b = FarmHashNa.getLong(input, 4);
        long c = FarmHashNa.getLong(input, len - 4) * mul;
        long d = FarmHashNa.getLong(input, len - 8) * -7286425919675154353L;
        long y = Long.rotateRight(a + b, 43) + Long.rotateRight(c, 30) + d;
        long z = FarmHashNa.hashLength16(y, a + Long.rotateRight(b + -7286425919675154353L, 18) + c, mul);
        long e = FarmHashNa.getLong(input, 8) * mul;
        long f = FarmHashNa.getLong(input, 12);
        long g = (y + FarmHashNa.getLong(input, len - 16)) * mul;
        long h = (z + FarmHashNa.getLong(input, len - 12)) * mul;
        return FarmHashNa.hashLength16(Long.rotateRight(e + f, 43) + Long.rotateRight(g, 30) + h, e + Long.rotateRight(f + a, 18) + g, mul);
    }

    private static long hashBytesToLongLength65Plus(byte[] bytes, int offset, int length) {
        long q;
        long a1;
        long c;
        long b7;
        long b6;
        long b5;
        long b4;
        long b3;
        long b2;
        long b1;
        long b0;
        int seed = 81;
        long x = seed;
        long y = (long)seed * -5435081209227447693L + 113L;
        long z = FarmHashNa.shiftMix(y * -7286425919675154353L + 113L) * -7286425919675154353L;
        long v1 = 0L;
        long v2 = 0L;
        long w1 = 0L;
        long w2 = 0L;
        int end = offset + (length - 1 & 0xFFFFFFC0);
        int last64offset = offset + length - 64;
        x = x * -7286425919675154353L + FarmHashNa.getLong(bytes, offset);
        do {
            b0 = FarmHashNa.getLong(bytes, offset);
            b1 = FarmHashNa.getLong(bytes, offset + 8);
            b2 = FarmHashNa.getLong(bytes, offset + 16);
            b3 = FarmHashNa.getLong(bytes, offset + 24);
            b4 = FarmHashNa.getLong(bytes, offset + 32);
            b5 = FarmHashNa.getLong(bytes, offset + 40);
            b6 = FarmHashNa.getLong(bytes, offset + 48);
            b7 = FarmHashNa.getLong(bytes, offset + 56);
            x = Long.rotateRight(x + y + v1 + b1, 37) * -5435081209227447693L;
            y = Long.rotateRight(y + v2 + b6, 42) * -5435081209227447693L;
            y += v1 + b5;
            z = Long.rotateRight(z + w1, 33) * -5435081209227447693L;
            long a = v2 * -5435081209227447693L;
            long b = (x ^= w2) + w1;
            long z1 = b3;
            b = Long.rotateRight(b + (a += b0) + z1, 21);
            c = a;
            a += b1;
            v1 = a + z1;
            v2 = (b += Long.rotateRight(a += b2, 44)) + c;
            a1 = z + w2;
            q = y + b2;
            long z2 = b7;
            q = Long.rotateRight(q + (a1 += b4) + z2, 21);
            long c1 = a1;
            a1 += b5;
            w1 = a1 + z2;
            w2 = (q += Long.rotateRight(a1 += b6, 44)) + c1;
            long t = z;
            z = x;
            x = t;
        } while ((offset += 64) != end);
        b0 = FarmHashNa.getLong(bytes, last64offset);
        b1 = FarmHashNa.getLong(bytes, last64offset + 8);
        b2 = FarmHashNa.getLong(bytes, last64offset + 16);
        b3 = FarmHashNa.getLong(bytes, last64offset + 24);
        b4 = FarmHashNa.getLong(bytes, last64offset + 32);
        b5 = FarmHashNa.getLong(bytes, last64offset + 40);
        b6 = FarmHashNa.getLong(bytes, last64offset + 48);
        b7 = FarmHashNa.getLong(bytes, last64offset + 56);
        long mul = -5435081209227447693L + ((z & 0xFFL) << 1);
        x = Long.rotateRight(x + y + (v1 += (w1 += (long)(length - 1 & 0x3F))) + b1, 37) * mul;
        y = Long.rotateRight(y + v2 + b6, 42) * mul;
        y += v1 * 9L + b5;
        z = Long.rotateRight(z + (w1 += v1), 33) * mul;
        long a = v2 * mul;
        long b = (x ^= w2 * 9L) + w1;
        b = Long.rotateRight(b + (a += b0) + b3, 21);
        c = a;
        a += b1;
        b += Long.rotateRight(a += b2, 44);
        v1 = a + b3;
        a1 = z + w2;
        q = y + b2;
        q = Long.rotateRight(q + (a1 += b4) + b7, 21);
        long c1 = a1;
        a1 += b5;
        return FarmHashNa.hashLen16(FarmHashNa.hashLen16(v1, a1 + b7, mul) + FarmHashNa.shiftMix(y) * -4348849565147123417L + x, FarmHashNa.hashLen16(b + c, (q += Long.rotateRight(a1 += b6, 44)) + c1, mul) + z, mul);
    }

    private static long hashCharsToLongLength33Plus(CharSequence input) {
        long q;
        long a1;
        long c;
        long b7;
        long b6;
        long b5;
        long b4;
        long b3;
        long b2;
        long b1;
        long b0;
        int len = input.length();
        int seed = 81;
        long x = seed;
        long y = (long)seed * -5435081209227447693L + 113L;
        long z = FarmHashNa.shiftMix(y * -7286425919675154353L + 113L) * -7286425919675154353L;
        long v1 = 0L;
        long v2 = 0L;
        long w1 = 0L;
        long w2 = 0L;
        int end = len - 1 & 0xFFFFFFE0;
        int last64offset = len - 32;
        x = x * -7286425919675154353L + FarmHashNa.getLong(input, 0);
        int offset = 0;
        do {
            b0 = FarmHashNa.getLong(input, offset + 0);
            b1 = FarmHashNa.getLong(input, offset + 4);
            b2 = FarmHashNa.getLong(input, offset + 8);
            b3 = FarmHashNa.getLong(input, offset + 12);
            b4 = FarmHashNa.getLong(input, offset + 16);
            b5 = FarmHashNa.getLong(input, offset + 20);
            b6 = FarmHashNa.getLong(input, offset + 24);
            b7 = FarmHashNa.getLong(input, offset + 28);
            x = Long.rotateRight(x + y + v1 + b1, 37) * -5435081209227447693L;
            y = Long.rotateRight(y + v2 + b6, 42) * -5435081209227447693L;
            y += v1 + b5;
            z = Long.rotateRight(z + w1, 33) * -5435081209227447693L;
            long a = v2 * -5435081209227447693L;
            long b = (x ^= w2) + w1;
            long z1 = b3;
            b = Long.rotateRight(b + (a += b0) + z1, 21);
            c = a;
            a += b1;
            v1 = a + z1;
            v2 = (b += Long.rotateRight(a += b2, 44)) + c;
            a1 = z + w2;
            q = y + b2;
            long z2 = b7;
            q = Long.rotateRight(q + (a1 += b4) + z2, 21);
            long c1 = a1;
            a1 += b5;
            w1 = a1 + z2;
            w2 = (q += Long.rotateRight(a1 += b6, 44)) + c1;
            long t = z;
            z = x;
            x = t;
        } while ((offset += 32) != end);
        b0 = FarmHashNa.getLong(input, last64offset);
        b1 = FarmHashNa.getLong(input, last64offset + 4);
        b2 = FarmHashNa.getLong(input, last64offset + 8);
        b3 = FarmHashNa.getLong(input, last64offset + 12);
        b4 = FarmHashNa.getLong(input, last64offset + 16);
        b5 = FarmHashNa.getLong(input, last64offset + 20);
        b6 = FarmHashNa.getLong(input, last64offset + 24);
        b7 = FarmHashNa.getLong(input, last64offset + 28);
        long mul = -5435081209227447693L + ((z & 0xFFL) << 1);
        x = Long.rotateRight(x + y + (v1 += (w1 += (long)((len << 1) - 1 & 0x3F))) + b1, 37) * mul;
        y = Long.rotateRight(y + v2 + b6, 42) * mul;
        y += v1 * 9L + b5;
        z = Long.rotateRight(z + (w1 += v1), 33) * mul;
        long a = v2 * mul;
        long b = (x ^= w2 * 9L) + w1;
        b = Long.rotateRight(b + (a += b0) + b3, 21);
        c = a;
        a += b1;
        b += Long.rotateRight(a += b2, 44);
        v1 = a + b3;
        a1 = z + w2;
        q = y + b2;
        q = Long.rotateRight(q + (a1 += b4) + b7, 21);
        long c1 = a1;
        a1 += b5;
        return FarmHashNa.hashLen16(FarmHashNa.hashLen16(v1, a1 + b7, mul) + FarmHashNa.shiftMix(y) * -4348849565147123417L + x, FarmHashNa.hashLen16(b + c, (q += Long.rotateRight(a1 += b6, 44)) + c1, mul) + z, mul);
    }

    private static long hashLength16(long u, long v, long mul) {
        long a = (u ^ v) * mul;
        a ^= a >>> 47;
        long b = (v ^ a) * mul;
        b ^= b >>> 47;
        return b *= mul;
    }

    @Override
    public long hashCharsToLong(CharSequence input) {
        long len = input.length();
        long r = len <= 16L ? (len <= 8L ? FarmHashNa.hashCharsToLongLength0to8(input) : FarmHashNa.hashCharsToLongLength9to16(input)) : (len <= 32L ? FarmHashNa.hashCharsToLongLength17To32(input) : FarmHashNa.hashCharsToLongLength33Plus(input));
        return this.finalizeHash(r);
    }

    @Override
    public long hashLongLongToLong(long v1, long v2) {
        long mul = -7286425919675154321L;
        long a = v1 + -7286425919675154353L;
        return this.finalizeHash(FarmHashNa.hashLength16(Long.rotateRight(v2, 37) * mul + a, (Long.rotateRight(a, 25) + v2) * mul, mul));
    }

    @Override
    public long hashLongLongLongToLong(long v1, long v2, long v3) {
        long mul = -7286425919675154305L;
        long a = v1 * -5435081209227447693L;
        long c = v3 * mul;
        return this.finalizeHash(FarmHashNa.hashLength16(Long.rotateRight(a + v2, 43) + Long.rotateRight(c, 30) + v2 * -7286425919675154353L, a + Long.rotateRight(v2 + -7286425919675154353L, 18) + c, mul));
    }

    private class HashStreamImpl
    extends AbstractHashStream64 {
        private long x = 95310865018149119L;
        private long y = 2480279821605975764L;
        private long z = START_Z;
        private long v1 = 0L;
        private long v2 = 0L;
        private long w1 = 0L;
        private long w2 = 0L;
        private final byte[] buffer = new byte[80];
        private int bufferCount = 8;
        private boolean init = true;

        private HashStreamImpl() {
        }

        @Override
        public HashStream64 putByte(byte v) {
            this.buffer[this.bufferCount] = v;
            if (this.bufferCount >= 72) {
                this.processBuffer();
                this.bufferCount = 8;
                this.buffer[8] = v;
            }
            ++this.bufferCount;
            return this;
        }

        @Override
        public HashStream64 putShort(short v) {
            AbstractHasher.setShort(this.buffer, this.bufferCount, v);
            if (this.bufferCount >= 71) {
                this.processBuffer();
                this.bufferCount -= 64;
                AbstractHasher.setShort(this.buffer, this.bufferCount, v);
            }
            this.bufferCount += 2;
            return this;
        }

        @Override
        public HashStream64 putInt(int v) {
            AbstractHasher.setInt(this.buffer, this.bufferCount, v);
            if (this.bufferCount >= 69) {
                this.processBuffer();
                this.bufferCount -= 64;
                AbstractHasher.setInt(this.buffer, this.bufferCount, v);
            }
            this.bufferCount += 4;
            return this;
        }

        @Override
        public HashStream64 putLong(long v) {
            AbstractHasher.setLong(this.buffer, this.bufferCount, v);
            if (this.bufferCount >= 65) {
                this.processBuffer();
                this.bufferCount -= 64;
                AbstractHasher.setLong(this.buffer, this.bufferCount, v);
            }
            this.bufferCount += 8;
            return this;
        }

        @Override
        public HashStream64 reset() {
            this.x = 95310865018149119L;
            this.y = 2480279821605975764L;
            this.z = START_Z;
            this.v1 = 0L;
            this.v2 = 0L;
            this.w1 = 0L;
            this.w2 = 0L;
            this.bufferCount = 8;
            this.init = true;
            return this;
        }

        @Override
        public HashStream64 putBytes(byte[] b, int off, int len) {
            int regularBlockStartIdx = 8 - this.bufferCount & 0x3F;
            int regularBlockEndIdx = len - 64 + (-len + regularBlockStartIdx & 0x3F);
            if (regularBlockEndIdx < regularBlockStartIdx) {
                System.arraycopy(b, off, this.buffer, this.bufferCount, len);
                this.bufferCount += len;
                return this;
            }
            System.arraycopy(b, off, this.buffer, this.bufferCount, regularBlockStartIdx);
            if (this.bufferCount > 8) {
                long b0 = AbstractHasher.getLong(this.buffer, 8);
                long b1 = AbstractHasher.getLong(this.buffer, 16);
                long b2 = AbstractHasher.getLong(this.buffer, 24);
                long b3 = AbstractHasher.getLong(this.buffer, 32);
                long b4 = AbstractHasher.getLong(this.buffer, 40);
                long b5 = AbstractHasher.getLong(this.buffer, 48);
                long b6 = AbstractHasher.getLong(this.buffer, 56);
                long b7 = AbstractHasher.getLong(this.buffer, 64);
                if (this.init) {
                    this.x += b0;
                    this.init = false;
                }
                this.processBufferWithoutInit(b0, b1, b2, b3, b4, b5, b6, b7);
            }
            int remainingBytes = len - regularBlockEndIdx;
            if (regularBlockEndIdx > regularBlockStartIdx) {
                if (this.init) {
                    this.x += AbstractHasher.getLong(b, off + regularBlockStartIdx);
                    this.init = false;
                }
                for (int i = off + regularBlockStartIdx; i < off + regularBlockEndIdx; i += 64) {
                    long b0 = AbstractHasher.getLong(b, i);
                    long b1 = AbstractHasher.getLong(b, i + 8);
                    long b2 = AbstractHasher.getLong(b, i + 16);
                    long b3 = AbstractHasher.getLong(b, i + 24);
                    long b4 = AbstractHasher.getLong(b, i + 32);
                    long b5 = AbstractHasher.getLong(b, i + 40);
                    long b6 = AbstractHasher.getLong(b, i + 48);
                    long b7 = AbstractHasher.getLong(b, i + 56);
                    this.processBufferWithoutInit(b0, b1, b2, b3, b4, b5, b6, b7);
                }
                System.arraycopy(b, off - 64 + len, this.buffer, 8 + remainingBytes, 64 - remainingBytes);
            }
            System.arraycopy(b, off + regularBlockEndIdx, this.buffer, 8, remainingBytes);
            this.bufferCount = 8 + remainingBytes;
            return this;
        }

        private void processBuffer() {
            long b0 = AbstractHasher.getLong(this.buffer, 8);
            long b1 = AbstractHasher.getLong(this.buffer, 16);
            long b2 = AbstractHasher.getLong(this.buffer, 24);
            long b3 = AbstractHasher.getLong(this.buffer, 32);
            long b4 = AbstractHasher.getLong(this.buffer, 40);
            long b5 = AbstractHasher.getLong(this.buffer, 48);
            long b6 = AbstractHasher.getLong(this.buffer, 56);
            long b7 = AbstractHasher.getLong(this.buffer, 64);
            if (this.init) {
                this.x += b0;
                this.init = false;
            }
            this.processBufferWithoutInit(b0, b1, b2, b3, b4, b5, b6, b7);
        }

        private void processBufferWithoutInit(long b0, long b1, long b2, long b3, long b4, long b5, long b6, long b7) {
            this.x = Long.rotateRight(this.x + this.y + this.v1 + b1, 37) * -5435081209227447693L;
            this.y = Long.rotateRight(this.y + this.v2 + b6, 42) * -5435081209227447693L;
            this.x ^= this.w2;
            this.y += this.v1 + b5;
            this.z = Long.rotateRight(this.z + this.w1, 33) * -5435081209227447693L;
            long a = this.v2 * -5435081209227447693L;
            long b = this.x + this.w1;
            long z1 = b3;
            b = Long.rotateRight(b + (a += b0) + z1, 21);
            long c = a;
            a += b1;
            this.v1 = a + z1;
            this.v2 = (b += Long.rotateRight(a += b2, 44)) + c;
            long a1 = this.z + this.w2;
            long q = this.y + b2;
            long z2 = b7;
            q = Long.rotateRight(q + (a1 += b4) + z2, 21);
            long c1 = a1;
            a1 += b5;
            this.w1 = a1 + z2;
            this.w2 = (q += Long.rotateRight(a1 += b6, 44)) + c1;
            long t = this.z;
            this.z = this.x;
            this.x = t;
        }

        private long hashLen0To16(int bufferCount) {
            if (bufferCount >= 16) {
                long a = AbstractHasher.getLong(this.buffer, 8);
                long b = AbstractHasher.getLong(this.buffer, bufferCount - 8);
                return FarmHashNa.hash8To16Bytes(bufferCount, a, b);
            }
            if (bufferCount >= 12) {
                long a = (long)AbstractHasher.getInt(this.buffer, 8) & 0xFFFFFFFFL;
                long b = (long)AbstractHasher.getInt(this.buffer, bufferCount - 4) & 0xFFFFFFFFL;
                return FarmHashNa.hash4To7Bytes(bufferCount, a, b);
            }
            if (bufferCount > 8) {
                int a = this.buffer[8] & 0xFF;
                int b = this.buffer[(bufferCount >>> 1) + 4] & 0xFF;
                int c = this.buffer[bufferCount - 1] & 0xFF;
                return FarmHashNa.hash1To3Bytes(bufferCount, a, b, c);
            }
            return -7286425919675154353L;
        }

        private long hashLen17To32(int bufferCount) {
            long mul = FarmHashNa.mul(bufferCount);
            long a = AbstractHasher.getLong(this.buffer, 8) * -5435081209227447693L;
            long b = AbstractHasher.getLong(this.buffer, 16);
            long c = AbstractHasher.getLong(this.buffer, bufferCount - 8) * mul;
            long d = AbstractHasher.getLong(this.buffer, bufferCount - 16) * -7286425919675154353L;
            return FarmHashNa.hashLen16(Long.rotateRight(a + b, 43) + Long.rotateRight(c, 30) + d, a + Long.rotateRight(b + -7286425919675154353L, 18) + c, mul);
        }

        private long naHashLen33To64(int bufferCount) {
            long mul = FarmHashNa.mul(bufferCount);
            long a = AbstractHasher.getLong(this.buffer, 8) * -7286425919675154353L;
            long b = AbstractHasher.getLong(this.buffer, 16);
            long c = AbstractHasher.getLong(this.buffer, bufferCount - 8) * mul;
            long d = AbstractHasher.getLong(this.buffer, bufferCount - 16) * -7286425919675154353L;
            long yy = Long.rotateRight(a + b, 43) + Long.rotateRight(c, 30) + d;
            long zz = FarmHashNa.hashLen16(yy, a + Long.rotateRight(b + -7286425919675154353L, 18) + c, mul);
            long e = AbstractHasher.getLong(this.buffer, 24) * mul;
            long f = AbstractHasher.getLong(this.buffer, 32);
            long g = (yy + AbstractHasher.getLong(this.buffer, bufferCount - 32)) * mul;
            long h = (zz + AbstractHasher.getLong(this.buffer, bufferCount - 24)) * mul;
            return FarmHashNa.hashLen16(Long.rotateRight(e + f, 43) + Long.rotateRight(g, 30) + h, e + Long.rotateRight(f + a, 18) + g, mul);
        }

        @Override
        public long getAsLong() {
            return FarmHashNa.this.finalizeHash(this.processRemaining());
        }

        private long processRemaining() {
            if (this.init) {
                if (this.bufferCount <= 40) {
                    if (this.bufferCount <= 24) {
                        return this.hashLen0To16(this.bufferCount);
                    }
                    return this.hashLen17To32(this.bufferCount);
                }
                return this.naHashLen33To64(this.bufferCount);
            }
            AbstractHasher.setLong(this.buffer, 0, AbstractHasher.getLong(this.buffer, 64));
            long g0 = AbstractHasher.getLong(this.buffer, this.bufferCount & 0x3F);
            long g1 = AbstractHasher.getLong(this.buffer, this.bufferCount + 8 & 0x3F);
            long g2 = AbstractHasher.getLong(this.buffer, this.bufferCount + 16 & 0x3F);
            long g3 = AbstractHasher.getLong(this.buffer, this.bufferCount + 24 & 0x3F);
            long g4 = AbstractHasher.getLong(this.buffer, this.bufferCount + 32 & 0x3F);
            long g5 = AbstractHasher.getLong(this.buffer, this.bufferCount + 40 & 0x3F);
            long g6 = AbstractHasher.getLong(this.buffer, this.bufferCount + 48 & 0x3F);
            long g7 = AbstractHasher.getLong(this.buffer, this.bufferCount - 8);
            long mul = -5435081209227447693L + ((this.z & 0xFFL) << 1);
            long w1Local = this.w1 + (long)this.bufferCount - 9L;
            long v1Local = this.v1 + w1Local;
            long xLocal = Long.rotateRight(this.x + this.y + v1Local + g1, 37) * mul;
            long yLocal = Long.rotateRight(this.y + this.v2 + g6, 42) * mul;
            yLocal += v1Local * 9L + g5;
            long zLocal = Long.rotateRight(this.z + (w1Local += v1Local), 33) * mul;
            long a = this.v2 * mul;
            long b = (xLocal ^= this.w2 * 9L) + w1Local;
            b = Long.rotateRight(b + (a += g0) + g3, 21);
            long c = a;
            a += g1;
            b += Long.rotateRight(a += g2, 44);
            v1Local = a + g3;
            long a1 = zLocal + this.w2;
            long b1 = yLocal + g2;
            b1 = Long.rotateRight(b1 + (a1 += g4) + g7, 21);
            long c1 = a1;
            a1 += g5;
            return FarmHashNa.hashLen16(FarmHashNa.hashLen16(v1Local, a1 + g7, mul) + FarmHashNa.shiftMix(yLocal) * -4348849565147123417L + xLocal, FarmHashNa.hashLen16(b + c, (b1 += Long.rotateRight(a1 += g6, 44)) + c1, mul) + zLocal, mul);
        }
    }
}

