/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.hash4j.similarity;

import com.dynatrace.hash4j.util.Preconditions;
import java.util.Collection;
import java.util.Objects;
import java.util.function.IntToLongFunction;
import java.util.function.ToLongFunction;

public interface ElementHashProvider {
    public long getElementHash(int var1);

    public int getNumberOfElements();

    public static ElementHashProvider ofValues(final long ... elementHashes) {
        Objects.requireNonNull(elementHashes);
        Preconditions.checkArgument(elementHashes.length > 0, "Number of elements must be positive.");
        return new ElementHashProvider(){

            @Override
            public long getElementHash(int elementIndex) {
                return elementHashes[elementIndex];
            }

            @Override
            public int getNumberOfElements() {
                return elementHashes.length;
            }
        };
    }

    public static ElementHashProvider ofFunction(final IntToLongFunction elementIndexToHash, final int numberOfElements) {
        Objects.requireNonNull(elementIndexToHash);
        Preconditions.checkArgument(numberOfElements > 0, "Number of elements must be positive.");
        return new ElementHashProvider(){

            @Override
            public long getElementHash(int elementIndex) {
                return elementIndexToHash.applyAsLong(elementIndex);
            }

            @Override
            public int getNumberOfElements() {
                return numberOfElements;
            }
        };
    }

    public static <T> ElementHashProvider ofCollection(Collection<T> collection, ToLongFunction<? super T> elementHashFunction) {
        Objects.requireNonNull(collection);
        Objects.requireNonNull(elementHashFunction);
        return ElementHashProvider.ofValues(collection.stream().mapToLong(elementHashFunction).toArray());
    }
}

