/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.hash4j.similarity;

import com.dynatrace.hash4j.random.PermutationGenerator;
import com.dynatrace.hash4j.random.PseudoRandomGenerator;
import com.dynatrace.hash4j.random.PseudoRandomGeneratorProvider;
import com.dynatrace.hash4j.similarity.AbstractSimilarityHashPolicy;
import com.dynatrace.hash4j.similarity.ElementHashProvider;
import com.dynatrace.hash4j.similarity.SimilarityHasher;
import com.dynatrace.hash4j.util.Preconditions;
import java.util.Arrays;
import java.util.Objects;

final class SuperMinHashPolicy_v1a
extends AbstractSimilarityHashPolicy {
    public SuperMinHashPolicy_v1a(int numberOfComponents, int bitsPerComponent, PseudoRandomGeneratorProvider pseudoRandomGeneratorProvider) {
        super(numberOfComponents, bitsPerComponent, pseudoRandomGeneratorProvider);
    }

    @Override
    public SimilarityHasher createHasher() {
        return new Hasher();
    }

    private class Hasher
    implements SimilarityHasher {
        private final PseudoRandomGenerator pseudoRandomGenerator;
        private final PermutationGenerator permutationGenerator;
        private final long[] hashValuesFractionalPart;
        private final int[] hashValuesIntegralPart;
        private final int[] histogram;

        private Hasher() {
            this.pseudoRandomGenerator = SuperMinHashPolicy_v1a.this.pseudoRandomGeneratorProvider.create();
            this.permutationGenerator = new PermutationGenerator(SuperMinHashPolicy_v1a.this.numberOfComponents);
            this.hashValuesFractionalPart = new long[SuperMinHashPolicy_v1a.this.numberOfComponents];
            this.hashValuesIntegralPart = new int[SuperMinHashPolicy_v1a.this.numberOfComponents];
            this.histogram = new int[SuperMinHashPolicy_v1a.this.numberOfComponents];
        }

        @Override
        public byte[] compute(ElementHashProvider elementHashProvider) {
            Objects.requireNonNull(elementHashProvider);
            int numberOfElements = elementHashProvider.getNumberOfElements();
            Preconditions.checkArgument(numberOfElements > 0, "Number of elements must be positive!");
            this.pseudoRandomGenerator.reset(elementHashProvider.getElementHash(0));
            this.permutationGenerator.reset();
            int hashValueIntegralPart = 0;
            while (hashValueIntegralPart < SuperMinHashPolicy_v1a.this.numberOfComponents) {
                long hashValueFractionalPart = this.pseudoRandomGenerator.nextLong();
                int idx = this.permutationGenerator.next(this.pseudoRandomGenerator);
                this.hashValuesFractionalPart[idx] = hashValueFractionalPart;
                this.hashValuesIntegralPart[idx] = hashValueIntegralPart++;
            }
            int maxHashValuesIntegralPart = SuperMinHashPolicy_v1a.this.numberOfComponents - 1;
            Arrays.fill(this.histogram, 1);
            for (int elementIdx = 1; elementIdx < numberOfElements; ++elementIdx) {
                this.pseudoRandomGenerator.reset(elementHashProvider.getElementHash(elementIdx));
                this.permutationGenerator.reset();
                for (int hashValueIntegralPart2 = 0; hashValueIntegralPart2 <= maxHashValuesIntegralPart; ++hashValueIntegralPart2) {
                    long hashValueFractionalPart = this.pseudoRandomGenerator.nextLong();
                    int idx = this.permutationGenerator.next(this.pseudoRandomGenerator);
                    int currentHashValuesIntegralPart = this.hashValuesIntegralPart[idx];
                    if (currentHashValuesIntegralPart > hashValueIntegralPart2) {
                        this.hashValuesFractionalPart[idx] = hashValueFractionalPart;
                        int n = hashValueIntegralPart2;
                        this.histogram[n] = this.histogram[n] + 1;
                        int n2 = currentHashValuesIntegralPart;
                        this.histogram[n2] = this.histogram[n2] - 1;
                        if (this.histogram[currentHashValuesIntegralPart] == 0) {
                            if (maxHashValuesIntegralPart == this.hashValuesIntegralPart[idx]) {
                                --maxHashValuesIntegralPart;
                            }
                            while (this.histogram[maxHashValuesIntegralPart] == 0) {
                                --maxHashValuesIntegralPart;
                            }
                        }
                        this.hashValuesIntegralPart[idx] = hashValueIntegralPart2;
                        continue;
                    }
                    if (currentHashValuesIntegralPart != hashValueIntegralPart2 || hashValueFractionalPart >= this.hashValuesFractionalPart[idx]) continue;
                    this.hashValuesFractionalPart[idx] = hashValueFractionalPart;
                }
            }
            return SuperMinHashPolicy_v1a.this.packedArrayHandler.create(i -> this.hashValuesFractionalPart[i], SuperMinHashPolicy_v1a.this.numberOfComponents);
        }
    }
}

