/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.com.esotericsoftware.kryo.serializers;

import org.gradle.internal.impldep.com.esotericsoftware.kryo.Kryo;
import org.gradle.internal.impldep.com.esotericsoftware.kryo.io.Input;
import org.gradle.internal.impldep.com.esotericsoftware.kryo.io.InputChunked;
import org.gradle.internal.impldep.com.esotericsoftware.kryo.io.Output;
import org.gradle.internal.impldep.com.esotericsoftware.kryo.io.OutputChunked;
import org.gradle.internal.impldep.com.esotericsoftware.kryo.serializers.FieldSerializer;
import org.gradle.internal.impldep.com.esotericsoftware.kryo.util.ObjectMap;
import org.gradle.internal.impldep.com.esotericsoftware.minlog.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompatibleFieldSerializer<T>
extends FieldSerializer<T> {
    public CompatibleFieldSerializer(Kryo kryo, Class type) {
        super(kryo, type);
    }

    @Override
    public void write(Kryo kryo, Output output, T object) {
        FieldSerializer.CachedField[] fields = this.getFields();
        ObjectMap context = kryo.getGraphContext();
        if (!context.containsKey(this)) {
            context.put(this, null);
            if (Log.TRACE) {
                Log.trace("kryo", "Write " + fields.length + " field names.");
            }
            output.writeVarInt(fields.length, true);
            int n = fields.length;
            for (int i = 0; i < n; ++i) {
                output.writeString(fields[i].field.getName());
            }
        }
        OutputChunked outputChunked = new OutputChunked(output, 1024);
        int n = fields.length;
        for (int i = 0; i < n; ++i) {
            fields[i].write(outputChunked, object);
            outputChunked.endChunks();
        }
    }

    @Override
    public T read(Kryo kryo, Input input, Class<T> type) {
        T object = this.create(kryo, input, type);
        kryo.reference(object);
        ObjectMap context = kryo.getGraphContext();
        FieldSerializer.CachedField[] fields = (FieldSerializer.CachedField[])context.get(this);
        if (fields == null) {
            int length = input.readVarInt(true);
            if (Log.TRACE) {
                Log.trace("kryo", "Read " + length + " field names.");
            }
            String[] names = new String[length];
            for (int i = 0; i < length; ++i) {
                names[i] = input.readString();
            }
            fields = new FieldSerializer.CachedField[length];
            FieldSerializer.CachedField[] allFields = this.getFields();
            block1: for (String schemaName : names) {
                int nn = allFields.length;
                for (int ii = 0; ii < nn; ++ii) {
                    if (!allFields[ii].field.getName().equals(schemaName)) continue;
                    fields[i] = allFields[ii];
                    continue block1;
                }
                if (!Log.TRACE) continue;
                Log.trace("kryo", "Ignore obsolete field: " + schemaName);
            }
            context.put(this, fields);
        }
        InputChunked inputChunked = new InputChunked(input, 1024);
        boolean hasGenerics = this.getGenerics() != null;
        for (FieldSerializer.CachedField cachedField : fields) {
            if (cachedField != null && hasGenerics) {
                cachedField = this.getField(cachedField.field.getName());
            }
            if (cachedField == null) {
                if (Log.TRACE) {
                    Log.trace("kryo", "Skip obsolete field.");
                }
                inputChunked.nextChunks();
                continue;
            }
            cachedField.read(inputChunked, object);
            inputChunked.nextChunks();
        }
        return object;
    }
}

