/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.eclipse.jgit.lib.internal;

import java.net.URISyntaxException;
import java.nio.file.Path;
import java.text.MessageFormat;
import org.gradle.internal.impldep.org.bouncycastle.openpgp.PGPException;
import org.gradle.internal.impldep.org.bouncycastle.util.encoders.Hex;
import org.gradle.internal.impldep.org.eclipse.jgit.api.errors.CanceledException;
import org.gradle.internal.impldep.org.eclipse.jgit.errors.UnsupportedCredentialItem;
import org.gradle.internal.impldep.org.eclipse.jgit.internal.JGitText;
import org.gradle.internal.impldep.org.eclipse.jgit.transport.CredentialItem;
import org.gradle.internal.impldep.org.eclipse.jgit.transport.CredentialsProvider;
import org.gradle.internal.impldep.org.eclipse.jgit.transport.URIish;

class BouncyCastleGpgKeyPassphrasePrompt
implements AutoCloseable {
    private CredentialItem.CharArrayType passphrase;
    private CredentialsProvider credentialsProvider;

    public BouncyCastleGpgKeyPassphrasePrompt(CredentialsProvider credentialsProvider) {
        this.credentialsProvider = credentialsProvider;
    }

    public void clear() {
        if (this.passphrase != null) {
            this.passphrase.clear();
            this.passphrase = null;
        }
    }

    @Override
    public void close() {
        this.clear();
    }

    private URIish createURI(Path keyLocation) throws URISyntaxException {
        return new URIish(keyLocation.toUri().toString());
    }

    public char[] getPassphrase(byte[] keyFingerprint, Path keyLocation) throws PGPException, CanceledException, UnsupportedCredentialItem, URISyntaxException {
        if (this.passphrase == null) {
            this.passphrase = new CredentialItem.CharArrayType(JGitText.get().credentialPassphrase, true);
        }
        if (this.credentialsProvider == null) {
            throw new PGPException(JGitText.get().gpgNoCredentialsProvider);
        }
        if (this.passphrase.getValue() == null && !this.credentialsProvider.get(this.createURI(keyLocation), new CredentialItem.InformationalMessage(MessageFormat.format(JGitText.get().gpgKeyInfo, Hex.toHexString(keyFingerprint))), this.passphrase)) {
            throw new CanceledException(JGitText.get().gpgSigningCancelled);
        }
        return this.passphrase.getValue();
    }
}

