/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentSelector;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.ComponentState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.LenientPlatformDependencyMetadata;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.LenientPlatformResolveMetadata;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.ModuleResolveState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.NodeState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.PotentialEdge;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.ResolveState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.VirtualPlatformState;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.internal.component.external.model.DefaultConfigurationMetadata;
import org.gradle.internal.component.external.model.DefaultModuleComponentIdentifier;
import org.gradle.internal.component.external.model.DefaultModuleComponentSelector;
import org.gradle.internal.component.external.model.ModuleComponentArtifactMetadata;
import org.gradle.internal.component.external.model.ModuleDependencyMetadata;
import org.gradle.internal.component.external.model.VariantMetadataRules;
import org.gradle.internal.component.model.ComponentGraphResolveState;
import org.gradle.internal.component.model.ComponentIdGenerator;
import org.gradle.internal.component.model.ConfigurationMetadata;
import org.gradle.internal.component.model.DefaultComponentGraphResolveState;
import org.gradle.internal.component.model.ExcludeMetadata;
import org.gradle.internal.component.model.VariantGraphResolveState;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSet;
import org.gradle.internal.impldep.com.google.common.collect.Lists;

public class LenientPlatformGraphResolveState
extends DefaultComponentGraphResolveState<LenientPlatformResolveMetadata, LenientPlatformResolveMetadata> {
    private final ComponentIdGenerator componentIdGenerator;
    private final ResolveState resolveState;

    public static LenientPlatformGraphResolveState of(ComponentIdGenerator componentIdGenerator, ModuleComponentIdentifier moduleComponentIdentifier, ModuleVersionIdentifier moduleVersionIdentifier, VirtualPlatformState platformState, NodeState platformNode, ResolveState resolveState) {
        LenientPlatformResolveMetadata metadata = new LenientPlatformResolveMetadata(moduleComponentIdentifier, moduleVersionIdentifier, platformState, platformNode, resolveState);
        return new LenientPlatformGraphResolveState(componentIdGenerator.nextComponentId(), metadata, componentIdGenerator, resolveState);
    }

    private LenientPlatformGraphResolveState(long instanceId, LenientPlatformResolveMetadata metadata, ComponentIdGenerator componentIdGenerator, ResolveState resolveState) {
        super(instanceId, metadata, metadata, resolveState.getAttributeDesugaring(), componentIdGenerator);
        this.componentIdGenerator = componentIdGenerator;
        this.resolveState = resolveState;
    }

    @Override
    @Nullable
    public ComponentGraphResolveState maybeAsLenientPlatform(ModuleComponentIdentifier componentIdentifier, ModuleVersionIdentifier moduleVersionIdentifier) {
        return new LenientPlatformGraphResolveState(this.componentIdGenerator.nextComponentId(), ((LenientPlatformResolveMetadata)this.getMetadata()).withVersion(componentIdentifier, moduleVersionIdentifier), this.componentIdGenerator, this.resolveState);
    }

    public VariantGraphResolveState getDefaultVariant(NodeState from, @Nullable ComponentIdentifier platformId) {
        return this.newResolveStateFor(new LenientPlatformConfigurationMetadata(((LenientPlatformResolveMetadata)this.getMetadata()).getPlatformState(), ((LenientPlatformResolveMetadata)this.getMetadata()).getId(), from, platformId));
    }

    private class LenientPlatformConfigurationMetadata
    extends DefaultConfigurationMetadata
    implements ConfigurationMetadata {
        private final VirtualPlatformState platformState;
        private final NodeState from;
        private final ComponentIdentifier platformId;

        public LenientPlatformConfigurationMetadata(VirtualPlatformState platform, ModuleComponentIdentifier componentId, @Nullable NodeState from, ComponentIdentifier platformId) {
            super(componentId, "default", true, false, (ImmutableSet<String>)ImmutableSet.of((Object)"default"), (ImmutableList<? extends ModuleComponentArtifactMetadata>)ImmutableList.of(), VariantMetadataRules.noOp(), (ImmutableList<ExcludeMetadata>)ImmutableList.of(), ImmutableAttributes.EMPTY, false);
            this.platformState = platform;
            this.from = from;
            this.platformId = platformId;
        }

        @Override
        public List<? extends ModuleDependencyMetadata> getDependencies() {
            List<ModuleDependencyMetadata> result2 = null;
            List<String> candidateVersions = this.platformState.getCandidateVersions();
            Set<ModuleResolveState> modules = this.platformState.getParticipatingModules();
            for (ModuleResolveState module : modules) {
                ComponentState selected = module.getSelected();
                if (selected == null) continue;
                String componentVersion = selected.getId().getVersion();
                for (String target : candidateVersions) {
                    ModuleComponentIdentifier leafId = DefaultModuleComponentIdentifier.newId(module.getId(), target);
                    ModuleComponentSelector leafSelector = DefaultModuleComponentSelector.newSelector(module.getId(), target);
                    ComponentIdentifier platformId = this.platformState.getSelectedPlatformId();
                    if (platformId == null) {
                        platformId = this.platformId;
                    }
                    if (!componentVersion.equals(target)) {
                        PotentialEdge potentialEdge = PotentialEdge.of(LenientPlatformGraphResolveState.this.resolveState, this.from, leafId, leafSelector, platformId, this.platformState.isForced(), false);
                        if (potentialEdge.state == null) continue;
                        result2 = this.registerPlatformEdge(result2, modules, leafId, leafSelector, platformId, this.platformState.isForced());
                        break;
                    }
                    result2 = this.registerPlatformEdge(result2, modules, leafId, leafSelector, platformId, this.platformState.isForced());
                    break;
                }
                this.platformState.attachOrphanEdges();
            }
            return result2 == null ? Collections.emptyList() : result2;
        }

        private List<ModuleDependencyMetadata> registerPlatformEdge(@Nullable List<ModuleDependencyMetadata> result2, Set<ModuleResolveState> modules, ModuleComponentIdentifier leafId, ModuleComponentSelector leafSelector, ComponentIdentifier platformId, boolean force) {
            if (result2 == null) {
                result2 = Lists.newArrayListWithExpectedSize((int)modules.size());
            }
            result2.add(new LenientPlatformDependencyMetadata(LenientPlatformGraphResolveState.this.resolveState, this.from, leafSelector, leafId, platformId, force, false));
            return result2;
        }
    }
}

