/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.lang.model.SourceVersion;
import javax.tools.DiagnosticListener;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import org.gradle.api.JavaVersion;
import org.gradle.api.internal.tasks.compile.CompilationClassBackupService;
import org.gradle.api.internal.tasks.compile.CompilationSourceDirs;
import org.gradle.api.internal.tasks.compile.IncrementalCompilationAwareJavaCompiler;
import org.gradle.api.internal.tasks.compile.incremental.compilerapi.constants.ConstantsAnalysisResult;
import org.gradle.internal.Cast;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.classloader.ClassLoaderFactory;
import org.gradle.internal.classloader.DefaultClassLoaderFactory;
import org.gradle.internal.classloader.FilteringClassLoader;
import org.gradle.internal.classloader.VisitableURLClassLoader;
import org.gradle.internal.classpath.ClassPath;
import org.gradle.internal.classpath.DefaultClassPath;
import org.gradle.internal.jvm.Jvm;
import org.gradle.internal.reflect.DirectInstantiator;

public class JdkTools {
    private static final String DEFAULT_COMPILER_IMPL_NAME = "com.sun.tools.javac.api.JavacTool";
    private final ClassLoader isolatedToolsLoader;
    private final boolean isJava9Compatible;
    private Class<JavaCompiler.CompilationTask> incrementalCompileTaskClass;

    JdkTools(Jvm jvm, List<File> compilerPlugins) {
        DefaultClassLoaderFactory defaultClassLoaderFactory = new DefaultClassLoaderFactory();
        JavaVersion javaVersion = jvm.getJavaVersion();
        boolean java9Compatible = javaVersion.isJava9Compatible();
        ClassLoader filteringClassLoader = this.getSystemFilteringClassLoader(defaultClassLoaderFactory);
        if (!java9Compatible) {
            File toolsJar = jvm.getToolsJar();
            if (toolsJar == null) {
                throw new IllegalStateException("Could not find tools.jar. Please check that " + jvm.getJavaHome().getAbsolutePath() + " contains a valid JDK installation.");
            }
            ClassPath defaultClassPath = DefaultClassPath.of(toolsJar).plus(compilerPlugins);
            this.isolatedToolsLoader = new VisitableURLClassLoader("jdk-tools", filteringClassLoader, defaultClassPath.getAsURLs());
            this.isJava9Compatible = false;
        } else {
            this.isolatedToolsLoader = VisitableURLClassLoader.fromClassPath("jdk-tools", filteringClassLoader, DefaultClassPath.of(compilerPlugins));
            this.isJava9Compatible = true;
        }
    }

    private ClassLoader getSystemFilteringClassLoader(ClassLoaderFactory classLoaderFactory) {
        FilteringClassLoader.Spec filterSpec = new FilteringClassLoader.Spec();
        filterSpec.allowPackage("com.sun.tools");
        filterSpec.allowPackage("com.sun.source");
        return classLoaderFactory.createFilteringClassLoader(ClassLoader.getSystemClassLoader(), filterSpec);
    }

    public JavaCompiler getSystemJavaCompiler() {
        return new DefaultIncrementalAwareCompiler(this.buildJavaCompiler());
    }

    private JavaCompiler buildJavaCompiler() {
        Class<?> clazz;
        try {
            if (this.isJava9Compatible) {
                clazz = this.isolatedToolsLoader.loadClass("javax.tools.ToolProvider");
                try {
                    JavaCompiler compiler = (JavaCompiler)clazz.getDeclaredMethod("getSystemJavaCompiler", new Class[0]).invoke(null, new Object[0]);
                    if (compiler == null) {
                        throw new IllegalStateException("Java compiler is not available. Please check that " + Jvm.current().getJavaHome().getAbsolutePath() + " contains a valid JDK installation.");
                    }
                    return compiler;
                }
                catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                    this.cannotCreateJavaCompiler(e);
                }
            } else {
                clazz = this.isolatedToolsLoader.loadClass(DEFAULT_COMPILER_IMPL_NAME);
            }
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Could not load class 'com.sun.tools.javac.api.JavacTool");
        }
        return DirectInstantiator.instantiate(clazz.asSubclass(JavaCompiler.class), new Object[0]);
    }

    private void cannotCreateJavaCompiler(Exception e) {
        throw new IllegalStateException("Could not create system Java compiler", e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureCompilerTask() {
        if (this.incrementalCompileTaskClass == null) {
            JdkTools jdkTools = this;
            synchronized (jdkTools) {
                try {
                    this.incrementalCompileTaskClass = (Class)Cast.uncheckedCast(this.isolatedToolsLoader.loadClass("org.gradle.internal.compiler.java.IncrementalCompileTask"));
                }
                catch (ClassNotFoundException e) {
                    throw UncheckedException.throwAsUncheckedException(e);
                }
            }
        }
    }

    private class DefaultIncrementalAwareCompiler
    implements IncrementalCompilationAwareJavaCompiler {
        private final JavaCompiler delegate;

        private DefaultIncrementalAwareCompiler(JavaCompiler delegate) {
            this.delegate = delegate;
        }

        @Override
        public JavaCompiler.CompilationTask getTask(Writer out, JavaFileManager fileManager, DiagnosticListener<? super JavaFileObject> diagnosticListener, Iterable<String> options, Iterable<String> classes, Iterable<? extends JavaFileObject> compilationUnits) {
            return this.delegate.getTask(out, fileManager, diagnosticListener, options, classes, compilationUnits);
        }

        @Override
        public StandardJavaFileManager getStandardFileManager(DiagnosticListener<? super JavaFileObject> diagnosticListener, Locale locale, Charset charset) {
            return this.delegate.getStandardFileManager(diagnosticListener, locale, charset);
        }

        @Override
        public String name() {
            return this.delegate.name();
        }

        @Override
        public int run(InputStream in, OutputStream out, OutputStream err, String ... arguments) {
            return this.delegate.run(in, out, err, arguments);
        }

        @Override
        public Set<SourceVersion> getSourceVersions() {
            return this.delegate.getSourceVersions();
        }

        @Override
        public int isSupportedOption(String option) {
            return this.delegate.isSupportedOption(option);
        }

        @Override
        public JavaCompiler.CompilationTask makeIncremental(JavaCompiler.CompilationTask task, Map<String, Set<String>> sourceToClassMapping, ConstantsAnalysisResult constantsAnalysisResult, CompilationSourceDirs compilationSourceDirs, CompilationClassBackupService classBackupService) {
            JdkTools.this.ensureCompilerTask();
            Object[] objectArray = new Object[6];
            objectArray[0] = task;
            objectArray[1] = compilationSourceDirs::relativize;
            objectArray[2] = classBackupService::maybeBackupClassFile;
            objectArray[3] = sourceToClassMapping::putAll;
            objectArray[4] = constantsAnalysisResult::addPublicDependent;
            objectArray[5] = constantsAnalysisResult::addPrivateDependent;
            return (JavaCompiler.CompilationTask)DirectInstantiator.instantiate(JdkTools.this.incrementalCompileTaskClass, objectArray);
        }
    }
}

