/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.incremental.compilerapi;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.gradle.api.internal.tasks.compile.incremental.compilerapi.constants.ConstantToDependentsMapping;
import org.gradle.api.internal.tasks.compile.incremental.compilerapi.deps.DependentSetSerializer;
import org.gradle.api.internal.tasks.compile.incremental.compilerapi.deps.DependentsSet;
import org.gradle.api.internal.tasks.compile.incremental.serialization.HierarchicalNameSerializer;
import org.gradle.internal.serialize.AbstractSerializer;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.Encoder;
import org.gradle.internal.serialize.MapSerializer;
import org.gradle.internal.serialize.SetSerializer;

public class CompilerApiData {
    private final boolean isAvailable;
    private final boolean supportsConstantsMapping;
    private final Map<String, Set<String>> sourceToClassMapping;
    private final ConstantToDependentsMapping constantToDependentsMapping;

    private CompilerApiData(boolean isAvailable, boolean supportsConstantsMapping, Map<String, Set<String>> sourceToClassMapping, ConstantToDependentsMapping constantToDependentsMapping) {
        this.isAvailable = isAvailable;
        this.supportsConstantsMapping = supportsConstantsMapping;
        this.sourceToClassMapping = sourceToClassMapping;
        this.constantToDependentsMapping = constantToDependentsMapping;
    }

    public DependentsSet getConstantDependentsForClass(String constantOrigin) {
        return this.constantToDependentsMapping.getConstantDependentsForClass(constantOrigin);
    }

    public ConstantToDependentsMapping getConstantToClassMapping() {
        return this.constantToDependentsMapping;
    }

    public boolean isAvailable() {
        return this.isAvailable;
    }

    public boolean isSupportsConstantsMapping() {
        return this.supportsConstantsMapping;
    }

    public static CompilerApiData unavailable() {
        return new CompilerApiData(false, false, Collections.emptyMap(), ConstantToDependentsMapping.empty());
    }

    public static CompilerApiData withoutConstantsMapping(Map<String, Set<String>> sourceToClassMapping) {
        return new CompilerApiData(true, false, sourceToClassMapping, ConstantToDependentsMapping.empty());
    }

    public static CompilerApiData withConstantsMapping(Map<String, Set<String>> sourceToClassMapping, ConstantToDependentsMapping constantToDependentsMapping) {
        return new CompilerApiData(true, true, sourceToClassMapping, constantToDependentsMapping);
    }

    public Map<String, Set<String>> getSourceToClassMapping() {
        return this.sourceToClassMapping;
    }

    public static final class Serializer
    extends AbstractSerializer<CompilerApiData> {
        private final Supplier<HierarchicalNameSerializer> classNameSerializerSupplier;
        private final DependentSetSerializer dependentSetSerializer;

        public Serializer(Supplier<HierarchicalNameSerializer> classNameSerializerSupplier) {
            this.classNameSerializerSupplier = classNameSerializerSupplier;
            this.dependentSetSerializer = new DependentSetSerializer(classNameSerializerSupplier);
        }

        @Override
        public CompilerApiData read(Decoder decoder) throws Exception {
            boolean isAvailable = decoder.readBoolean();
            if (!isAvailable) {
                return CompilerApiData.unavailable();
            }
            HierarchicalNameSerializer nameSerializer = this.classNameSerializerSupplier.get();
            MapSerializer<String, String> sourceToClassSerializer = new MapSerializer<String, String>(nameSerializer, new SetSerializer<String>(nameSerializer));
            Object sourceToClassMapping = sourceToClassSerializer.read(decoder);
            if (!decoder.readBoolean()) {
                return CompilerApiData.withoutConstantsMapping((Map<String, Set<String>>)sourceToClassMapping);
            }
            MapSerializer<String, DependentsSet> constantDependentsSerializer = new MapSerializer<String, DependentsSet>(nameSerializer, this.dependentSetSerializer);
            Object constantDependents = constantDependentsSerializer.read(decoder);
            return CompilerApiData.withConstantsMapping((Map<String, Set<String>>)sourceToClassMapping, new ConstantToDependentsMapping((Map<String, DependentsSet>)constantDependents));
        }

        @Override
        public void write(Encoder encoder, CompilerApiData value) throws Exception {
            encoder.writeBoolean(value.isAvailable());
            if (value.isAvailable()) {
                HierarchicalNameSerializer nameSerializer = this.classNameSerializerSupplier.get();
                MapSerializer<String, String> sourceToClassSerializer = new MapSerializer<String, String>(nameSerializer, new SetSerializer<String>(nameSerializer));
                sourceToClassSerializer.write(encoder, value.getSourceToClassMapping());
                boolean supportsConstantsMapping = value.isSupportsConstantsMapping();
                encoder.writeBoolean(supportsConstantsMapping);
                if (supportsConstantsMapping) {
                    MapSerializer<String, DependentsSet> constantDependentsSerializer = new MapSerializer<String, DependentsSet>(nameSerializer, this.dependentSetSerializer);
                    constantDependentsSerializer.write(encoder, value.getConstantToClassMapping().getConstantDependents());
                }
            }
        }
    }
}

